

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCGetPackagePublishInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCGetPackagePublishInfo()
--  | Description:  Returns minimal publish information for a package by package name.
--  |               Useful in autoupdating packages that do not have GUIDs.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCGetPackagePublishInfo.sp,v $ $Id: DCGetPackagePublishInfo.sp,v 1.1.2.3 2018/03/27 08:48:54 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DCGetPackagePublishInfo <<<'

IF EXISTS (select * from sysobjects where name='DCGetPackagePublishInfo')
	drop procedure DCGetPackagePublishInfo
IF EXISTS (select * from GxQscripts where name='DCGetPackagePublishInfo')
	delete from GxQscripts where name = 'DCGetPackagePublishInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetPackagePublishInfo')
	delete from GXDBVersions where aliasname = 'DCGetPackagePublishInfo'
GO
print '... Creating Procedure: DCGetPackagePublishInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCGetPackagePublishInfo
  @s_packageName NVARCHAR(MAX) = ''
AS
BEGIN
SET QUOTED_IDENTIFIER ON
       --SET NOCOUNT ON
  DECLARE @o_xmlText XML
       IF EXISTS (SELECT * FROM DCPackage WHERE PackageName = @s_packageName)
       BEGIN
              SET @o_xmlText       =
              (
                     SELECT A.PackageId AS '@packageId',
                              packageName AS '@name',
                              (
                                         SELECT P.PlatformId AS '@id', p.PlatformName AS '@name'
                                         FROM DCPackagePlatform PP
                                         INNER JOIN DCPlatform P
                                         on PP.PlatformId = P.PlatformId
                                         and A.PackageId = PP.PackageId and pp.Attribute & 4=0
                                         FOR XML path ('platforms'), TYPE
                              ),
                              (
                                         SELECT
                                         (
                                                SELECT       ISNULL(PackageXML.value('(/extraPropContainer/customScriptDescription/@guid)[1]', 'nvarchar(max)'), '') AS '@guid',
                                                              ISNULL(NULLIF(PackageXML.value('(/extraPropContainer/customScriptDescription/@revision)[1]', 'nvarchar(max)'), ''), '$Revision: 1.1.2.3 $') AS '@revision',
                                                              (
                                                                     SELECT ISNULL(PackageXML.value('(/extraPropContainer/customScriptDescription/minCommCellVersion/@releaseID)[1]', 'int'), 0) AS '@releaseID',
                                                                     ISNULL(PackageXML.value('(/extraPropContainer/customScriptDescription/minCommCellVersion/@servicePack)[1]', 'int'), 0) AS '@servicePack'
                                                                     FOR XML PATH ('minCommCellVersion'), TYPE
                                                              )
                                                              FOR XML PATH ('customScriptDescription'), TYPE
                                         ) FOR XML PATH('extraPropContainer'), TYPE
                              )
                                  FROM DCPackage A
                                  where PackageName = @s_packageName and PackageStatus = 0
                                  FOR XML PATH ('App_DCPackage')
              )
       END
       ELSE
       BEGIN
              SET @o_xmlText       = (
                     SELECT
                           (
                                  SELECT
                                         'Package not found' AS '@errorMessage',
                                         1 AS '@errorCode'
                                         FOR XML PATH ('errorDetail'), TYPE
                           ) FOR XML PATH ('App_DCPackage')
              )
       END
       SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCGetPackagePublishInfo')
	delete from GxQscripts where name = 'DCGetPackagePublishInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetPackagePublishInfo')
	delete from GXDBVersions where aliasname = 'DCGetPackagePublishInfo'
GO

insert into GXDBVersions values(2, 'DCGetPackagePublishInfo',  '00010001000200030000', 'DCGetPackagePublishInfo', '00010001000200030000')
GO

