

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCGetPackagePlatformInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCGetPackagePlatformInfo
--  | Description:  Fetch package location and readme info for given package id and optional platform id / download type
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCGetPackagePlatformInfo.sp,v $ $Id: DCGetPackagePlatformInfo.sp,v 1.1.2.4 2020/08/05 00:54:53 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DCGetPackagePlatformInfo')
BEGIN
	print '>>> Drop Stored Procedure: DCGetPackagePlatformInfo <<<'
	drop procedure DCGetPackagePlatformInfo
END
IF EXISTS (select * from GxQscripts where name='DCGetPackagePlatformInfo')
	delete from GxQscripts where name = 'DCGetPackagePlatformInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetPackagePlatformInfo')
	delete from GXDBVersions where aliasname = 'DCGetPackagePlatformInfo'
GO
print '... Creating Procedure: DCGetPackagePlatformInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCGetPackagePlatformInfo
  @i_PackageId INT,
  @i_PlatformId INT = 0,
  @i_DownloadType nvarchar(255) = '',
  @i_GetPackagesChecksumCalcPending int = 0,
  @i_WSClientid int = 0
AS
BEGIN
	DECLARE @i_DownloadTypeId INT = 0
	IF @i_DownloadType IS NULL
	BEGIN
		SET @i_DownloadType = ''
	END
	SELECT @i_DownloadTypeId = DownloadTypeId, @i_DownloadType = DownloadType
	FROM DCDownloadType
	WHERE DownloadType = @i_DownloadType
	IF @i_DownloadTypeId IS NULL
		SET @i_DownloadTypeId = 0
	IF @i_PlatformId IS NULL
		SET @i_PlatformId = 0
	;WITH CTE AS (
		SELECT PP.PackageId,
		(SELECT PR.NetworkPath FROM DCPackageRepository PR WITH(NOLOCK) WHERE PR.PackageRepositoryId = PP.ReadMeRepositoryId) ReadmeRepNetworkPath,
		(SELECT PR.DomainUserName FROM DCPackageRepository PR WITH(NOLOCK) WHERE PR.PackageRepositoryId = PP.ReadMeRepositoryId) ReadmeRepUsername,
		(SELECT PR.Password FROM DCPackageRepository PR WITH(NOLOCK) WHERE PR.PackageRepositoryId = PP.ReadMeRepositoryId) ReadmeRepPassword,
		(SELECT PR.RepositoryType FROM DCPackageRepository PR WITH(NOLOCK) WHERE PR.PackageRepositoryId = PP.ReadMeRepositoryId) ReadmeRepType,
		(SELECT PR.ClientId FROM DCPackageRepository PR WITH(NOLOCK) WHERE PR.PackageRepositoryId = PP.ReadMeRepositoryId) ReadmeRepClientId,
		PP.PackagePlatformMappingId, PP.Location, PP.ReadMeLocation, PP.ReadMeUpdatedTime, PP.ReadMeRepositoryId, PP.PlatformId, PP.DownloadTypeId,
		DT.DownloadType,
		PL.PlatformName,
		P.PackageName,
		R.RepositoryType, R.NetworkPath, R.ClientId, R.DomainUserName, R.Password, R.PackageRepositoryId,
		ROW_NUMBER() OVER (ORDER BY PackagePlatformMappingId) RowNum
		FROM DCPackagePlatform PP WITH (NOLOCK)
		JOIN DCPackage P WITH(NOLOCK) ON PP.PackageId = P.PackageId
		JOIN DCPackageRepository R WITH(NOLOCK) ON R.PackageRepositoryId = PP.PackageRepositoryId
		JOIN DCDownloadType DT WITH(NOLOCK) ON PP.DownloadTypeId = DT.DownloadTypeId
		JOIN DCPlatform PL WITH(NOLOCK) ON PP.PlatformId = PL.PlatformId
		WHERE
		(@i_GetPackagesChecksumCalcPending = 0
			AND PP.PackageId = @i_PackageId)
		OR (@i_GetPackagesChecksumCalcPending = 1 AND
			PP.Attribute = 0 AND
			(R.RepositoryType IN (2, 3) OR (R.RepositoryType = 1 AND R.ClientId = @i_WSClientid))  AND ISNULL(PP.PackageCheckSum, '') = '')
		)
	SELECT C.PackageName as PackageName,
	C.PackagePlatformMappingId as PlatformMappingID,
	C.Location AS PackageLocation,
	C.ClientId as PackageRepClientId,
	ISNULL(C.NetworkPath, '') AS PackageNetworkPath,
	ISNULL(C.DomainUserName, '') as PackageRepUserName,
	ISNULL(C.Password, '') as PackageRepPassword,
	C.RepositoryType as PackageRepType,
	C.ReadmeLocation,
	C.ReadmeRepClientId as ReadmeRepClientId,
	ISNUll(C.ReadmeRepUsername, '') as ReadmeRepUsername,
	ISNULL(C.ReadmeRepPassword, '') as ReadmeRepPassword,
	C.ReadmeRepType as ReadmeRepType,
	C.ReadMeUpdatedTime as ReadmeUpdateTime,
	ISNULL(C.ReadmeRepNetworkPath, '') AS ReadmeRepNetworkPath,
	C.ReadMeRepositoryId as ReadmePackageRepId,
	C.PlatformId,
	C.DownloadTypeId,
	C.DownloadType,
	C.PackageRepositoryId FROM CTE C
	WHERE ((@i_PlatformId = 0) OR C.PlatformId = @i_PlatformId)
	AND ((@i_DownloadTypeId = 0) OR C.DownloadTypeId = @i_DownloadTypeId)
	AND ((C.RowNum < 100 AND @i_GetPackagesChecksumCalcPending = 1) or @i_GetPackagesChecksumCalcPending = 0)
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCGetPackagePlatformInfo')
	delete from GxQscripts where name = 'DCGetPackagePlatformInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetPackagePlatformInfo')
	delete from GXDBVersions where aliasname = 'DCGetPackagePlatformInfo'
GO

insert into GXDBVersions values(2, 'DCGetPackagePlatformInfo',  '00010001000200040000', 'DCGetPackagePlatformInfo', '00010001000200040000')
GO

