

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCGetPackage.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCGetPackage()
--  | Description:  Returns package information based on package id
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCGetPackage.sp,v $ $Id: DCGetPackage.sp,v 1.7.2.6 2020/06/28 16:57:40 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DCGetPackage')
BEGIN
	print '>>> Drop Stored Procedure: DCGetPackage <<<'
	drop procedure DCGetPackage
END
IF EXISTS (select * from GxQscripts where name='DCGetPackage')
	delete from GxQscripts where name = 'DCGetPackage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetPackage')
	delete from GXDBVersions where aliasname = 'DCGetPackage'
GO
print '... Creating Procedure: DCGetPackage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCGetPackage
  @packageId int,
  @packageName varchar(255) = ''
AS
BEGIN
	IF ISNULL(@packageName, '')<> ''
		SELECT @packageId = PackageId FROM DCPackage WHERE PackageName = @packageName
	SELECT
		P.PackageId '@packageId', P.PackageName '@name', P.Description '@description', P.RemoteSecureAccessLink '@remoteSecureAccessLink', P.ProductId '@productId', P.packageRank '@rank', P.PriceWeightage '@priceWeightage', P.PackageIconFileName '@packageIconFileName',
		P.IconImage '@packageIcon',
		P.BOLLink '@bolLink', dbo.GetUnixTime(P.StartDate) '@validFrom', P.Notification '@notification', (CASE WHEN P.EndDate IS NULL THEN 0 ELSE dbo.GetUnixTime(P.EndDate) END) AS '@validTo',
		(
			SELECT SecuredEntityGuid '@guid', SecuredEntityType '@type',SecuredEntityLoginName '@name' FROM DCPackageVisibility
			WHERE PackageId = @packageId and VisbilityFlags & 1 = 1
			FOR XML PATH ('visibleTo'), TYPE
		),
		(
			SELECT SecuredEntityGuid '@guid', SecuredEntityType '@type',SecuredEntityLoginName '@name' FROM DCPackageVisibility
			WHERE PackageId = @packageId and VisbilityFlags & 2 = 2
			FOR XML PATH ('notVisibleTo'), TYPE
		),
		(
			SELECT SecuredEntityGuid '@guid', SecuredEntityType '@type',SecuredEntityLoginName '@name' FROM DCPackageVisibility
			WHERE PackageId = @packageId and VisbilityFlags & 4 = 4
			FOR XML PATH ('earlyPreviewUsers'), TYPE
		),
		(
			SELECT SecuredEntityGuid '@guid', SecuredEntityType '@type',SecuredEntityLoginName '@name' FROM DCPackageVisibility
			WHERE PackageId = @packageId and VisbilityFlags & 8 = 8
			FOR XML PATH ('notificatonUsers'), TYPE
		),
		(
			SELECT C.CategoryId AS '@id', C.CategoryName '@name', C.Description '@description'
			FROM DCCategory C WHERE C.CategoryId = P.CategoryId
			FOR XML PATH('category'), TYPE
		),
		(
			SELECT S.SubCategoryId AS '@id', SubCategoryName '@name', S.Description '@description'
			FROM DCSubCategory S WHERE S.SubCategoryId = P.SubCategoryId
			FOR XML PATH('subCategory'), TYPE
		),
		(
			SELECT PL.PlatformId AS '@id', PL.PlatformName '@name', PP.PackageSize '@size', PP.Location '@location', PP.ReadMeLocation '@readMeLocation', PP.DownloadAction '@downloadAction',
			PP.PackageCheckSum as '@checksum',
			(
				SELECT D.DownloadTypeId AS '@id', D.DownloadType '@name'
				FROM DCDownloadType D WHERE D.DownloadTypeId = PP.DownloadTypeId
				FOR XML PATH('downloadType'), TYPE
			),
			(
				SELECT DPP.PackageRepositoryId as '@repositoryId', DPP.RepositoryName as '@respositoryName', DPP.NetworkPath as '@networkPath',
				DPP.RepositoryType as '@serverType'
				FROM DCPackageRepository DPP where DPP.PackageRepositoryId = PP.PackageRepositoryId
				FOR XML PATH('pkgRepository'), TYPE
			),
			(
				SELECT RDPP.PackageRepositoryId as '@repositoryId', RDPP.RepositoryName as '@respositoryName', RDPP.NetworkPath as '@networkPath' ,
				RDPP.RepositoryType as '@serverType'
				FROM DCPackageRepository DPP where DPP.PackageRepositoryId = PP.ReadmeRepositoryId
				FOR XML PATH('readmeRepository'), TYPE
			)
			FROM DCPackagePlatform PP
			INNER JOIN DCPlatform PL ON PP.PlatformId = PL.PlatformId
			INNER JOIN DCPackageRepository DPP ON PP.PackageRepositoryId = DPP.PackageRepositoryId
			LEFT JOIN DCPackageRepository RDPP ON PP.ReadMeRepositoryId = RDPP.PackageRepositoryId
			WHERE PL.PlatformId = PP.PlatformId AND PP.PackageId = @packageId AND PP.Attribute & 4 = 0
			FOR XML PATH('platforms'), TYPE
		),
		(
			SELECT ProductVersionId AS '@id', V.Name '@name'
			FROM DCProductVersion V WHERE V.ProductVersionId = P.ProductVersionId
			FOR XML PATH('productVersion'), TYPE
		),
		(
			SELECT VendorId as '@id', VE.Vendor '@name'
			FROM DCVendor VE
			WHERE VE.VendorId = P.VendorId
			FOR XML PATH('vendor'), TYPE
		),
		P.PackageXML.query('/extraPropContainer')
	FROM DCPackage P
	WHERE P.PackageId = @packageId
	ORDER BY ISNULL(P.ModifiedTime, P.CreateTime) DESC
	FOR XML PATH('App_DCPackage')
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCGetPackage')
	delete from GxQscripts where name = 'DCGetPackage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetPackage')
	delete from GXDBVersions where aliasname = 'DCGetPackage'
GO

insert into GXDBVersions values(2, 'DCGetPackage',  '00010007000200060000', 'DCGetPackage', '00010007000200060000')
GO

