

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCGetDownloadCenterLookupData.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCGetDownloadCenterLookupData()
--  | Description:  Returns data such as users, user groups, platforms etc for download center
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCGetDownloadCenterLookupData.sp,v $ $Id: DCGetDownloadCenterLookupData.sp,v 1.3.62.1 2018/03/27 08:50:51 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DCGetDownloadCenterLookupData <<<'

IF EXISTS (select * from sysobjects where name='DCGetDownloadCenterLookupData')
	drop procedure DCGetDownloadCenterLookupData
IF EXISTS (select * from GxQscripts where name='DCGetDownloadCenterLookupData')
	delete from GxQscripts where name = 'DCGetDownloadCenterLookupData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetDownloadCenterLookupData')
	delete from GXDBVersions where aliasname = 'DCGetDownloadCenterLookupData'
GO
print '... Creating Procedure: DCGetDownloadCenterLookupData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCGetDownloadCenterLookupData
  @i_GetUsers BIT = 1, 
  @i_GetCommCellGroups BIT = 1, 
  @i_GetExternalGroups BIT = 1, 
  @i_GetCategories BIT = 1,
  @i_GetSubCategories BIT = 1,
  @i_GetPlatforms BIT = 1,
  @i_GetDownloadTypes BIT = 1,
  @i_GetProductVersions BIT = 1,
  @i_GetRecutNumbers BIT = 1,
  @i_GetVendors BIT = 1,
  @i_GetServerTypes BIT = 0,
  @i_GetDownloadedPackageUsers BIT = 0,
  @i_PackageId INT = 0,
  @s_WebServerIdList VARCHAR(1024) = ''
AS
BEGIN
	SET QUOTED_IDENTIFIER ON
	--SET NOCOUNT ON
	DECLARE @CommCellUserType INT
	SELECT @CommCellUserType = EntryValue FROM DCReference WHERE TypeName = 'SecuredEntity' AND EntryName = 'CommCellUser'
	DECLARE @ExternalUserType INT
	SELECT @ExternalUserType = EntryValue FROM DCReference WHERE TypeName = 'SecuredEntity' AND EntryName = 'ExternalUser'
	DECLARE @CommCellGroupType INT
	SELECT @CommCellGroupType = EntryValue FROM DCReference WHERE TypeName = 'SecuredEntity' AND EntryName = 'CommCellGroup'
	DECLARE @ExternalGroupType INT
	SELECT @ExternalGroupType = EntryValue FROM DCReference WHERE TypeName = 'SecuredEntity' AND EntryName = 'ExternalGroup'
  DECLARE @o_xmlText XML
	SET @o_xmlText =
	(
	 SELECT
		(
		 	SELECT U.id '@id', userGuid '@guid' , U.login '@name', U.umDSproviderId AS '@providerId',
		 	P.serviceType AS '@serviceType', (CASE WHEN U.umDSproviderId = 0 THEN @CommCellUserType ELSE @ExternalUserType END) As '@type'
			FROM UMUsers U JOIN UMDSProviders P ON U.umDSproviderId = P.id
			WHERE @i_GetUsers = 1 AND U.flags <> 0 AND U.id > 0 AND LEN(ISNULL(userGuid, '')) > 0
			ORDER BY (case when u.umDSproviderId = 0 then 'A-CommCellUsers' Else p.domainName END), U.login
		 	FOR XML PATH('usersAndGroups'), TYPE
		 ),
		 (
		 	SELECT id '@id', name '@name', UG.GUID AS '@guid', 0 AS '@providerId',
		 	1 AS '@serviceType', @CommCellGroupType As '@type'
		 	FROM UMGroups UG
		 	WHERE @i_GetCommCellGroups = 1 AND UG.groupFlags & 1 = 1
		 	order by name
			FOR XML PATH('usersAndGroups'), TYPE
		 ),
		 (
			SELECT UG.id '@id', umdsProviderId '@providerId',
			serviceType '@serviceType', (UP.domainName + '\' + UG.name) AS '@name',
			('cvlt_' + UP.domainName + '\' + UG.name) as '@guid',
			@ExternalGroupType As '@type'
			FROM UMDSgroups UG INNER JOIN UMDSProviders UP ON UG.umdsProviderId = UP.id
			WHERE @i_GetExternalGroups = 1 AND ug.enabled = 1 AND up.serviceType = 2 -- Returning only AD (external) groups for download center.
			ORDER BY UG.umdsProviderId, UG.name
		 	FOR XML PATH('usersAndGroups'), TYPE
		 ),
		 (
			SELECT 0 As '@entityType', CategoryId '@id', CategoryName '@name', [Description] AS '@description', Attribute as '@attribute' FROM DCCategory
			WHERE @i_GetCategories = 1
			ORDER BY CategoryName
			FOR XML PATH('categories'),  TYPE
		 ),
		 (
			SELECT 1 AS '@entityType', SubCategoryId '@id', SubCategoryName '@name', [Description] as '@description', CategoryId as '@categoryId', Attribute '@attribute'
			FROM DCSubCategory
			WHERE @i_GetSubCategories = 1
			ORDER BY SubCategoryName
			FOR XML PATH('subCategories'), TYPE
		 ),
		(
			SELECT 2 As '@entityType', PlatformId '@id', PlatformName '@name', Architecture '@architectureName'
			FROM DCPlatform
			WHERE @i_GetPlatforms = 1
			ORDER BY PlatformName
			FOR XML PATH('platforms'), TYPE
		),
		(
			SELECT 4 AS '@entityType', DownloadTypeId '@id', DownloadType '@name' FROM DCDownloadType
			WHERE @i_GetDownloadTypes = 1
			ORDER BY DownloadType
			FOR XML PATH('downloadTypes'), TYPE
		),
		(
			SELECT 3 as '@entityType', ProductVersionId '@id', Name '@name' FROM DCProductVersion
			WHERE @i_GetProductVersions = 1
			FOR XML PATH('productVersions'), TYPE
		),
		(
			SELECT 4 AS '@entityType', RecutNumberId '@id', RecutName '@name' FROM DCRecutNumber
			WHERE @i_GetRecutNumbers = 1
			FOR XML PATH('recutNumbers'), TYPE
		),
		(
			SELECT 6 AS '@entityType', V.VendorId '@id', V.Vendor '@name' FROM DCVendor V
			WHERE @i_GetVendors = 1
			ORDER BY V.Vendor
			FOR XML PATH('vendors'), TYPE
		),
		(
			SELECT 7 AS '@entityType', (CASE WHEN ISNULL(PR.ClientId, 0) > 0 THEN 1 ELSE PR.RepositoryType END) AS '@attribute', PR.PackageRepositoryId AS '@id',
			PR.RepositoryName AS '@internalName', ISNULL((SELECT TOP 1 NAME FROM APP_CLIENT C WHERE C.id = PR.ClientId),PR.RepositoryName) AS '@name',
			(
				SELECT ExtraProperties FROM DCPackageRepository R WHERE R.PackageRepositoryId = PR.PackageRepositoryId
				--FOR XML PATH('properties'), root('serversForBrowse')
			)
			FROM DCPackageRepository PR
			WHERE @i_GetServerTypes = 1
			FOR XML PATH('serversForBrowse'), TYPE
		)
		FOR XML PATH('App_DCGetDataToCreatePackageResp')
	)
	SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCGetDownloadCenterLookupData')
	delete from GxQscripts where name = 'DCGetDownloadCenterLookupData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetDownloadCenterLookupData')
	delete from GXDBVersions where aliasname = 'DCGetDownloadCenterLookupData'
GO

insert into GXDBVersions values(2, 'DCGetDownloadCenterLookupData',  '00010003006200010000', 'DCGetDownloadCenterLookupData', '00010003006200010000')
GO

