

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCGetCommCellGroups.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCGetCommCellGroups()
--  | Description:  Returns two data tables: 1. List of groups to which user belongs to, and 2. Provider and service type for given user.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCGetCommCellGroups.sp,v $ $Id: DCGetCommCellGroups.sp,v 1.4.66.2 2018/03/27 08:48:38 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DCGetCommCellGroups <<<'

IF EXISTS (select * from sysobjects where name='DCGetCommCellGroups')
	drop procedure DCGetCommCellGroups
IF EXISTS (select * from GxQscripts where name='DCGetCommCellGroups')
	delete from GxQscripts where name = 'DCGetCommCellGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetCommCellGroups')
	delete from GXDBVersions where aliasname = 'DCGetCommCellGroups'
GO
print '... Creating Procedure: DCGetCommCellGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCGetCommCellGroups
  @i_userGuid NVARCHAR(128)
AS
BEGIN
		DECLARE @i_UserId int = 0
		IF object_id('tempdb.dbo.#GroupsForUser') IS NOT NULL
		BEGIN
			drop table #GroupsForUser
		END
		CREATE TABLE #GroupsForUser (
			userGroupId  integer
		)
		SET @i_userid = (select top 1 id from umusers where [userGUID] = @i_userGuid AND enabled = 1 AND flags <> 0)
		insert into #GroupsForUser(userGroupId)
		EXEC sec_getLocalUserGroupsOfUser @i_UserId
		SELECT UG.id, CONVERT(VARCHAR(36), UG.GUID) [Guid] FROM #GroupsForUser G
		JOIN UMGroups UG ON G.userGroupId = ug.id
		SELECT P.id AS ProviderId, P.serviceType FROM UMUsers U JOIN UMDSProviders P ON U.umDSproviderId = P.id and u.enabled = 1 AND u.flags <> 0
		WHERE userGuid = @i_userGuid
		Select guid AS UserGuidOfEveryOne from UMGroups where name = 'everyone'
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCGetCommCellGroups')
	delete from GxQscripts where name = 'DCGetCommCellGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetCommCellGroups')
	delete from GXDBVersions where aliasname = 'DCGetCommCellGroups'
GO

insert into GXDBVersions values(2, 'DCGetCommCellGroups',  '00010004006600020000', 'DCGetCommCellGroups', '00010004006600020000')
GO

