

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCDeletePackage.sp] ---------- 

--  +=====================================================================================+
--  |		 		 Name:  DCDeletePackage
--  | Description:  Delete specified package data from dcpackageplatform, dcpackage tables
--  +=====================================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DCDeletePackage <<<'

IF EXISTS (select * from sysobjects where name='DCDeletePackage')
	drop procedure DCDeletePackage
IF EXISTS (select * from GxQscripts where name='DCDeletePackage')
	delete from GxQscripts where name = 'DCDeletePackage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCDeletePackage')
	delete from GXDBVersions where aliasname = 'DCDeletePackage'
GO
print '... Creating Procedure: DCDeletePackage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCDeletePackage
  @PackageId INT,
  @SoftDelete INT
AS
BEGIN
	DECLARE @ErrCode INT
	BEGIN TRAN
	IF @SoftDelete = 0
	BEGIN
		DELETE FROM DCPackagePlatform
		WHERE PackageId = @PackageId
		SET @ErrCode = @@ERROR
		IF @@ERROR = 0
		BEGIN
			DELETE FROM DCPackage
			WHERE PackageId = @PackageId
			SET @ErrCode = @@ERROR
		END
	END
	ELSE
	BEGIN
		UPDATE DCPackage set PackageStatus = 1  -- AppMsg.DCPackageStatus enum "delete" value
		where PackageId = @PackageId
		SET @ErrCode = @@ERROR
	END
	if @ErrCode = 0
	BEGIN
		COMMIT TRAN
	END
	ELSE
	BEGIN
		ROLLBACK TRAN
	END
	SELECT @ErrCode AS ReturnCode
END

IF EXISTS (select * from GxQscripts where name = 'DCDeletePackage')
	delete from GxQscripts where name = 'DCDeletePackage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCDeletePackage')
	delete from GXDBVersions where aliasname = 'DCDeletePackage'
GO

insert into GXDBVersions values(2, 'DCDeletePackage',  '00000000000000000000', 'DCDeletePackage', '00000000000000000000')
GO

