

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DAUpdateBackupClientsPropForCleanup.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  DAUpdateBackupClientsPropForCleanup.sp                     */
/*                                                                            */
/*  Description :  Stored procedure to set App_ClientProp for backup clients  */
/*				   which are elgible for cleanup 							  */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DAUpdateBackupClientsPropForCleanup.sp,v $ $Id: DAUpdateBackupClientsPropForCleanup.sp,v 1.2.40.1 2018/03/20 19:56:44 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DAUpdateBackupClientsPropForCleanup <<<'

IF EXISTS (select * from sysobjects where name='DAUpdateBackupClientsPropForCleanup')
	drop procedure DAUpdateBackupClientsPropForCleanup
IF EXISTS (select * from GxQscripts where name='DAUpdateBackupClientsPropForCleanup')
	delete from GxQscripts where name = 'DAUpdateBackupClientsPropForCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAUpdateBackupClientsPropForCleanup')
	delete from GXDBVersions where aliasname = 'DAUpdateBackupClientsPropForCleanup'
GO
print '... Creating Procedure: DAUpdateBackupClientsPropForCleanup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DAUpdateBackupClientsPropForCleanup
AS
	SET NOCOUNT ON
	IF OBJECT_ID('tempdb.dbp.#clientsWithBackup') IS NOT NULL
		DROP TABLE #clientsWithBackup
	CREATE table #clientsWithBackup
	(
		clientId integer primary key
	)
	INSERT #clientsWithBackup
	SELECT distinct app.clientId
	FROM
	(SELECT distinct appId from JMBkpStats WITH(NOLOCK))T INNER JOIN App_Application app WITH(NOLOCK) ON T.appId = app.id
	INSERT INTO App_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	SELECT A.clientId, 'Client Associated with backups', 2, 1, dbo.getUnixTime(GetUTCDate()), 0, 0
	FROM #clientsWithBackup A LEFT OUTER JOIN App_ClientProp B WITH(NOLOCK) ON A.clientId = B.componentNameId AND B.attrName = 'Client Associated with backups'
	WHERE B.id IS NULL
	UPDATE App_ClientProp SET attrVal = 1
	FROM #clientsWithBackup A INNER JOIN App_ClientProp B WITH(NOLOCK) ON A.clientId = B.componentNameId AND B.attrName = 'Client Associated with backups' AND B.modified = 0 AND B.attrVal = 0
	IF OBJECT_ID('tempdb.dbp.#clientsWithBackup') IS NOT NULL
		DROP TABLE #clientsWithBackup
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DAUpdateBackupClientsPropForCleanup')
	delete from GxQscripts where name = 'DAUpdateBackupClientsPropForCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAUpdateBackupClientsPropForCleanup')
	delete from GXDBVersions where aliasname = 'DAUpdateBackupClientsPropForCleanup'
GO

insert into GXDBVersions values(2, 'DAUpdateBackupClientsPropForCleanup',  '00010002004000010000', 'DAUpdateBackupClientsPropForCleanup', '00010002004000010000')
GO

