

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DATroubleshootJobsRetainedByCycle.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +==============================================================================================+
--  | Stored Proc:  DATroubleshootJobsRetainedByCycle
--  |
--  | Description:  Stored proc to troubleshoot jobs that are old but still retained by cycles criteria
--  +==============================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DATroubleshootJobsRetainedByCycle.sp,v $ $Id: DATroubleshootJobsRetainedByCycle.sp,v 1.1.2.1 2020/12/16 21:27:12 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DATroubleshootJobsRetainedByCycle')
BEGIN
	print '>>> Drop Stored Procedure: DATroubleshootJobsRetainedByCycle <<<'
	drop procedure DATroubleshootJobsRetainedByCycle
END
IF EXISTS (select * from GxQscripts where name='DATroubleshootJobsRetainedByCycle')
	delete from GxQscripts where name = 'DATroubleshootJobsRetainedByCycle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DATroubleshootJobsRetainedByCycle')
	delete from GXDBVersions where aliasname = 'DATroubleshootJobsRetainedByCycle'
GO
print '... Creating Procedure: DATroubleshootJobsRetainedByCycle'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DATroubleshootJobsRetainedByCycle
  @i_flags INT,
  @i_localeId INT = 0
AS
	SET NOCOUNT ON
	DECLARE @r_errorCode INT
	SET @r_errorCode = 0
	BEGIN TRY
		DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
		DECLARE @secondsOf90Days INT = (90*24*3600)
		--DECLARE @LibraryInput table(LibraryInput INT)
		DECLARE @allLibraries INT = 1
		/*Supposed to be created by caller. If caller did not create it, create here so queries won't fail*/
		IF OBJECT_ID('tempdb..#LibraryInput') IS NULL
			CREATE TABLE #LibraryInput (LibraryId INT)
		IF OBJECT_ID('tempdb..#JobsRetainedByCycles') IS NOT NULL
			DROP TABLE #JobsRetainedByCycles
		CREATE TABLE #JobsRetainedByCycles (libraryId INT, mountPathId INT, mediaId INT, jobId INT, commcellId INT, copyId INT, appId INT, jobStartTime INT, PRIMARY KEY(mediaId, jobId, commcellId, copyId))
		IF OBJECT_ID('tempdb..#AppIdsJobsRetainedByCycles') IS NOT NULL
			DROP TABLE #AppIdsJobsRetainedByCycles
CREATE TABLE #AppIdsJobsRetainedByCycles (appId INT, Client NVARCHAR(255), Agent VARCHAR(255), Subclient NVARCHAR(255),
		LastFullBackup INT, LastBackup INT, Recommendation NVARCHAR(MAX), PRIMARY KEY(appId))
		IF NOT EXISTS (SELECT 1 FROM #LibraryInput)
			INSERT INTO #JobsRetainedByCycles
			SELECT DISTINCT M.libraryId, ISNULL(MP.mountPathId, 0), M.mediaId, DAJR.jobId, DAJR.commcellId, DAJR.copyId, AF.appId, 0
			FROM DAJobRetentionInfo DAJR WITH(NOLOCK) INNER JOIN ArchChunkMapping ACM WITH(NOLOCK)
			ON DAJR.jobId = ACM.jobId AND DAJR.commcellId = ACM.commcellId AND DAJR.copyId = ACM.archCopyId
			INNER JOIN ArchFile AF WITH(NOLOCK) ON ACM.archFileId = AF.id AND ACM.commcellId = AF.commcellId AND DAJR.dataType = AF.fileType
			INNER JOIN ArchChunk AC WITH(NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommcellId = AC.commcellId
			INNER JOIN MMVolume Vol WITH(NOLOCK) ON AC.volumeId = Vol.VolumeId
			INNER JOIN MMMedia M WITH(NOLOCK) ON Vol.mediaId = M.mediaId
			LEFT OUTER JOIN MMMountPath MP WITH(NOLOCK) ON Vol.mediaSideId = MP.mediaSideId
			INNER JOIN DATroubleshootingInfo DAT WITH(NOLOCK) ON DAT.libraryId = M.libraryId AND ((MP.mountPathId IS NULL AND DAT.mountPathId = 0) OR (MP.mountPathId = DAT.mountPathId))
WHERE DAJR.jobRetainReason & 32 > 0 AND DAT.jobRetentionFlags & 32 > 0
		ELSE
			INSERT INTO #JobsRetainedByCycles
			SELECT DISTINCT M.libraryId, ISNULL(MP.mountPathId, 0), M.mediaId, DAJR.jobId, DAJR.commcellId, DAJR.copyId, AF.appId, 0
			FROM DAJobRetentionInfo DAJR WITH(NOLOCK) INNER JOIN ArchChunkMapping ACM WITH(NOLOCK)
			ON DAJR.jobId = ACM.jobId AND DAJR.commcellId = ACM.commcellId AND DAJR.copyId = ACM.archCopyId
			INNER JOIN ArchFile AF WITH(NOLOCK) ON ACM.archFileId = AF.id AND ACM.commcellId = AF.commcellId AND DAJR.dataType = AF.fileType
			INNER JOIN ArchChunk AC WITH(NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommcellId = AC.commcellId
			INNER JOIN MMVolume Vol WITH(NOLOCK) ON AC.volumeId = Vol.VolumeId
			INNER JOIN MMMedia M WITH(NOLOCK) ON Vol.mediaId = M.mediaId
			LEFT OUTER JOIN MMMountPath MP WITH(NOLOCK) ON Vol.mediaSideId = MP.mediaSideId
			INNER JOIN DATroubleshootingInfo DAT WITH(NOLOCK) ON DAT.libraryId = M.libraryId AND ((MP.mountPathId IS NULL AND DAT.mountPathId = 0) OR (MP.mountPathId = DAT.mountPathId))
WHERE DAJR.jobRetainReason & 32 > 0 AND DAT.jobRetentionFlags & 32 > 0 AND M.libraryId IN (SELECT libraryId FROM #LibraryInput)
		UPDATE #JobsRetainedByCycles SET jobStartTime = JBKP.servStartDate
		FROM #JobsRetainedByCycles J INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON J.jobId = JBKP.jobId AND J.commcellId = JBKP.commcellId
		UPDATE #JobsRetainedByCycles SET jobStartTime = JA.servStart
		FROM #JobsRetainedByCycles J INNER JOIN JMAdminJobStatsTable JA WITH(NOLOCK) ON J.jobId = JA.jobId AND J.commcellId = JA.commcellId
		WHERE J.jobStartTime = 0
		/*
			We pay attention to only the jobs that are 90 days more than the basic retention days.
			Ignore copies with infinite retention.
		*/
		DELETE J
		FROM #JobsRetainedByCycles J LEFT OUTER JOIN
		(SELECT copyId, (CAST(retentionDays AS BIGINT)*24*3600) retentionSecs
							FROM ArchAgingRule WITH(NOLOCK) WHERE retentionDays > -1) AR
							ON J.copyId = AR.copyId
							WHERE ((@timeNow - (J.jobStartTime + AR.retentionSecs)) < @secondsOf90Days) OR AR.copyId IS NULL
		/*Get distinct subclients to get subclient level analysis*/
		INSERT INTO #AppIdsJobsRetainedByCycles
		SELECT DISTINCT appId, '', '', '', 0, 0, ''
		FROM #JobsRetainedByCycles
		UPDATE T
		SET Client = CL.displayName, Agent = IDA.name, Subclient = App.subClientName
		FROM #AppIdsJobsRetainedByCycles T INNER JOIN App_Application App WITH(NOLOCK) ON T.appId = App.id
		INNER JOIN App_Client CL WITH(NOLOCK) ON App.ClientId = CL.id
		INNER JOIN App_IdaType IDA ON App.appTypeId = IDA.type
		IF(@i_flags & 1) > 0
		BEGIN
			--Populate information about last full backup and last backup
			UPDATE T1
			SET LastFullBackup = T2.LastFullBackup
			FROM #AppIdsJobsRetainedByCycles T1 INNER JOIN
			(
			SELECT JBKP.appId, MAX(jbkp.servStartDate) "LastFullBackup"
			FROM JMBkpStats JBKP WITH(NOLOCK) INNER JOIN #AppIdsJobsRetainedByCycles App ON JBKP.appId = App.appId
			WHERE JBKP.status IN (1, 3, 14) AND JBKP.bkpLevel IN (1, 64, 128, 16384, 1024, 32768)
			GROUP BY JBKP.appId
			) T2 ON T1.appId = T2.appId
			--Check admin jobs
			IF EXISTS(SELECT 1 FROM #AppIdsJobsRetainedByCycles WHERE lastFullBackup = 0)
			BEGIN
				UPDATE T1
				SET LastFullBackup = T2.LastFullBackup
				FROM #AppIdsJobsRetainedByCycles T1 INNER JOIN
				(
				SELECT JBKP.appId, MAX(jbkp.servStart) "LastFullBackup"
				FROM JMAdminJobStatsTable JBKP WITH(NOLOCK) INNER JOIN #AppIdsJobsRetainedByCycles App ON JBKP.appId = App.appId
				WHERE JBKP.status IN (1, 3, 14) AND JBKP.ER_BkpLevel IN (1, 64, 128, 16384, 1024, 32768)
				GROUP BY JBKP.appId
				) T2 ON T1.appId = T2.appId
			END
			UPDATE T1
			SET LastBackup = T2.LastBackup
			FROM #AppIdsJobsRetainedByCycles T1 INNER JOIN
			(
			SELECT JBKP.appId, MAX(jbkp.servStartDate) "LastBackup"
			FROM JMBkpStats JBKP WITH(NOLOCK) INNER JOIN #AppIdsJobsRetainedByCycles App ON JBKP.appId = App.appId
			WHERE JBKP.status IN (1, 3, 14)
			GROUP BY JBKP.appId
			) T2 ON T1.appId = T2.appId
			--Check admin jobs
			IF EXISTS(SELECT 1 FROM #AppIdsJobsRetainedByCycles WHERE LastBackup = 0)
			BEGIN
				UPDATE T1
				SET LastBackup = T2.LastBackup
				FROM #AppIdsJobsRetainedByCycles T1 INNER JOIN
				(
				SELECT JBKP.appId, MAX(jbkp.servStart) "LastBackup"
				FROM JMAdminJobStatsTable JBKP WITH(NOLOCK) INNER JOIN #AppIdsJobsRetainedByCycles App ON JBKP.appId = App.appId
				WHERE JBKP.status IN (1, 3, 14)
				GROUP BY JBKP.appId
				) T2 ON T1.appId = T2.appId
			END
			 IF OBJECT_ID('tempdb..#AppGetSubclientsWithBackupDisabledExtTable') IS NOT NULL
			 	DROP TABLE #AppGetSubclientsWithBackupDisabledExtTable
	    	CREATE  TABLE #AppGetSubclientsWithBackupDisabledExtTable (
	            appId       INTEGER,
	            PRIMARY KEY (appId)
	            )
			--Get subclients with backup activity disabled
		    INSERT INTO #AppGetSubclientsWithBackupDisabledExtTable
		    EXEC AppGetSubclientsWithBackupDisabled '<CVGui_GetSubclientsWithBackupDisabledReq />'
			DECLARE @ignoreCyclesOnBackupActivityDisabledSubclients INT = 0
			SELECT @ignoreCyclesOnBackupActivityDisabledSubclients = ISNULL(value, 0)
		    FROM MMConfigs WITH(NOLOCK)
		    WHERE name = 'DA_CONFIG_IGNORE_CYCLES_ON_BACKUP_ACTIVITY_DISABLED_SUBCLIENTS'
			DECLARE @recMsg NVARCHAR(1024) = ''
			SELECT @recMsg = Message
			FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (894 | (CAST(POWER(2, 24) AS BIGINT) * 63)) AND localeId = @i_localeId
			--Append more message
			IF (@ignoreCyclesOnBackupActivityDisabledSubclients = 0)
			BEGIN
SELECT @recMsg += ' ; ' + Message
				FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (896 | (CAST(POWER(2, 24) AS BIGINT) * 63)) AND localeId = @i_localeId
			END
			UPDATE #AppIdsJobsRetainedByCycles SET Recommendation += @recMsg
			WHERE appId IN (SELECT appId FROM  #AppGetSubclientsWithBackupDisabledExtTable)
			IF OBJECT_ID('tempdb..#AppGetSubclientsWithBackupDisabledExtTable') IS NOT NULL
			 	DROP TABLE #AppGetSubclientsWithBackupDisabledExtTable
			--Deconfigured subclients
			DECLARE @ignoreCyclesOnDeConfiguredClients INT = 0
			SELECT @ignoreCyclesOnDeConfiguredClients = ISNULL(value, 0)
		    FROM MMConfigs WITH (NOLOCK)
		    WHERE name = 'DA_CONFIG_IGNORE_CYCLES_ON_DECONFIGURED_CLIENTS'
			--Reusing same variable, so overwrite instead of append
			SELECT @recMsg = Message
			FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (898 | (CAST(POWER(2, 24) AS BIGINT) * 63)) AND localeId = @i_localeId
			--Append more message
			IF (@ignoreCyclesOnDeConfiguredClients = 0)
			BEGIN
SELECT @recMsg += ' ; ' + Message
				FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (897 | (CAST(POWER(2, 24) AS BIGINT) * 63)) AND localeId = @i_localeId
			END
			UPDATE T SET Recommendation += @recMsg
			FROM #AppIdsJobsRetainedByCycles T INNER JOIN App_Application App WITH(NOLOCK) ON T.appId = App.id
WHERE App.subclientStatus & 0x00002 > 0
			--If doesn't fall into above criteria, ask to check schedules as a default recommendation
			--Reusing same variable, so overwrite instead of append
			SELECT @recMsg = Message
			FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (895 | (CAST(POWER(2, 24) AS BIGINT) * 63)) AND localeId = @i_localeId
			UPDATE #AppIdsJobsRetainedByCycles SET Recommendation = @recMsg
			WHERE LEN(Recommendation) = 0
			IF(OBJECT_ID('tempdb..#tblOutAppsOfJobsRetainedByCycles') IS NOT NULL)
				INSERT INTO #tblOutAppsOfJobsRetainedByCycles
				SELECT appId, Client, Agent, Subclient, dbo.UTCToClientLocalTime(dbo.GetDateTime(LastFullBackup), 2) "LastFullBackup", dbo.UTCToClientLocalTime(dbo.GetDateTime(LastBackup), 2) "LastBackup", Recommendation
				FROM #AppIdsJobsRetainedByCycles
			ELSE
				SELECT appId, Client, Agent, Subclient, dbo.UTCToClientLocalTime(dbo.GetDateTime(LastFullBackup), 2) "LastFullBackup", dbo.UTCToClientLocalTime(dbo.GetDateTime(LastBackup), 2) "LastBackup", Recommendation
				FROM #AppIdsJobsRetainedByCycles
			GOTO PROC_EXIT
		END
		IF OBJECT_ID('tempdb..#JobsOutputList') IS NOT NULL
			DROP TABLE #JobsOutputList
		CREATE TABLE #JobsOutputList (
			LibraryId INT,
Library NVARCHAR(128),
			MountPathId INT,
			MountPathName NVARCHAR(1024),
			MediaId INT,
Barcode VARCHAR(256),
			StoragePolicyCopy NVARCHAR(512),
			JobId INT,
			CommcellId INT,
			BackupTime DateTime,
			appId INT,
Client NVARCHAR(255),
Agent VARCHAR(255),
Subclient NVARCHAR(255)
		)
		INSERT INTO #JobsOutputList
		SELECT J.libraryId, '', J.mountPathId, '', J.mediaId, '', AG.name + ' / ' + AGC.name "StoragePolicyCopy",
		J.jobId, J.commcellId, dbo.UTCToClientLocalTime(dbo.GetDateTime(J.jobStartTime), 2), App.appId, App.Client, App.Agent, App.subClient
		FROM #JobsRetainedByCycles J INNER JOIN #AppIdsJobsRetainedByCycles App ON J.appId = App.appId
		INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON J.copyId = AGC.id
		INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
		UPDATE #JobsOutputList SET Library = lib.aliasName, MountPathName = ISNULL(MP.mountPathName, 'N/A'), Barcode = CASE WHEN M.mediaTypeId <> 10001 THEN M.Barcode ELSE 'N/A' END
		FROM  #JobsOutputList J INNER JOIN MMLibrary lib WITH(NOLOCK) ON J.libraryid = lib.libraryId
		INNER JOIN MMMedia M WITH(NOLOCK) ON J.mediaId = M.mediaId
		LEFT OUTER JOIN MMS2getMountPathNameGUIView MP WITH(NOLOCK) ON J.MountPathId = MP.MountPathId
		IF OBJECT_ID('tempdb..#tblOutJobsRetainedByCycle') IS NOT NULL
			INSERT INTO #tblOutJobsRetainedByCycle
			SELECT * FROM #JobsOutputList
		ELSE
			SELECT * FROM #JobsOutputList
			ORDER BY Library, MountPathName, Barcode, jobId
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @r_errorCode = -1
		;THROW
	END CATCH
PROC_EXIT:
	IF OBJECT_ID('tempdb..#JobsRetainedByCycles') IS NOT NULL
		DROP TABLE #JobsRetainedByCycles
	IF OBJECT_ID('tempdb..#AppIdsJobsRetainedByCycles') IS NOT NULL
		DROP TABLE #AppIdsJobsRetainedByCycles
	IF OBJECT_ID('tempdb..#JobsOutputList') IS NOT NULL
		DROP TABLE #JobsOutputList
RETURN @r_errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'DATroubleshootJobsRetainedByCycle')
	delete from GxQscripts where name = 'DATroubleshootJobsRetainedByCycle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DATroubleshootJobsRetainedByCycle')
	delete from GXDBVersions where aliasname = 'DATroubleshootJobsRetainedByCycle'
GO

insert into GXDBVersions values(2, 'DATroubleshootJobsRetainedByCycle',  '00010001000200010000', 'DATroubleshootJobsRetainedByCycle', '00010001000200010000')
GO

