

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DATroubleshootJobsPendingAux.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +==============================================================================================+
--  | Stored Proc:  DATroubleshootJobsPendingAux
--  |
--  | Description:  Stored proc to troubleshoot jobs that are old but still retained due to pending aux copy
--  +==============================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DATroubleshootJobsPendingAux.sp,v $ $Id: DATroubleshootJobsPendingAux.sp,v 1.1.2.1 2020/12/16 21:27:33 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DATroubleshootJobsPendingAux')
BEGIN
	print '>>> Drop Stored Procedure: DATroubleshootJobsPendingAux <<<'
	drop procedure DATroubleshootJobsPendingAux
END
IF EXISTS (select * from GxQscripts where name='DATroubleshootJobsPendingAux')
	delete from GxQscripts where name = 'DATroubleshootJobsPendingAux'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DATroubleshootJobsPendingAux')
	delete from GXDBVersions where aliasname = 'DATroubleshootJobsPendingAux'
GO
print '... Creating Procedure: DATroubleshootJobsPendingAux'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DATroubleshootJobsPendingAux
  @i_flags INT,
  @i_localeId INT = 0
AS
	SET NOCOUNT ON
	DECLARE @r_errorCode INT
	SET @r_errorCode = 0
	BEGIN TRY
		DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
		DECLARE @secondsOf90Days INT = (90*24*3600)
		--DECLARE @LibraryInput table(LibraryInput INT)
		DECLARE @allLibraries INT = 1
		/*Supposed to be created by caller. If caller did not create it, create here so queries won't fail*/
		IF OBJECT_ID('tempdb..#LibraryInput') IS NULL
			CREATE TABLE #LibraryInput (LibraryId INT)
		IF OBJECT_ID('tempdb..#JobsPendingAux') IS NOT NULL
			DROP TABLE #JobsPendingAux
		CREATE TABLE #JobsPendingAux (libraryId INT, mountPathId INT, mediaId INT, jobId INT, commcellId INT, copyId INT, appId INT, jobStartTime INT, PRIMARY KEY(mediaId, jobId, commcellId, copyId))
		IF OBJECT_ID('tempdb..#AppIdsJobsPendingAux') IS NOT NULL
			DROP TABLE #AppIdsJobsPendingAux
CREATE TABLE #AppIdsJobsPendingAux (appId INT, Client NVARCHAR(255), Agent VARCHAR(255), Subclient NVARCHAR(255), PRIMARY KEY(appId))
		IF NOT EXISTS (SELECT 1 FROM #LibraryInput)
			INSERT INTO #JobsPendingAux
			SELECT DISTINCT M.libraryId, ISNULL(MP.mountPathId, 0), M.mediaId, DAJR.jobId, DAJR.commcellId, DAJR.copyId, AF.appId, 0
			FROM DAJobRetentionInfo DAJR WITH(NOLOCK) INNER JOIN ArchChunkMapping ACM WITH(NOLOCK)
			ON DAJR.jobId = ACM.jobId AND DAJR.commcellId = ACM.commcellId AND DAJR.copyId = ACM.archCopyId
			INNER JOIN ArchFile AF WITH(NOLOCK) ON ACM.archFileId = AF.id AND ACM.commcellId = AF.commcellId AND DAJR.dataType = AF.fileType
			INNER JOIN ArchChunk AC WITH(NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommcellId = AC.commcellId
			INNER JOIN MMVolume Vol WITH(NOLOCK) ON AC.volumeId = Vol.VolumeId
			INNER JOIN MMMedia M WITH(NOLOCK) ON Vol.mediaId = M.mediaId
			LEFT OUTER JOIN MMMountPath MP WITH(NOLOCK) ON Vol.mediaSideId = MP.mediaSideId
			INNER JOIN DATroubleshootingInfo DAT WITH(NOLOCK) ON DAT.libraryId = M.libraryId AND ((MP.mountPathId IS NULL AND DAT.mountPathId = 0) OR (MP.mountPathId = DAT.mountPathId))
WHERE DAJR.jobRetainReason & 512 > 0 AND DAT.jobRetentionFlags & 512 > 0
		ELSE
			INSERT INTO #JobsPendingAux
			SELECT DISTINCT M.libraryId, ISNULL(MP.mountPathId, 0), M.mediaId, DAJR.jobId, DAJR.commcellId, DAJR.copyId, AF.appId, 0
			FROM DAJobRetentionInfo DAJR WITH(NOLOCK) INNER JOIN ArchChunkMapping ACM WITH(NOLOCK)
			ON DAJR.jobId = ACM.jobId AND DAJR.commcellId = ACM.commcellId AND DAJR.copyId = ACM.archCopyId
			INNER JOIN ArchFile AF WITH(NOLOCK) ON ACM.archFileId = AF.id AND ACM.commcellId = AF.commcellId AND DAJR.dataType = AF.fileType
			INNER JOIN ArchChunk AC WITH(NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommcellId = AC.commcellId
			INNER JOIN MMVolume Vol WITH(NOLOCK) ON AC.volumeId = Vol.VolumeId
			INNER JOIN MMMedia M WITH(NOLOCK) ON Vol.mediaId = M.mediaId
			LEFT OUTER JOIN MMMountPath MP WITH(NOLOCK) ON Vol.mediaSideId = MP.mediaSideId
			INNER JOIN DATroubleshootingInfo DAT WITH(NOLOCK) ON DAT.libraryId = M.libraryId AND ((MP.mountPathId IS NULL AND DAT.mountPathId = 0) OR (MP.mountPathId = DAT.mountPathId))
WHERE DAJR.jobRetainReason & 512 > 0 AND DAT.jobRetentionFlags & 512 > 0 AND M.libraryId IN (SELECT libraryId FROM #LibraryInput)
		UPDATE #JobsPendingAux SET jobStartTime = JBKP.servStartDate
		FROM #JobsPendingAux J INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON J.jobId = JBKP.jobId AND J.commcellId = JBKP.commcellId
		UPDATE #JobsPendingAux SET jobStartTime = JA.servStart
		FROM #JobsPendingAux J INNER JOIN JMAdminJobStatsTable JA WITH(NOLOCK) ON J.jobId = JA.jobId AND J.commcellId = JA.commcellId
		WHERE J.jobStartTime = 0
		/*
			We pay attention to only the jobs that are 90 days more than the basic retention days.
			Ignore copies with infinite retention.
		*/
		DELETE J
		FROM #JobsPendingAux J LEFT OUTER JOIN
		(SELECT copyId, (CAST(retentionDays AS BIGINT)*24*3600) retentionSecs
							FROM ArchAgingRule WITH(NOLOCK) WHERE retentionDays > -1) AR
							ON J.copyId = AR.copyId
							WHERE ((@timeNow - (J.jobStartTime + AR.retentionSecs)) < @secondsOf90Days) OR AR.copyId IS NULL
		INSERT INTO #AppIdsJobsPendingAux
		SELECT DISTINCT appId, '', '', ''
		FROM #JobsPendingAux
		UPDATE T
		SET Client = CL.displayName, Agent = IDA.name, Subclient = App.subClientName
		FROM #AppIdsJobsPendingAux T INNER JOIN App_Application App WITH(NOLOCK) ON T.appId = App.id
		INNER JOIN App_Client CL WITH(NOLOCK) ON App.ClientId = CL.id
		INNER JOIN App_IdaType IDA ON App.appTypeId = IDA.type
		IF OBJECT_ID('tempdb..#PendingAuxCopyList') IS NOT NULL
			DROP TABLE #PendingAuxCopyList
		CREATE TABLE #PendingAuxCopyList
		(
			CopyId INT,
			TargetCopies NVARCHAR (MAX),
			PRIMARY KEY(CopyId)
		)
		INSERT INTO #PendingAuxCopyList
		SELECT DISTINCT copyId, ''
		FROM #JobsPendingAux
		UPDATE #PendingAuxCopyList SET TargetCopies = T1.TargetCopies
		FROM
		(
		SELECT T.copyId,
		STUFF((
	    SELECT ', ' + AGCD.name
	    FROM ArchGroupCopy AGC WITH(NOLOCK)
	    INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
	    INNER JOIN ArchGroupCopy AGCD WITH(NOLOCK) ON AG.id = AGCD.archGroupId AND AGC.isSnapCopy = AGCD.isSnapCopy
	    AND (AGCD.sourceCopyId = T.copyId OR (AGCD.sourceCopyId = 0 AND T.copyId IN (AG.defaultCopy, AG.defaultSnapCopy) ))
	    WHERE AGC.id = T.copyId AND AGCD.id <> T.copyId
	    FOR XML PATH(''),TYPE).value('(./text())[1]','VARCHAR(MAX)')
  		,1,2,'') "TargetCopies"
  		FROM #PendingAuxCopyList T
		) T1 INNER JOIN #PendingAuxCopyList T2 ON T1.copyId = T2.copyId
		IF OBJECT_ID('tempdb..#JobsOutputList') IS NOT NULL
			DROP TABLE #JobsOutputList
		CREATE TABLE #JobsOutputList (
			LibraryId INT,
Library NVARCHAR(128),
			MountPathId INT,
			MountPathName NVARCHAR(1024),
			MediaId INT,
Barcode VARCHAR(256),
			StoragePolicyCopy NVARCHAR(512),
			TargetCopies NVARCHAR(MAX),
			JobId INT,
			CommcellId INT,
			BackupTime DateTime,
			appId INT,
Client NVARCHAR(255),
Agent VARCHAR(255),
Subclient NVARCHAR(255)
		)
		INSERT INTO #JobsOutputList
		SELECT J.libraryId, '', J.mountPathId, '', J.mediaId, '', AG.name + ' / ' + AGC.name "StoragePolicyCopy", T.TargetCopies,
		J.jobId, J.commcellId, dbo.UTCToClientLocalTime(dbo.GetDateTime(J.jobStartTime), 2), App.appId, App.Client, App.Agent, App.subClient
		FROM #JobsPendingAux J INNER JOIN #AppIdsJobsPendingAux App ON J.appId = App.appId
		INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON J.copyId = AGC.id
		INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
		INNER JOIN #PendingAuxCopyList T ON J.copyId = T.copyId
		UPDATE #JobsOutputList SET Library = lib.aliasName, MountPathName = ISNULL(MP.mountPathName, 'N/A'), Barcode = CASE WHEN M.mediaTypeId <> 10001 THEN M.Barcode ELSE 'N/A' END
		FROM  #JobsOutputList J INNER JOIN MMLibrary lib WITH(NOLOCK) ON J.libraryid = lib.libraryId
		INNER JOIN MMMedia M WITH(NOLOCK) ON J.mediaId = M.mediaId
		LEFT OUTER JOIN MMS2getMountPathNameGUIView MP WITH(NOLOCK) ON J.MountPathId = MP.MountPathId
		IF OBJECT_ID('tempdb..#tblOutJobsPendingAuxcopy') IS NOT NULL
			INSERT INTO #tblOutJobsPendingAuxcopy
			SELECT * FROM #JobsOutputList
		ELSE
			SELECT * FROM #JobsOutputList
			ORDER BY Library, MountPathName, Barcode, jobId
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @r_errorCode = -1
		;THROW
	END CATCH
PROC_EXIT:
	IF OBJECT_ID('tempdb..#JobsPendingAux') IS NOT NULL
			DROP TABLE #JobsPendingAux
	IF OBJECT_ID('tempdb..#PendingAuxCopyList') IS NOT NULL
			DROP TABLE #PendingAuxCopyList
	IF OBJECT_ID('tempdb..#JobsOutputList') IS NOT NULL
		DROP TABLE #JobsOutputList
RETURN @r_errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'DATroubleshootJobsPendingAux')
	delete from GxQscripts where name = 'DATroubleshootJobsPendingAux'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DATroubleshootJobsPendingAux')
	delete from GXDBVersions where aliasname = 'DATroubleshootJobsPendingAux'
GO

insert into GXDBVersions values(2, 'DATroubleshootJobsPendingAux',  '00010001000200010000', 'DATroubleshootJobsPendingAux', '00010001000200010000')
GO

