

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DAPopulateTroubleshootingInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Stored Proc:  DAPopulateTroubleshootingInfo()
--  |
--  | Description:  Stored proc to populate pruning troubleshooting info
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DAPopulateTroubleshootingInfo.sp,v $ $Id: DAPopulateTroubleshootingInfo.sp,v 1.1.2.4 2020/12/29 20:43:11 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DAPopulateTroubleshootingInfo')
BEGIN
	print '>>> Drop Stored Procedure: DAPopulateTroubleshootingInfo <<<'
	drop procedure DAPopulateTroubleshootingInfo
END
IF EXISTS (select * from GxQscripts where name='DAPopulateTroubleshootingInfo')
	delete from GxQscripts where name = 'DAPopulateTroubleshootingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAPopulateTroubleshootingInfo')
	delete from GXDBVersions where aliasname = 'DAPopulateTroubleshootingInfo'
GO
print '... Creating Procedure: DAPopulateTroubleshootingInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DAPopulateTroubleshootingInfo
  @i_flags INT
AS
  DECLARE @r_errorCode INT;
SET NOCOUNT ON
SET @r_errorCode = 0
IF EXISTS(SELECT 1 FROM MMConfigs WITH(NOLOCK) WHERE name = 'DA_CONFIG_DISABLE_DATROUBLESHOOTING_DATA_COLLECTION' AND value = 1)
	GOTO PROC_EXIT
BEGIN TRY
	DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @secondsOf10Days INT = (10*24*3600)
	DECLARE @secondsOf30Days INT = (30*24*3600)
	DECLARE @secondsOf90Days INT = (90*24*3600)
	IF OBJECT_ID('tempdb..#DATroubleShootingInfo') IS NOT NULL
		DROP TABLE #DATroubleShootingInfo
	CREATE TABLE #DATroubleShootingInfo (
		mountPathId				INTEGER,
		libraryId				INTEGER,
		libraryTypeId			INTEGER,
		pendingDeletes			INTEGER,
		problemFlags  			BIGINT,
		jobRetentionFlags		BIGINT,
		oldestPendingDAF		INT,
		primary key (mountPathId, libraryId)
		)
	/*
	As we find problems, populate the required supplement information here and severity.
	*/
	IF OBJECT_ID('tempdb..#DATroubleShootingInfoDetails') IS NOT NULL
		DROP TABLE #DATroubleShootingInfoDetails
	CREATE TABLE #DATroubleShootingInfoDetails (
		mountPathId INT,
		libraryId	INT,
		problemFlag INT,
		jobRetentionFlag INT,
		severity INT
		)
	/*Populate both disk library and tape libraries here*/
	INSERT INTO #DATroubleShootingInfo
	SELECT ISNULL(MP.MountPathId, 0), lib.LibraryId, lib.libraryTypeId, 0, 0, 0, 0
	FROM MMLibrary lib WITH(NOLOCK) LEFT OUTER JOIN MMMountPath MP WITH(NOLOCK) ON lib.LibraryId = MP.LibraryId
	WHERE lib.libraryId > 0
	/*Get pruning backlog information from MMDeletedAF*/
	UPDATE DAT SET PendingDeletes = T2.DAFCount, oldestPendingDAF = T2.OldestPendingDAF
	FROM #DATroubleShootingInfo DAT
	INNER JOIN
	(
	SELECT T1.MountPathId, COUNT(DAF.archFileId) "DAFCount", MIN(DAF.DeletedTime) "OldestPendingDAF"
	FROM #DATroubleShootingInfo T1 INNER JOIN MMDeletedAF DAF WITH(NOLOCK) ON T1.MountPathId = DAF.MountPathId
	WHERE T1.mountPathId > 0
	GROUP BY T1.MountPathId
	) T2
	ON DAT.MountPathId = T2.MountPathId
	/*These are the problem flags recomputed here. Use this to reset table entries at the end*/
DECLARE @problemFlagsRecomputed BIGINT = 1 |
4 |
2 |
8 |
16 |
32 |
64 |
128 |
256 |
2048 |
4096 |
8192 |
16384 |
32768
	IF OBJECT_ID('tempdb..#tmpMPSetErrorCode') IS NOT NULL DROP TABLE #tmpMPSetErrorCode
	CREATE TABLE #tmpMPSetErrorCode
	(
		MountPathId			INT,
		MediaSideId			INT,
		errorCode			INT
		PRIMARY KEY (MountPathId)
	)
	IF OBJECT_ID('tempdb..#tmpMPCopySetErrorCode') IS NOT NULL
		DROP TABLE #tmpMPCopySetErrorCode
	CREATE TABLE #tmpMPCopySetErrorCode
	(
		MountPathId			INT,
		MediaSideId			INT,
		copyId				INT,
		errorCode			INT
		PRIMARY KEY (MountPathId, copyId)
	)
	/*Populate input list required by the MMSetErrorCodeForPruningFailures stored proc*/
	INSERT INTO #tmpMPSetErrorCode
	SELECT MP.mountPathId, MP.mediaSideId, 0
	FROM #DATroubleShootingInfo T INNER JOIN MMMountPath MP WITH(NOLOCK) ON T.mountPathId = MP.mountPathId
	WHERE T.mountPathId > 0
	/*If mount path is set to use datapath MAs for pruning pick copy associations so that copy specific error code will be set*/
IF EXISTS(SELECT 1 FROM MMMountPath WITH (READUNCOMMITTED) WHERE Attribute & 256 > 0)
	BEGIN
		/*Pick associated copy mapping from MMVolume entries*/
		INSERT INTO #tmpMPCopySetErrorCode
		SELECT DISTINCT T.MountPathId, T.MediaSideId, AST.archGroupCopyId, 0
		FROM #tmpMPSetErrorCode T INNER JOIN MMMountPath MP WITH (READUNCOMMITTED)
		ON T.MountPathId = MP.MountPathId
		INNER JOIN MMVolume V ON T.mediaSideId = V.mediaSideId
		INNER JOIN ArchStream AST WITH (READUNCOMMITTED) ON V.mediaGroupId = AST.mediaGroupId
WHERE MP.Attribute & 256 > 0	AND AST.archGroupCopyId > 0
		--AND MV.VolumeFlags = 6
		/*Pick associated copy mapping from MMDeletedAF entries*/
		INSERT INTO #tmpMPCopySetErrorCode
		SELECT DISTINCT T.MountPathId, T.MediaSideId, DAF.copyId, 0
		FROM #tmpMPSetErrorCode T INNER JOIN MMMountPath MP WITH (READUNCOMMITTED)
		ON T.MountPathId = MP.MountPathId
		INNER JOIN MMDeletedAF DAF WITH (READUNCOMMITTED) ON T.mountPathId = DAF.mountPathId
WHERE MP.Attribute & 256 > 0 AND DAF.copyId > 0
		AND NOT EXISTS (SELECT 1 FROM #tmpMPCopySetErrorCode T1 WHERE T1.mountPathId = T.mountPathId AND T1.copyId = DAF.copyId)
		/*If the copy doesn't exist any more, datapath MA requirement for pruning won't apply, so process these for errors only if the copy is still valid*/
		DELETE #tmpMPCopySetErrorCode
		WHERE NOT EXISTS(SELECT 1 FROM ArchGroupCopy WITH(NOLOCK) WHERE id = #tmpMPCopySetErrorCode.copyId)
	END
	IF OBJECT_ID('tempdb..#tblOutMMSetErrorCodeForPruningFailures') IS NOT NULL
		DROP TABLE #tblOutMMSetErrorCodeForPruningFailures
	CREATE TABLE #tblOutMMSetErrorCodeForPruningFailures
	(
		errCode INT,
		errStr 	VARCHAR(1024)
	)
EXEC MMSetErrorCodeForPruningFailures 0, 1, ''
	IF OBJECT_ID('tempdb..#tblOutMMSetErrorCodeForPruningFailures') IS NOT NULL
		DROP TABLE #tblOutMMSetErrorCodeForPruningFailures
	/*Mount path level errors*/
UPDATE DAT SET problemFlags |= CASE WHEN TE.errorCode = 65123 THEN 2
WHEN TE.errorCode = 65105 THEN 4
WHEN TE.errorCode IN (65107, 65108, 65109) THEN 8
WHEN TE.errorCode = 65106 THEN 16
WHEN TE.errorCode = 65126 THEN 8192
WHEN TE.errorCode = 65128 THEN 16384
WHEN TE.errorCode = 65127 THEN 64
WHEN TE.errorCode = 65134 THEN 256
WHEN TE.errorCode = 65125 THEN 4096
										ELSE 0
									END
	FROM #DATroubleShootingInfo DAT INNER JOIN #tmpMPSetErrorCode TE ON DAT.mountPathId = TE.mountPathId
	WHERE DAT.mountPathId > 0
	INSERT INTO #DATroubleShootingInfoDetails
	SELECT T1.mountPathId, T1.LibraryId, T2.problemFlagBit, T2.jobRetentionFlagBit, T2.severity
	FROM #DATroubleShootingInfo T1 INNER JOIN
	(
SELECT 2 "problemFlagBit", 0 "jobRetentionFlagBit", 2 "severity"
		UNION
SELECT 4, 0, 2
		UNION
SELECT 8, 0, 2
		UNION
SELECT 16, 0, 2
		UNION
SELECT 8192, 0, 2
		UNION
SELECT 16384, 0, 2
		UNION
SELECT 64, 0, 2
		UNION
SELECT 256, 0, 2
		UNION
SELECT 4096, 0, 2
	) T2
	ON T1.problemFlags & T2.problemFlagBit > 0
	/*Copy specific errors if mount path is configured to use datapath MAs*/
UPDATE DAT SET problemFlags |= CASE WHEN TE.errorCode = 65132 THEN 32
WHEN TE.errorCode = 65133 THEN 128
WHEN TE.errorCode = 65134 THEN 256
									ELSE 0
								END
	FROM #DATroubleShootingInfo DAT INNER JOIN #tmpMPCopySetErrorCode TE ON DAT.mountPathId = TE.mountPathId
	WHERE DAT.mountPathId > 0
	INSERT INTO #DATroubleShootingInfoDetails
	SELECT T1.mountPathId, T1.LibraryId, T2.problemFlagBit, T2.jobRetentionFlagBit, T2.severity
	FROM #DATroubleShootingInfo T1 INNER JOIN
	(
SELECT 32 "problemFlagBit", 0 "jobRetentionFlagBit", 2 "severity"
		UNION
SELECT 128, 0, 2
		UNION
SELECT 256, 0, 2
	) T2
	ON T1.problemFlags & T2.problemFlagBit > 0
	AND EXISTS (SELECT 1 FROM #tmpMPCopySetErrorCode WHERE mountPathId = T1.mountPathId)
	UPDATE #DATroubleShootingInfoDetails
SET severity = CASE WHEN T2.pendingDeletes > 500000 THEN 3
ELSE 2 END
	FROM #DATroubleShootingInfoDetails T1 INNER JOIN #DATroubleShootingInfo T2 ON T1.mountPathId = T2.mountPathId AND T1.libraryId = T2.libraryId
AND T1.problemFlag & (2 |  4 | 8 | 16 | 32 | 64 | 128 | 256 |													8192 | 16384) > 0
	/*Identify tape libraries with assigned full media that are 90 days beyond their expected retention end time*/
	/*
    10 days - info
	30 days - warning
	90 days - critical
	*/
UPDATE T1 SET problemFlags |= 2048
OUTPUT INSERTED.mountPathId, INSERTED.libraryId, 2048, 0, T2.severity
	INTO #DATroubleShootingInfoDetails
	FROM #DATroubleShootingInfo T1
	INNER JOIN
	(
SELECT DAT.libraryId, MAX(CASE  WHEN (@timeNow - M.retentionExpireTime) > @secondsOf90Days THEN 3
WHEN (@timeNow - M.retentionExpireTime) > @secondsOf30Days THEN 2 END) "severity"
		FROM #DATroubleShootingInfo DAT INNER JOIN MMMedia M WITH(NOLOCK) ON DAT.libraryId = M.libraryId
		INNER JOIN MMVolume Vol WITH(NOLOCK) ON M.mediaId = Vol.mediaId
WHERE DAT.libraryTypeId != 3 AND M.isAged = 0 AND M.isInMediaGroup = 1 AND Vol.VolumeFlags = 2 /*VOL_FULL*/
		AND (@timeNow - M.retentionExpireTime) > @secondsOf10Days
		GROUP BY DAT.libraryId
	) T2 ON T1.libraryId = T2.libraryId
	IF OBJECT_ID('tempdb..#DefragJobLibs') IS NOT NULL
		DROP TABLE #DefragJobLibs
	CREATE TABLE #DefragJobLibs (libraryId INT)
	IF OBJECT_ID('tempdb..#DefragJobStores') IS NOT NULL
		DROP TABLE #DefragJobStores
	CREATE TABLE #DefragJobStores (libraryId INT, SIDBStoreId INT, lastDefragRunTime INT)
	--Find mount paths with no sparse support and no defrag running
    IF EXISTS(
	SELECT 1 FROM MMMountPath MP WITH(NOLOCK) WHERE MP.IsEnabled = 1
AND (MP.Attribute & (1024|128)) = 1024
            AND MP.MountPathTypeId != 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	)
	BEGIN
		--Below queries picked from archAutoDDBVerifyTaskToBeRunEx.sp
DECLARE     @l_lowWaterMarkPercent INTEGER = 50;
	    SELECT      @l_lowWaterMarkPercent = value
	    FROM        MMConfigs WITH (READUNCOMMITTED)
	    WHERE       name = 'MMS2_CONFIG_LOW_WATERMARK_PERC_TO_SUBMIT_DEFRAG_JOB'
DECLARE     @l_storeIntervalDays INTEGER = 30;
	    SELECT      @l_storeIntervalDays = value
	    FROM        MMConfigs WITH (READUNCOMMITTED)
	    WHERE       name = 'MMS2_CONFIG_CHECKTWEAK_MPDEFRAGJOBSUBMITONSTORE_INTERVAL_DAYS'
	    --
	    -- 1. Get libs with drill holes not supported
	    --      1A. For Gluster FS Mount path check low water mark stored in MMConfig
	    --      1B. For Non Gluster FS Mount Path check low water mark on library
	    --      1C. Do not pick cloud mount paths in both conditions
	    -- 2. Update for those having less than @i_threshold free space
	    --
	    INSERT INTO #DefragJobLibs
	    SELECT  DISTINCT MP.LibraryId
	    FROM    MMMountPath MP WITH(NOLOCK) INNER JOIN
	            MMMediaSide MS WITH(NOLOCK) ON MP.MediaSideId = MS.MediaSideId INNER JOIN
	            MMLibrary ML WITH(NOLOCK) ON MP.LibraryId = ML.LibraryId
	    WHERE   MP.IsEnabled = 1
AND (MP.Attribute & (1024|128)) = 1024
AND (MP.Attribute & 64) = 64
	            AND MP.MountPathTypeId != 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	    GROUP BY MP.LibraryId, ML.LowWaterMarkMB
	    HAVING ((SUM(MS.totalspacemb) > 0) AND ((SUM(MS.FreeBytesMB) * 100)/SUM(MS.totalspacemb) <= @l_lowWaterMarkPercent))
	    INSERT INTO #DefragJobLibs
	    SELECT  DISTINCT MP.LibraryId
	    FROM    MMMountPath MP WITH(NOLOCK) INNER JOIN
	            MMMediaSide MS WITH(NOLOCK) ON MP.MediaSideId = MS.MediaSideId INNER JOIN
	            MMLibrary ML WITH(NOLOCK) ON MP.LibraryId = ML.LibraryId
	    WHERE   MP.IsEnabled = 1
AND (MP.Attribute & (1024|128)) = 1024
AND (MP.Attribute & 64) = 0
	            AND MP.MountPathTypeId != 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	    GROUP BY MP.LibraryId, ML.LowWaterMarkMB
	    HAVING ((SUM(MS.totalspacemb) > 0) AND ((SUM(MS.FreeBytesMB) * 100)/SUM(MS.totalspacemb) <= ML.LowWaterMarkMB))
	    INSERT INTO #DefragJobStores
	    SELECT DISTINCT C.libraryId, S.SIDBStoreId, 0
	    FROM
	        (SELECT DISTINCT L.libraryId, AGC.id CopyId
	        FROM    #DefragJobLibs L
	                    INNER JOIN MMMasterPool MP  WITH (READUNCOMMITTED) ON L.libraryId = MP.LibraryId
	                    INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON MP.MasterPoolId = DP.MasterPoolId
	                    INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPath.DrivePoolId
INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON DPath.CopyId = AGC.id AND ((AGC.dedupeflags & 134217728) = 0)) C,
	        archCopySIDBStore S WITH (READUNCOMMITTED)
	    WHERE   C.CopyId = S.CopyId
	    --Remove the stores that do not have any data
	    DELETE #DefragJobStores
	    WHERE NOT EXISTS
	    (
	    	SELECT  1
            FROM    archFileCopyDedup AFCD WITH (READCOMMITTED)
            INNER JOIN archFile AF WITH (READUNCOMMITTED) ON AF.id = AFCD.archFileId AND AF.commcellId = AFCD.commcellId
            INNER JOIN JMJobDataStats JDS WITH (READUNCOMMITTED) ON AF.jobId = JDS.jobID AND AF.commcellId = JDS.commcellId AND AFCD.archCopyId = JDS.archGrpCopyId
    		WHERE JDS.Status = 100
AND (JDS.disabled & 256) = 0
            AND AFCD.SIDBStoreId = #DefragJobStores.SIDBStoreId
        )
	    --Find last defrag job time
	    UPDATE  S
	    SET     lastDefragRunTime = T.servStart
	    FROM    #DefragJobStores S,
	            (SELECT S.SIDBStoreId, MAX(J.servStart) servStart
	            FROM    (SELECT DISTINCT SIDBStoreId FROM #DefragJobStores) S,
	                    JMAdminJobStatsTable J WITH (READUNCOMMITTED)
	                        LEFT OUTER JOIN  JMAdminJobAttemptStatsTable JA WITH (READUNCOMMITTED)
	                            ON  J.jobId = JA.JobId
	                                AND J.CommCellId = JA.CommCellId
	                                AND JA.attemptNum = 1
	                                AND JA.phaseNum = 4 /*DEFRAGMENT*/
	            WHERE   S.SIDBStoreId = J.CloudId
	                    AND J.opType = 31 -- ARCHIVECHECK        =31,
	                    AND (JA.JobId IS NOT NULL
OR dbo.GetJobOption(J.JobId, 1616894445) = 4 /*TMMsg::DDBVerificationLevel_DDB_DEFRAGMENTATION*/)
	            GROUP BY S.SIDBStoreId) T
	    WHERE   S.SIDBStoreId = T.SIDBStoreId
	    --Remove the stores that had Defrag jobs ran in last configured days
	    DELETE  S
	    FROM    #DefragJobStores S
	    WHERE   S.lastDefragRunTime > (@timeNow - (@l_storeIntervalDays * 24 * 3600))
		--We are left with stores on libraries that do not have drill hole support and are low on space but have not run a defrag job in 30 days. Set the error code on eligible mount paths
UPDATE DAT SET problemFlags |= 32768
OUTPUT INSERTED.mountPathId, INSERTED.libraryId, 32768, 0, 2
		INTO #DATroubleShootingInfoDetails
		FROM #DATroubleShootingInfo DAT INNER JOIN MMMountPath MP WITH(NOLOCK) ON DAT.mountPathId = MP.mountPathId AND DAT.libraryId = MP.libraryId
		WHERE DAT.libraryId IN (SELECT DISTINCT LibraryId FROM #DefragJobStores) AND MP.IsEnabled = 1
AND (MP.Attribute & (1024|128)) = 1024
	    AND MP.MountPathTypeId != 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	END
IF(@i_flags & 1) = 0
	BEGIN
SET @problemFlagsRecomputed |= 1024
		DECLARE @maxJobIdInBatch INT = 0
		DECLARE @lastBatchPicked BIT = 0
		IF OBJECT_ID('tempdb..#MPtoJobRetainReason') IS NOT NULL
			DROP TABLE #MPtoJobRetainReason
		CREATE TABLE #MPtoJobRetainReason (
			mountPathId				INTEGER,
			libraryId				INTEGER,
			jobRetainReason			BIGINT,
			PRIMARY KEY (mountPathId, libraryId, jobRetainReason) WITH(IGNORE_DUP_KEY = ON)
			)
		IF OBJECT_ID('tempdb..#jobsToProcess') IS NOT NULL
			DROP TABLE #jobsToProcess
		CREATE TABLE #jobsToProcess (jobId INT, commcellId INT, copyId INT, dataType INT, jobStartTime INT, jobRetainReason INT, PRIMARY KEY(jobId, copyId, dataType, commcellId))
		WHILE(1=1)
		BEGIN
			TRUNCATE TABLE #jobsToProcess
			IF(@lastBatchPicked = 1)
				BREAK
DECLARE @nJobsPerBatch INT = 500000
			SELECT @nJobsPerBatch = value FROM MMConfigs WITH(NOLOCK) WHERE name = 'DA_CONFIG_NUMBER_OF_JOBS_TO_PROCESS_IN_BATCH_FOR_DATROUBLESHOOTING_INFO'
			/*Pick @nJobsPerBatch jobs to process in a batch. Ignore jobs marked for days retention or extended retention. Nothing much to report on them*/
			INSERT INTO #jobsToProcess
			SELECT TOP (@nJobsPerBatch) jobId, commcellId, DAJR.copyId, dataType, 0, DAJR.jobRetainReason
			FROM DAJobRetentionInfo DAJR WITH(NOLOCK)
WHERE DAJR.jobRetainReason & (16 | 128 | 256) = 0 AND DAJR.jobId >= @maxJobIdInBatch
			ORDER BY jobId--, commcellId, copyId, dataType
			/*
			Logic of max jobid: It is the max job id processed in previous batch.
			While picking new batches I pick as jobId >= maxJobId.
			It is possible the same job was picked in previous batch for different copy/datatype.
			Instead of dealing with splitting job exactly at jobId/commcellId/copyId/dataType level
			I'm reprocessing the max jobid in the next batch.
			If no other jobs remain in this batch other than @maxJobIdInBatch this will be our last batch.
			*/
			IF NOT EXISTS(SELECT 1 FROM #jobsToProcess WHERE jobId <> @maxJobIdInBatch)
				SET @lastBatchPicked = 1
			SELECT @maxJobIdInBatch = MAX(jobId)
			FROM #jobsToProcess
			UPDATE #jobsToProcess SET jobStartTime = JBKP.servStartDate
			FROM #jobsToProcess J INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON J.jobId = JBKP.jobId AND J.commcellId = JBKP.commcellId
			UPDATE #jobsToProcess SET jobStartTime = JA.servStart
			FROM #jobsToProcess J INNER JOIN JMAdminJobStatsTable JA WITH(NOLOCK) ON J.jobId = JA.jobId AND J.commcellId = JA.commcellId
			WHERE J.jobStartTime = 0
			/*
				We pay attention to only the jobs that are 90 days more than the basic retention days.
				Ignore copies with infinite retention.
			*/
			DELETE J
			FROM #jobsToProcess J LEFT OUTER JOIN
			(SELECT copyId, (CAST(retentionDays AS BIGINT)*24*3600) retentionSecs
								FROM ArchAgingRule WITH(NOLOCK) WHERE retentionDays > -1) AR
								ON J.copyId = AR.copyId
								WHERE ((@timeNow - (J.jobStartTime + AR.retentionSecs)) < @secondsOf90Days) OR AR.copyId IS NULL
			/*Get all mountpaths/libraries that are affected by retention of these jobs and map them to these job retention reasons*/
			INSERT INTO #MPtoJobRetainReason
			SELECT DISTINCT ISNULL(MP.mountPathId, 0) "MountPathId", M.libraryId,  J.jobRetainReason
			FROM #jobsToProcess J INNER JOIN ArchChunkMapping ACM WITH(NOLOCK)
			ON J.jobId = ACM.jobId AND J.commcellId = ACM.commcellId AND J.copyId = ACM.archCopyId
			INNER JOIN ArchFile AF WITH(NOLOCK) ON ACM.archFileId = AF.id AND ACM.commcellId = AF.commcellId AND J.dataType = AF.fileType
			INNER JOIN ArchChunk AC WITH(NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommcellId = AC.commcellId
			INNER JOIN MMVolume Vol WITH(NOLOCK) ON AC.volumeId = Vol.VolumeId
			INNER JOIN MMMedia M WITH(NOLOCK) ON Vol.mediaId = M.mediaId
			LEFT OUTER JOIN MMMountPath MP WITH(NOLOCK) ON Vol.mediaSideId = MP.mediaSideId
		END
		IF OBJECT_ID('tempdb..#jobsToProcess') IS NOT NULL
			DROP TABLE #jobsToProcess
		/*Consolidate the jobRetentionFlags and set on #DATroubleshootingInfo table*/
		DECLARE @mountPathId INT
		DECLARE @libraryId INT
		DECLARE MPListCURSOR CURSOR LOCAL FOR
		SELECT DISTINCT mountPathId, libraryId
		FROM #MPtoJobRetainReason
		OPEN MPListCURSOR
		FETCH NEXT FROM MPListCURSOR INTO @mountPathId, @libraryId
		WHILE(@@FETCH_STATUS = 0)
		BEGIN
			DECLARE @jobRetentionFlags BIGINT
			SET @jobRetentionFlags = 0
			SELECT @jobRetentionFlags |= jobRetainReason
			FROM #MPtoJobRetainReason
			WHERE mountPathId = @mountPathId AND libraryId = @libraryId
			UPDATE #DATroubleShootingInfo SET jobRetentionFlags |= @jobRetentionFlags
			WHERE mountPathId = @mountPathId AND libraryId = @libraryId
			FETCH NEXT FROM MPListCURSOR INTO @mountPathId, @libraryId
		END
		CLOSE MPListCURSOR
		DEALLOCATE MPListCURSOR
		IF OBJECT_ID('tempdb..#MPtoJobRetainReason') IS NOT NULL
			DROP TABLE #MPtoJobRetainReason
	END
	--Insert library and mountpaths that don't exist in the DATroubleShootingInfo table
	INSERT INTO DATroubleShootingInfo
	SELECT mountPathId, libraryId, 0, 0, 0, @timeNow, ''
	FROM #DATroubleShootingInfo T
	WHERE NOT EXISTS (SELECT 1 FROM DATroubleShootingInfo DAT WHERE DAT.mountPathId = T.mountPathId AND DAT.libraryId = T.libraryId)
	--First reset the flags that we recomputed now. Reset jobRetentionFlags based on input flags. Also set pendingDeletes count
	UPDATE DAT SET problemFlags = (DAT.problemFlags & ~@problemFlagsRecomputed),
jobRetentionFlags = CASE WHEN (@i_flags & 1) > 0 THEN DAT.jobRetentionFlags ELSE 0 END,
		  		modified = @timeNow,
		  		pendingDeletes = T.pendingDeletes
	FROM #DATroubleShootingInfo T INNER JOIN DATroubleShootingInfo DAT ON T.mountPathId = DAT.mountPathId AND T.libraryId = DAT.libraryId
	--Set problem flags applicable only if there is a pruning backlog exceeding 7 days
UPDATE DAT SET problemFlags |= ((T.problemFlags & (2 |  4 | 8 | 16 | 32 | 64 | 128 | 256 |													8192 | 16384)) | 1), pendingDeletes = T.pendingDeletes
	FROM #DATroubleShootingInfo T INNER JOIN DATroubleShootingInfo DAT ON T.mountPathId = DAT.mountPathId AND T.libraryId = DAT.libraryId
	WHERE  DATEDIFF(day, dbo.GetDateTime(T.oldestPendingDAF), dbo.GetDateTime(@timeNow)) > 7 AND T.oldestPendingDAF > 0
	AND T.mountPathId > 0
	--Set other problem flags applicable even if there is no pruning backlog
UPDATE DAT SET problemFlags |= (T.problemFlags & ~(2 |  4 | 8 | 16 | 32 | 64 | 128 | 256 |													8192 | 16384)), jobRetentionFlags |= T.jobRetentionFlags
	FROM #DATroubleShootingInfo T INNER JOIN DATroubleShootingInfo DAT ON T.mountPathId = DAT.mountPathId AND T.libraryId = DAT.libraryId
	--Make sure the information we collected for flag bit is actually set in the table. If for any reason we skipped setting a problem flag bit skip setting the details in xml also
	DELETE DATDetails
	FROM #DATroubleShootingInfoDetails DATDetails
	WHERE NOT EXISTS (
					SELECT 1 FROM DATroubleshootingInfo DAT WITH (NOLOCK)
					WHERE DATDetails.mountPathId = DAT.mountPathId AND DATDetails.libraryId = DAT.libraryId
					AND (DATDetails.problemFlag & DAT.problemFlags > 0 OR DATDetails.jobRetentionFlag & DAT.jobRetentionFlags > 0)
					)
	--Set the severity and additional information if any in the infoXml from the table #DATroubleShootingInfoDetails
	UPDATE DAT SET infoXml = DATInfoXml.infoXml
	FROM DATroubleShootingInfo DAT
	INNER JOIN
	(
		SELECT mountPathId, libraryId,
		(
			SELECT  ProblemFlag AS [@ProblemFlag], JobRetentionFlag AS [@JobRetentionFlag], Severity AS [@Severity],
					--Populate copy ids for copy specific pruning errors
					(SELECT AGC.id AS [@id]
                        FROM #DATroubleShootingInfoDetails T2 INNER JOIN #tmpMPCopySetErrorCode CE ON T2.mountPathId = CE.mountPathId
						INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON CE.copyId = AGC.id
						WHERE T2.mountPathId = T1.mountPathId AND T2.libraryId = T1.libraryId AND T2.ProblemFlag = T1.ProblemFlag
						AND
						(
(T2.problemFlag = 32 AND CE.errorCode = 65132)
						OR
(T2.problemFlag = 128 AND CE.errorCode = 65133)
						OR
(T2.problemFlag = 256 AND CE.errorCode = 65134)
						)
                        FOR XML PATH('Copy'), TYPE, ROOT('Copies')),
                    --Populate sidb store ids for pending defrag case
                    (SELECT DS.SIDBStoreId AS [@id], DS.lastDefragRunTime AS [@lastDefragRunTime]
                        FROM #DATroubleShootingInfoDetails T3 INNER JOIN #DefragJobStores DS ON T3.libraryId = DS.libraryId
WHERE T3.mountPathId = T1.mountPathId AND T3.libraryId = T1.libraryId AND T3.ProblemFlag = T1.ProblemFlag AND T3.problemFlag = 32768
                        FOR XML PATH('SIDBStore'), TYPE, ROOT('SIDBStores'))
			FROM    #DATroubleShootingInfoDetails T1
			WHERE T1.MountPathId = T.MountPathId AND T1.libraryId = T.libraryId
			GROUP BY MountPathId, LibraryId, ProblemFlag, JobRetentionFlag, Severity
			FOR XML PATH ('Problem'),type,ROOT('InfoXML')
		) infoXml
		FROM #DATroubleShootingInfoDetails T
		GROUP BY T.mountPathId, T.libraryId
	) DATInfoXml
	ON 	DAT.mountPathId = DATInfoXml.mountPathId AND DAT.libraryId = DATInfoXml.libraryId
	/*Remove entries that do not have a problem any more*/
	DELETE DATroubleShootingInfo
	WHERE problemFlags = 0 AND jobRetentionFlags = 0
	/*Remove libraries/mount paths that doesn't exist any more. Note that this query will take care of tape libraries also whose mountPathId will be 0 in this table*/
	DELETE DAT
	FROM DATroubleShootingInfo DAT
	WHERE NOT EXISTS(SELECT 1 FROM #DATroubleShootingInfo T WHERE T.libraryId = DAT.libraryId AND T.mountPathId = DAT.mountPathId)
	IF OBJECT_ID('tempdb..#DefragJobLibs') IS NOT NULL
		DROP TABLE #DefragJobLibs
	IF OBJECT_ID('tempdb..#DefragJobStores') IS NOT NULL
		DROP TABLE #DefragJobStores
	IF OBJECT_ID('tempdb..#tmpMPCopySetErrorCode') IS NOT NULL
		DROP TABLE #tmpMPCopySetErrorCode
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @r_errorCode = -1
	;THROW
END CATCH
PROC_EXIT:
IF(OBJECT_ID('tempdb..#tblResultDAPopulateTroubleshootingInfo') IS NOT NULL)
	INSERT INTO #tblResultDAPopulateTroubleshootingInfo
	SELECT @r_errorCode
ELSE
	SELECT @r_errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'DAPopulateTroubleshootingInfo')
	delete from GxQscripts where name = 'DAPopulateTroubleshootingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAPopulateTroubleshootingInfo')
	delete from GXDBVersions where aliasname = 'DAPopulateTroubleshootingInfo'
GO

insert into GXDBVersions values(2, 'DAPopulateTroubleshootingInfo',  '00010001000200040000', 'DAPopulateTroubleshootingInfo', '00010001000200040000')
GO

