

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DAPopulateJobRetentionInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DAPopulateJobRetentionInfo.sp,v $ $Id: DAPopulateJobRetentionInfo.sp,v 1.1.2.4 2020/12/29 20:43:23 pkrishnan Exp $";
--  +========================================================================+
--  | Stored Proc:  DAPopulateJobRetentionInfo()
--  |
--  | Description:  Populate DAJobRetentionInfo table with retention information
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DAPopulateJobRetentionInfo')
BEGIN
	print '>>> Drop Stored Procedure: DAPopulateJobRetentionInfo <<<'
	drop procedure DAPopulateJobRetentionInfo
END
IF EXISTS (select * from GxQscripts where name='DAPopulateJobRetentionInfo')
	delete from GxQscripts where name = 'DAPopulateJobRetentionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAPopulateJobRetentionInfo')
	delete from GXDBVersions where aliasname = 'DAPopulateJobRetentionInfo'
GO
print '... Creating Procedure: DAPopulateJobRetentionInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DAPopulateJobRetentionInfo
  @i_flags INTEGER
AS
  DECLARE @r_errorCode INT;
SET @r_errorCode = 0
IF EXISTS(SELECT 1 FROM MMConfigs WITH(NOLOCK) WHERE name = 'DA_CONFIG_DISABLE_DATROUBLESHOOTING_DATA_COLLECTION' AND value = 1)
	GOTO PROC_EXIT
DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
IF(@i_flags & 1 > 0)
BEGIN
	IF EXISTS (
	SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) LEFT OUTER JOIN DAJobRetentionInfo DAJR WITH(NOLOCK) ON JDS.jobId = DAJR.jobId AND JDS.commcellId = DAJR.commcellId AND JDS.archGrpCopyId = DAJR.copyId AND JDS.dataType = DAJR.dataType
	WHERE JDS.status IN (100, 102, 103) AND JDS.disabled & 256 = 0 AND DAJR.jobId IS NULL
	)
	BEGIN
DECLARE @nJobsPerBatch INT = 500000
		SELECT @nJobsPerBatch = value FROM MMConfigs WITH(NOLOCK) WHERE name = 'DA_CONFIG_NUMBER_OF_JOBS_TO_PROCESS_IN_BATCH_FOR_DATROUBLESHOOTING_INFO'
		DECLARE @minJobId int = 0
		DECLARE @maxJobId int	= 0
		SELECT @minJobId = MIN(jobId), @maxJobId = MAX(jobId) FROM JMJobDataStats WITH(NOLOCK) WHERE status IN (100, 102, 103)
		DECLARE @batchMaxJobId int = 0
		DECLARE @startTime datetime = GETDATE()
		WHILE (@batchMaxJobId < @maxJobId)
		BEGIN
			SELECT @batchMaxJobId = CASE WHEN (@minJobId + @nJobsPerBatch) > @maxJobId THEN @maxJobId ELSE (@minJobId + @nJobsPerBatch) END
			INSERT INTO DAJobRetentionInfo (jobId, commcellId, copyId, dataType, archGrpId, appId, appFlags, jobFlags, retainUntil, jobRetainReason, requiredByJobIds, created, modified, infoFlags)
			SELECT jobId, commcellId, archGrpCopyId, dataType, archGrpId, appId, 0, 0, 0, 0, '', @timeNow, 0, 0
			FROM JMJobDataStats JDS WITH(NOLOCK)
			WHERE status IN (100, 102, 103) AND JDS.disabled & 256 = 0 AND jobId >=  @minJobId AND jobId <= @batchMaxJobId
			AND NOT EXISTS (SELECT 1 FROM DAJobRetentionInfo WHERE jobId = JDS.jobId AND commcellId = JDS.commcellId AND copyId = JDS.archGrpCopyId AND dataType = JDS.dataType)
			SET @minJobId = @batchMaxJobId + 1
			/*Failsafe in case we consume a lot of time here. Timeout of 2 minutes. Since this is reporting table we can reattempt during the next DA job*/
			IF (DATEDIFF (second, @startTime , GETDATE()) > 120)
			BEGIN
				SET @r_errorCode = 1
				BREAK
			END
		END
	END
END
ELSE
BEGIN
	--If spool copy old reasons would have been reset and new reasons set in archPruneSpoolCopy. So append more retention reasons here. For non-spool copy just reset
	/*
	If appIdSelectedForPruning = 0 and appIdSelectedForProcessing = 1 which happens if the subclient has data in multiple storage policies, so even though one copy is
	filtered out in granular DA, we will still process all copies. In such a case even though the subclient/copy is processed it won't be aged.
So set 8 along with any other retention reason that we may have computed in #DA_JobCopyList.
If appIdSelectedForPruning = 0 and appIdSelectedForProcessing = 0 then 8 will be set in DAGetAppIdToAge.
For spool copy 8 is set in archPruneSpoolCopy stored proc based on granular selection which will be preserved here.
	*/
UPDATE T SET jobRetainReason = CASE WHEN AC.copyIsSpool = 0 THEN (CASE WHEN AC.appIdSelectedForPruning = 1 THEN DAJ.jobRetainReason ELSE  (DAJ.jobRetainReason | 8) END) ELSE (T.jobRetainReason | DAJ.jobRetainReason) END, appFlags = DAJ.appFlags, jobFlags = DAJ.jobFlags, modified = @timeNow
	FROM DAJobRetentionInfo T INNER JOIN #DA_JobCopyList DAJ ON T.jobId = DAJ.jobId AND T.commcellId = DAJ.commcellId AND T.copyId = DAJ.copyId AND (T.dataType = DAJ.fileType OR DAJ.fileType = 0)
	INNER JOIN archAppCopyToBeAged AC WITH(NOLOCK) ON T.appId = AC.appId AND T.copyId = AC.copyId
	IF EXISTS(SELECT 1 FROM ArchGroupCopy AGC WITH(NOLOCK) WHERE isMirrorCopy = 1)
	BEGIN
			DECLARE @tblCopySource TABLE (copyId INT, sourceCopyId INT)
			INSERT INTO @tblCopySource
			SELECT DISTINCT AGC.id, CASE WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId ELSE AG.defaultSnapCopy END
			FROM ArchGroupCopy AGC WITH(NOLOCK) INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
			WHERE AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0
			WHILE EXISTS(SELECT 1 FROM @tblCopySource T INNER JOIN archGroupCopy AGC WITH(NOLOCK) ON T.sourceCopyId = AGC.id AND AGC.isMirrorCopy > 0)
			BEGIN
				UPDATE @tblCopySource SET sourceCopyId = CASE WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId ELSE AG.defaultSnapCopy END
				FROM @tblCopySource T INNER JOIN archGroupCopy AGC WITH(NOLOCK) ON T.sourceCopyId = AGC.id
				INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
				WHERE AGC.isMirrorCopy > 0
			END
			UPDATE T SET jobRetainReason = DAJ.jobRetainReason, appFlags = DAJ.appFlags, jobFlags = DAJ.jobFlags, modified = @timeNow
			FROM DAJobRetentionInfo T INNER JOIN @tblCopySource CP ON T.copyId = CP.copyId
			INNER JOIN #DA_JobCopyList DAJ ON T.jobId = DAJ.jobId AND T.commcellId = DAJ.commcellId AND CP.sourceCopyId =  DAJ.copyId AND (T.dataType = DAJ.fileType OR DAJ.fileType = 0)
	END
END
PROC_EXIT:
SELECT @r_errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'DAPopulateJobRetentionInfo')
	delete from GxQscripts where name = 'DAPopulateJobRetentionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAPopulateJobRetentionInfo')
	delete from GXDBVersions where aliasname = 'DAPopulateJobRetentionInfo'
GO

insert into GXDBVersions values(2, 'DAPopulateJobRetentionInfo',  '00010001000200040000', 'DAPopulateJobRetentionInfo', '00010001000200040000')
GO

