

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DAGetTroubleshootingInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Stored Proc:  DAGetTroubleshootingInfo()
--  |
--  | Description:  Stored proc to fetch pruning troubleshooting info
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DAGetTroubleshootingInfo.sp,v $ $Id: DAGetTroubleshootingInfo.sp,v 1.1.2.4 2020/12/29 20:43:14 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DAGetTroubleshootingInfo')
BEGIN
	print '>>> Drop Stored Procedure: DAGetTroubleshootingInfo <<<'
	drop procedure DAGetTroubleshootingInfo
END
IF EXISTS (select * from GxQscripts where name='DAGetTroubleshootingInfo')
	delete from GxQscripts where name = 'DAGetTroubleshootingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetTroubleshootingInfo')
	delete from GXDBVersions where aliasname = 'DAGetTroubleshootingInfo'
GO
print '... Creating Procedure: DAGetTroubleshootingInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DAGetTroubleshootingInfo
  @i_flags INT,
  @i_localeId INT = 0
AS
	DECLARE @r_errorCode INT
	SET @r_errorCode = 0
	BEGIN TRY
		DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
		--DECLARE @LibraryInput table(LibraryInput INT)
		DECLARE @allLibraries INT = 1
		IF(OBJECT_ID('tempdb..#LibraryInput') IS NULL)
			CREATE TABLE #LibraryInput (LibraryId INT)
		IF EXISTS (SELECT 1 FROM #LibraryInput)
			SET @allLibraries = 0
		IF OBJECT_ID('tempdb..#Output_ProblemList') IS NOT NULL
			DROP TABLE #Output_ProblemList
		CREATE TABLE #Output_ProblemList (
		LibraryId INT,
LibraryName NVARCHAR(128),
		MountPathId INT,
		MountPathName NVARCHAR(1024),
		LibraryTypeId INT,
		PendingDeletes INT,
		ProblemFlag BIGINT,
		JobRetentionFlag BIGINT,
		ProblemDescription NVARCHAR(MAX),
		Recommendation NVARCHAR(MAX),
		Doclink NVARCHAR(MAX),
		Severity INT
		)
		INSERT INTO #Output_ProblemList
SELECT DAT.LibraryId, 'N/A', DAT.MountPathId, 'N/A', 0, DAT.PendingDeletes, ISNULL(MSG.problemFlag, DAT.ProblemFlags), 0, ISNULL(EvMsg1.Message, 'N/A'), ISNULL(EvMsg2.Message, 'N/A'), ISNULL(MSG.docLink, 'N/A'), 2
		FROM DATroubleShootingInfo DAT WITH(NOLOCK)
		LEFT OUTER JOIN DATroubleshootingMsgMap MSG WITH(NOLOCK) ON DAT.ProblemFlags & MSG.ProblemFlag > 0
		LEFT OUTER JOIN EvLocaleMsgs EvMsg1 WITH(NOLOCK) ON MSG.problemMsgId = EvMsg1.MessageID AND EvMsg1.LocaleID = @i_localeId
		LEFT OUTER JOIN EvLocaleMsgs EvMsg2 WITH(NOLOCK) ON MSG.recMsgId = EvMsg2.MessageID AND EvMsg2.localeId = @i_localeId
		WHERE DAT.problemFlags > 0 AND (@allLibraries = 1 OR DAT.libraryId IN (SELECT LibraryId FROM #LibraryInput))
		INSERT INTO #Output_ProblemList
SELECT DAT.LibraryId, 'N/A', DAT.MountPathId, 'N/A', 0, DAT.PendingDeletes, 0, ISNULL(MSG.jobRetentionFlag, DAT.JobRetentionFlags), ISNULL(EvMsg1.Message, 'N/A'), ISNULL(EvMsg2.Message, 'N/A'), ISNULL(MSG.docLink, 'N/A'), 2
		FROM DATroubleShootingInfo DAT WITH(NOLOCK)
		LEFT OUTER JOIN DATroubleshootingMsgMap MSG WITH(NOLOCK) ON DAT.JobRetentionFlags & MSG.jobRetentionFlag > 0
		LEFT OUTER JOIN EvLocaleMsgs EvMsg1 WITH(NOLOCK) ON MSG.problemMsgId = EvMsg1.MessageID AND EvMsg1.LocaleID = @i_localeId
		LEFT OUTER JOIN EvLocaleMsgs EvMsg2 WITH(NOLOCK) ON MSG.recMsgId = EvMsg2.MessageID AND EvMsg2.localeId = @i_localeId
		WHERE DAT.JobRetentionFlags > 0 AND (@allLibraries = 1 OR DAT.libraryId IN (SELECT LibraryId FROM #LibraryInput))
		UPDATE #Output_ProblemList SET LibraryName = Lib.AliasName, LibraryTypeId = Lib.LibraryTypeId
		FROM #Output_ProblemList T INNER JOIN MMLibrary Lib WITH(NOLOCK) ON T.LibraryId = Lib.LibraryId
		UPDATE #Output_ProblemList SET MountPathName = MP.MountPathName
		FROM #Output_ProblemList T INNER JOIN MMS2getMountPathNameGUIView MP WITH(NOLOCK) ON T.MountPathId = MP.MountPathId
		WHERE T.MountPathId > 0
		;WITH DATroubleShootingInfoDetails_CTE
		AS
		(
			SELECT mountPathId, LibraryId, P.I.value('@ProblemFlag', 'int') AS ProblemFlag,
	   		P.I.value('@JobRetentionFlag', 'int') AS jobRetentionFlag,
	   		P.I.value('@Severity', 'int') AS severity
			FROM DATroubleshootingInfo DAT
			CROSS APPLY DAT.infoXml.nodes('InfoXML/Problem') as P(I)
		)
		UPDATE #Output_ProblemList
		SET severity = CTE.severity
		FROM #Output_ProblemList PL INNER JOIN DATroubleShootingInfoDetails_CTE CTE ON PL.mountPathId = CTE.mountPathId AND PL.libraryId = CTE.libraryId
		AND PL.ProblemFlag = CTE.ProblemFlag AND PL.jobRetentionFlag = CTE.jobRetentionFlag
		DECLARE @jobsRetainedBeyondRetentionGenericText NVARCHAR(1024)
		SELECT @jobsRetainedBeyondRetentionGenericText = Message
		FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (3123 | (CAST(POWER(2, 24) AS BIGINT) * 62)) AND localeId = @i_localeId
		DECLARE @reasonForNotAgingText NVARCHAR(128)
		SELECT @reasonForNotAgingText = Message
		FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (247 | (CAST(POWER(2, 24) AS BIGINT) * 61)) AND localeId = @i_localeId
		--Add a generic message about jobs being retained beyond retention, before the actual retention reason of these jobs
UPDATE #Output_ProblemList SET ProblemDescription =  @jobsRetainedBeyondRetentionGenericText + ' ; ' + ' ; ' + @reasonForNotAgingText +  ':' + ' ; ' + ProblemDescription
		WHERE jobRetentionFlag > 0
IF EXISTS( SELECT 1 FROM #Output_ProblemList WHERE problemFlag IN( 8,
16,
8192,
64,
256 )
				 )
		BEGIN
			DECLARE @deviceControllerLocalizedText NVARCHAR(1024)
			SELECT @deviceControllerLocalizedText = Message
			FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (3686 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId
			--For these problems we should add device controller information
UPDATE #Output_ProblemList SET ProblemDescription = ProblemDescription + ' ; ' + ' ; '  + @deviceControllerLocalizedText + ':' + ' ; ' + C.DeviceControllers
			FROM #Output_ProblemList T INNER JOIN
			(
			SELECT
		    T1.mountPathId, STUFF(
		                    (SELECT
' ; ' + T2.mountPathName
		                        FROM MMGetMountPathControllersView T2
		                        WHERE T2.mountPathId = T1.mountPathId
		                        FOR XML PATH(''), TYPE
		                    ).value('.','varchar(max)')
		                    ,1,2, ''
		                ) AS DeviceControllers
		    FROM #Output_ProblemList T1
WHERE T1.problemFlag IN( 8,
16,
8192,
64,
256 )
		    GROUP BY T1.mountPathId
			) C ON T.mountPathId = C.mountPathId
WHERE T.problemFlag IN( 8,
16,
8192,
64,
256 )
		END
IF EXISTS( SELECT 1 FROM #Output_ProblemList WHERE problemFlag = 16384 )
		BEGIN
			DECLARE @mediaAgentLocalizedText NVARCHAR(1024)
			SELECT @mediaAgentLocalizedText = Message
			FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (3820 | (CAST(POWER(2, 24) AS BIGINT) * 119)) AND localeId = @i_localeId
			--Populate media agents
UPDATE #Output_ProblemList SET ProblemDescription = ProblemDescription + ' ; ' + ' ; ' + @mediaAgentLocalizedText + ':' + ' ; ' + C.MediaAgents
			FROM #Output_ProblemList T INNER JOIN
			(
			SELECT
		    T1.mountPathId, STUFF(
		                    (SELECT
' ; ' + CL.displayName
		                        FROM MMMountPathPrunerView T2 INNER JOIN App_Client CL WITH(NOLOCK) ON T2.HostClientId = CL.id
		                        WHERE T2.mountPathId = T1.mountPathId AND T2.PruningOpAllowed = 0
		                        FOR XML PATH(''), TYPE
		                    ).value('.','varchar(max)')
		                    ,1,2, ''
		                ) AS MediaAgents
		    FROM #Output_ProblemList T1
WHERE T1.problemFlag = 16384
		    GROUP BY T1.mountPathId
			) C ON T.mountPathId = C.mountPathId
WHERE T.problemFlag = 16384
		END
IF EXISTS( SELECT 1 FROM #Output_ProblemList WHERE problemFlag IN (32, 128, 256) )
		BEGIN
			DECLARE @storagePolicyCopyLocalizedText NVARCHAR(1024)
			SELECT @storagePolicyCopyLocalizedText = Message
			FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (3571 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId
			;WITH MP_CopyList_CTE AS
			(
			SELECT mountPathId, LibraryId, P.I.value('@ProblemFlag', 'int') AS ProblemFlag,
			D.C.value('@id', 'int') AS CopyId
			FROM DATroubleshootingInfo DAT
			CROSS APPLY DAT.infoXml.nodes('InfoXML/Problem') as P(I)
			CROSS APPLY P.I.nodes('Copies/Copy') as D(C)
WHERE problemFlags & (32 | 128 | 256) > 0
			)
			--Populate storage policy copy names for error DA_TROUBLESHOOT_NO_DATAPATH_MA
UPDATE #Output_ProblemList SET ProblemDescription = ProblemDescription + ' ; ' + ' ; ' + @storagePolicyCopyLocalizedText + ':' + ' ; ' + C.SPCopies
			FROM #Output_ProblemList T INNER JOIN
			(
			SELECT
		    T1.mountPathId, T1.ProblemFlag, STUFF(
		                    (SELECT
		                        ' ; ' + AG.name + '/' + AGC.name
		                        FROM MP_CopyList_CTE T2 INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON T2.copyId = AGC.id
		                        INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
		                        WHERE T2.mountPathId = T1.mountPathId AND T2.problemFlag = T1.ProblemFlag
		                        FOR XML PATH(''), TYPE
		                    ).value('.','varchar(max)')
		                    ,1,2, ''
		                ) AS SPCopies
		    FROM #Output_ProblemList T1
WHERE T1.problemFlag IN (32, 128, 256)
		    GROUP BY T1.mountPathId, T1.ProblemFlag
			) C ON T.mountPathId = C.mountPathId AND T.ProblemFlag = C.ProblemFlag
		END
IF EXISTS( SELECT 1 FROM #Output_ProblemList WHERE problemFlag = 32768 )
		BEGIN
			DECLARE @storeLocalizedText NVARCHAR(1024)
			SELECT @storeLocalizedText = '[' + Message + ']'
			FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (3571 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId
			SELECT @storeLocalizedText = @storeLocalizedText + ' - ' + Message
			FROM EvLocaleMsgs WITH(NOLOCK)
WHERE MessageID = (3048 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId
			;WITH StoreList_CTE AS
			(
			SELECT mountPathId, LibraryId, P.I.value('@ProblemFlag', 'int') AS ProblemFlag,
			D.C.value('@id', 'int') AS SIDBStoreId
			FROM DATroubleshootingInfo DAT
			CROSS APPLY DAT.infoXml.nodes('InfoXML/Problem') as P(I)
			CROSS APPLY P.I.nodes('SIDBStores/SIDBStore') as D(C)
WHERE problemFlags & 32768 > 0
			)
			--Populate SIDB store information for error DA_TROUBLESHOOT_NO_DRILL_HOLE_SUPPORT_NO_DEFRAG
UPDATE #Output_ProblemList SET ProblemDescription = ProblemDescription + ' ; ' + ' ; ' + @storeLocalizedText + ':' + ' ; ' + C.Stores
			FROM #Output_ProblemList T INNER JOIN
			(
			SELECT
		    T1.mountPathId, T1.ProblemFlag, STUFF(
		                    (SELECT
		                        ' ; ' + '[' + AG.name + '/' + AGC.name + ']' + ' - ' + S.SIDBStoreAliasName
		                        FROM StoreList_CTE T2 INNER JOIN ArchCopySIDBStore ACS WITH(NOLOCK) ON T2.SIDBStoreId = ACS.SIDBStoreId
		                        INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON ACS.copyId = AGC.id
		                        INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
		                        INNER JOIN IdxSIDBStore S WITH(NOLOCK) ON ACS.SIDBStoreId = S.SIDBStoreId
		                        WHERE T2.mountPathId = T1.mountPathId AND T2.problemFlag = T1.ProblemFlag
AND AGC.dedupeFlags & 134217728 = 0 --Only get the GDSP host name
		                        FOR XML PATH(''), TYPE
		                    ).value('.','varchar(max)')
		                    ,1,2, ''
		                ) AS Stores
		    FROM #Output_ProblemList T1
WHERE T1.problemFlag = 32768
		    GROUP BY T1.mountPathId, T1.ProblemFlag
			) C ON T.mountPathId = C.mountPathId AND T.ProblemFlag = C.ProblemFlag
		END
		IF OBJECT_ID('tempdb..#tblOutDAGetTroubleshootingInfo') IS NOT NULL
			INSERT INTO #tblOutDAGetTroubleshootingInfo
			SELECT * FROM #Output_ProblemList
		ELSE
			SELECT * FROM #Output_ProblemList
			ORDER BY Severity DESC, LibraryName, MountPathName
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @r_errorCode = -1
		;THROW
	END CATCH
PROC_EXIT:
RETURN @r_errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'DAGetTroubleshootingInfo')
	delete from GxQscripts where name = 'DAGetTroubleshootingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetTroubleshootingInfo')
	delete from GXDBVersions where aliasname = 'DAGetTroubleshootingInfo'
GO

insert into GXDBVersions values(2, 'DAGetTroubleshootingInfo',  '00010001000200040000', 'DAGetTroubleshootingInfo', '00010001000200040000')
GO

