

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DAGetJobsRetentionReason.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +==============================================================================================+
--  | Stored Proc:  DAGetJobsRetentionReason
--  |
--  | Description:  Stored proc to fetch retention reasons for given input job list from DAJobRetentionInfo table
--  +==============================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DAGetJobsRetentionReason.sp,v $ $Id: DAGetJobsRetentionReason.sp,v 1.1.2.1 2020/12/16 21:27:15 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DAGetJobsRetentionReason')
BEGIN
	print '>>> Drop Stored Procedure: DAGetJobsRetentionReason <<<'
	drop procedure DAGetJobsRetentionReason
END
IF EXISTS (select * from GxQscripts where name='DAGetJobsRetentionReason')
	delete from GxQscripts where name = 'DAGetJobsRetentionReason'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetJobsRetentionReason')
	delete from GXDBVersions where aliasname = 'DAGetJobsRetentionReason'
GO
print '... Creating Procedure: DAGetJobsRetentionReason'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DAGetJobsRetentionReason
  @i_flags INT,
  @i_localeId INT = 0
AS
	SET NOCOUNT ON
	DECLARE @r_errorCode INT
	SET @r_errorCode = 0
	BEGIN TRY
		/*
		Caller has to create this table. Populate jobRetentionFlag with -1 in the caller.
		IF OBJECT_ID('tempdb..#JobRetentionReason') IS NOT NULL
			DROP TABLE #JobRetentionReason
		CREATE TABLE #JobRetentionReason (jobId INT, commcellId INT, copyId INT, dataType INT, jobRetentionFlag BIGINT, jobRetentionReason NVARCHAR(MAX), recommendation NVARCHAR(MAX))
		*/
		INSERT INTO #JobRetentionReason
		SELECT J.jobId, J.commcellId, J.copyId, J.dataType, ISNULL(ISNULL(MSG.jobRetentionFlag, DAJ.jobRetainReason), 0), ISNULL(EvMsg1.Message, 'N/A'), ISNULL(EvMsg2.Message, 'N/A')
		FROM #JobRetentionReason J
		LEFT OUTER JOIN DAJobRetentionInfo DAJ WITH(NOLOCK) ON J.jobId = DAJ.jobId AND J.commcellId = DAJ.commcellId
		AND J.copyId = DAJ.copyId AND J.dataType = DAJ.dataType
		LEFT OUTER JOIN DATroubleshootingMsgMap MSG WITH(NOLOCK) ON DAJ.jobRetainReason & MSG.jobRetentionFlag > 0
		LEFT OUTER JOIN EvLocaleMsgs EvMsg1 WITH(NOLOCK) ON MSG.problemMsgId = EvMsg1.MessageID AND EvMsg1.LocaleID = 0
		LEFT OUTER JOIN EvLocaleMsgs EvMsg2 WITH(NOLOCK) ON MSG.recMsgId = EvMsg2.MessageID AND EvMsg2.localeId = @i_localeId
		/*Delete the rows sent by caller as we have repopulated the job list above with retention reasons we could find*/
		DELETE #JobRetentionReason WHERE jobRetentionFlag = -1
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @r_errorCode = -1
		;THROW
	END CATCH
PROC_EXIT:
RETURN @r_errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'DAGetJobsRetentionReason')
	delete from GxQscripts where name = 'DAGetJobsRetentionReason'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetJobsRetentionReason')
	delete from GXDBVersions where aliasname = 'DAGetJobsRetentionReason'
GO

insert into GXDBVersions values(2, 'DAGetJobsRetentionReason',  '00010001000200010000', 'DAGetJobsRetentionReason', '00010001000200010000')
GO

