

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DAGetJobsRetainingMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +==============================================================================================+
--  | Stored Proc:  DAGetJobsRetainingMedia
--  |
--  | Description:  Stored proc to fetch jobs on tape media that are holding back the media beyond expected retention time
--  +==============================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DAGetJobsRetainingMedia.sp,v $ $Id: DAGetJobsRetainingMedia.sp,v 1.1.2.1 2020/12/16 21:27:18 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DAGetJobsRetainingMedia')
BEGIN
	print '>>> Drop Stored Procedure: DAGetJobsRetainingMedia <<<'
	drop procedure DAGetJobsRetainingMedia
END
IF EXISTS (select * from GxQscripts where name='DAGetJobsRetainingMedia')
	delete from GxQscripts where name = 'DAGetJobsRetainingMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetJobsRetainingMedia')
	delete from GXDBVersions where aliasname = 'DAGetJobsRetainingMedia'
GO
print '... Creating Procedure: DAGetJobsRetainingMedia'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DAGetJobsRetainingMedia
  @i_flags INT,
  @i_localeId INT = 0
AS
	SET NOCOUNT ON
	DECLARE @r_errorCode INT
	SET @r_errorCode = 0
	BEGIN TRY
		DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
		--DECLARE @LibraryInput table(LibraryInput INT)
		DECLARE @allLibraries INT = 1
		/*Supposed to be created by caller. If caller did not create it, create here so queries won't fail*/
		IF OBJECT_ID('tempdb..#LibraryInput') IS NULL
			CREATE TABLE #LibraryInput (LibraryId INT)
		IF OBJECT_ID('tempdb..#LibraryMediaList') IS NOT NULL
			DROP TABLE #LibraryMediaList
CREATE TABLE #LibraryMediaList (LibraryId INT, LibraryName NVARCHAR(128), MediaId INT, Barcode VARCHAR(256), PRIMARY KEY(MediaId))
		IF OBJECT_ID('tempdb..#MediaJobList') IS NOT NULL
			DROP TABLE #MediaJobList
		CREATE TABLE #MediaJobList (MediaId INT, jobId INT, commcellId INT, copyId INT, dataType INT, appId INT, PRIMARY KEY(MediaId, jobId, commcellId, copyId, dataType))
		CREATE INDEX Idx_MediaJobList_JobId_CommcellId_CopyId_DataType ON #MediaJobList (jobId, commcellId, copyId, dataType)
		IF NOT EXISTS (SELECT 1 FROM #LibraryInput)
			INSERT INTO #LibraryMediaList
			SELECT DISTINCT DAT.LibraryId, Lib.aliasName, M.MediaId, M.barCode
			FROM DATroubleshootingInfo DAT WITH(NOLOCK) INNER JOIN MMLibrary Lib WITH(NOLOCK) ON DAT.libraryId = Lib.libraryId
			INNER JOIN MMMedia M WITH(NOLOCK) ON Lib.libraryId = M.libraryId
WHERE DAT.problemFlags & 2048 > 0
			AND M.MediaTypeId <> 10001 AND M.retentionExpireTime < @timeNow AND M.retentionExpireTime > 0 AND M.IsInMediaGroup = 1 AND M.IsAged = 0
		ELSE
			INSERT INTO #LibraryMediaList
			SELECT DISTINCT DAT.LibraryId, Lib.aliasName, M.MediaId, M.barCode
			FROM DATroubleshootingInfo DAT WITH(NOLOCK) INNER JOIN MMLibrary Lib WITH(NOLOCK) ON DAT.libraryId = Lib.libraryId
			INNER JOIN MMMedia M WITH(NOLOCK) ON Lib.libraryId = M.libraryId
WHERE DAT.problemFlags & 2048 > 0
			AND M.MediaTypeId <> 10001 AND M.retentionExpireTime < @timeNow AND M.retentionExpireTime > 0 AND M.IsInMediaGroup = 1 AND M.IsAged = 0
			AND Lib.libraryId IN (SELECT libraryId FROM #LibraryInput)
		INSERT INTO #MediaJobList
		SELECT DISTINCT M.MediaId, ACM.jobId, ACM.commCellId, ACM.archCopyId, AF.fileType, AF.appId
		FROM #LibraryMediaList M INNER JOIN MMVolume Vol ON M.MediaId = Vol.MediaId
		INNER JOIN archChunk AC (NOLOCK) ON Vol.VolumeId = AC.volumeId
		INNER JOIN archChunkMapping ACM (NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
		INNER JOIN archFile AF (NOLOCK) ON ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId
WHERE ACM.flags & 256 = 0
		IF OBJECT_ID('tempdb..#JobRetentionReason') IS NOT NULL
			DROP TABLE #JobRetentionReason
		/*Not creating primary key on this intentionaly as there could be multiple retention reasons for same job*/
		CREATE TABLE #JobRetentionReason (jobId INT, commcellId INT, copyId INT, dataType INT, jobRetentionFlag BIGINT, jobRetentionReason NVARCHAR(MAX), recommendation NVARCHAR(MAX))
		CREATE INDEX Idx_JobRetentionReason_JobId_CommcellId_CopyId_DataType ON #JobRetentionReason (jobId, commcellId, copyId, dataType)
		INSERT INTO #JobRetentionReason
		SELECT DISTINCT jobId, commcellId, copyId, dataType, -1, '', ''
		FROM #MediaJobList
		EXEC DAGetJobsRetentionReason @i_localeId
		IF OBJECT_ID('tempdb..#JobsRetainingMediaList') IS NOT NULL
			DROP TABLE #JobsRetainingMediaList
		CREATE TABLE #JobsRetainingMediaList (
			LibraryId INT,
Library NVARCHAR(128),
			MediaId INT,
Barcode VARCHAR(256),
			JobId INT,
			CommcellId INT,
			BackupTime DateTime,
			appId INT,
Client NVARCHAR(255),
Agent VARCHAR(255),
Subclient NVARCHAR(255),
			jobRetentionFlag BIGINT,
			jobRetentionReason NVARCHAR(MAX),
			recommendation	NVARCHAR(MAX)
		)
		INSERT INTO #JobsRetainingMediaList
		SELECT DISTINCT T1.libraryId, T1.libraryName, T1.mediaId, T1.barCode, T3.jobId, T3.commcellId, 0, T2.appId, '', '', '', T3.jobRetentionFlag, T3.jobRetentionReason, T3.recommendation
		FROM #LibraryMediaList T1 INNER JOIN #MediaJobList T2 ON T1.mediaId = T2.mediaId
		INNER JOIN #JobRetentionReason T3 ON T2.jobId = T3.jobId AND T2.commcellId = T3.commcellId AND T2.copyId = T3.copyId AND T2.dataType = T3.dataType
		UPDATE T SET BackupTime = dbo.UTCToClientLocalTime(dbo.GetDateTime(JBKP.servStartDate), 2)
		FROM #JobsRetainingMediaList T INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON T.jobId = JBKP.jobId AND T.commcellId = JBKP.commcellId
		UPDATE T SET BackupTime = dbo.UTCToClientLocalTime(dbo.GetDateTime(JBKP.servStart), 2)
		FROM #JobsRetainingMediaList T INNER JOIN JMAdminJobStatsTable JBKP WITH(NOLOCK) ON T.jobId = JBKP.jobId AND T.commcellId = JBKP.commcellId
		UPDATE T
		SET Client = CL.displayName, Agent = IDA.name, Subclient = App.subClientName
		FROM #JobsRetainingMediaList T INNER JOIN App_Application App WITH(NOLOCK) ON T.appId = App.id
		INNER JOIN App_Client CL WITH(NOLOCK) ON App.ClientId = CL.id
		INNER JOIN App_IdaType IDA ON App.appTypeId = IDA.type
		IF OBJECT_ID('tempdb..#tblOutDAGetJobsRetainingMedia') IS NOT NULL
			INSERT INTO #tblOutDAGetJobsRetainingMedia
			SELECT * FROM #JobsRetainingMediaList
		ELSE
			SELECT * FROM #JobsRetainingMediaList
			ORDER BY Library, Barcode, jobId
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @r_errorCode = -1
		;THROW
	END CATCH
PROC_EXIT:
	IF OBJECT_ID('tempdb..#LibraryMediaList') IS NOT NULL
		DROP TABLE #LibraryMediaList
	IF OBJECT_ID('tempdb..#MediaJobList') IS NOT NULL
		DROP TABLE #MediaJobList
	IF OBJECT_ID('tempdb..#JobRetentionReason') IS NOT NULL
		DROP TABLE #JobRetentionReason
	IF OBJECT_ID('tempdb..#JobsRetainingMediaList') IS NOT NULL
		DROP TABLE #JobsRetainingMediaList
RETURN @r_errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'DAGetJobsRetainingMedia')
	delete from GxQscripts where name = 'DAGetJobsRetainingMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetJobsRetainingMedia')
	delete from GXDBVersions where aliasname = 'DAGetJobsRetainingMedia'
GO

insert into GXDBVersions values(2, 'DAGetJobsRetainingMedia',  '00010001000200010000', 'DAGetJobsRetainingMedia', '00010001000200010000')
GO

