

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DAGetInactiveClientInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +==============================================================================================+
--  | Stored Proc:  DAGetInactiveClientInfo
--  |
--  | Description:  Stored proc to fetch pruning troubleshooting info - InactiveClientInfo
--  +==============================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DAGetInactiveClientInfo.sp,v $ $Id: DAGetInactiveClientInfo.sp,v 1.1.2.1 2020/12/16 21:27:36 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DAGetInactiveClientInfo')
BEGIN
	print '>>> Drop Stored Procedure: DAGetInactiveClientInfo <<<'
	drop procedure DAGetInactiveClientInfo
END
IF EXISTS (select * from GxQscripts where name='DAGetInactiveClientInfo')
	delete from GxQscripts where name = 'DAGetInactiveClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetInactiveClientInfo')
	delete from GXDBVersions where aliasname = 'DAGetInactiveClientInfo'
GO
print '... Creating Procedure: DAGetInactiveClientInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DAGetInactiveClientInfo
  @i_flags INT
AS
	SET NOCOUNT ON
	DECLARE @r_errorCode INT
	SET @r_errorCode = 0
	BEGIN TRY
		DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
		DECLARE @secondsOf90Days INT = (90*24*3600)
		--DECLARE @LibraryInput table(LibraryInput INT)
		DECLARE @allLibraries INT = 1
		/*Supposed to be created by caller. If caller did not create it, create here so queries won't fail*/
		IF OBJECT_ID('tempdb..#LibraryInput') IS NULL
			CREATE TABLE #LibraryInput (LibraryId INT)
		IF OBJECT_ID('tempdb..#LibraryMountPathList') IS NOT NULL
			DROP TABLE #LibraryMountPathList
		CREATE TABLE #LibraryMountPathList (LibraryId INT, MountPathId INT)
		IF NOT EXISTS (SELECT 1 FROM #LibraryInput)
			INSERT INTO #LibraryMountPathList
			SELECT DISTINCT LibraryId, mountPathId
			FROM DATroubleshootingInfo WITH(NOLOCK)
WHERE problemFlags & 1024 > 0
		ELSE
			INSERT INTO #LibraryMountPathList
			SELECT DISTINCT LibraryId, mountPathId
			FROM DATroubleshootingInfo WITH(NOLOCK)
WHERE problemFlags & 1024 > 0
			AND libraryId IN (SELECT libraryId FROM #LibraryInput)
		IF OBJECT_ID('tempdb..#InactiveClientStorageList') IS NOT NULL
			DROP TABLE #InactiveClientStorageList
		CREATE TABLE #InactiveClientStorageList (
		LibraryId INT,
		MountPathId INT,
		AppId INT
		)
		IF OBJECT_ID('tempdb..#InactiveClientList') IS NOT NULL
			DROP TABLE #InactiveClientList
		CREATE TABLE #InactiveClientList (
		AppId INT,
		LastFullBackup INT,
		LastBackup INT
		)
		INSERT INTO #InactiveClientStorageList
		SELECT DISTINCT M.libraryId, ISNULL(MP.mountPathId, 0) "MountPathId", J.appId
		FROM DAJobRetentionInfo J WITH(NOLOCK) INNER JOIN ArchChunkMapping ACM WITH(NOLOCK)
		ON J.jobId = ACM.jobId AND J.commcellId = ACM.commcellId AND J.copyId = ACM.archCopyId
		INNER JOIN ArchFile AF WITH(NOLOCK) ON ACM.archFileId = AF.id AND ACM.commcellId = AF.commcellId AND J.dataType = AF.fileType
		INNER JOIN ArchChunk AC WITH(NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommcellId = AC.commcellId
		INNER JOIN MMVolume Vol WITH(NOLOCK) ON AC.volumeId = Vol.VolumeId
		INNER JOIN MMMedia M WITH(NOLOCK) ON Vol.mediaId = M.mediaId
		LEFT OUTER JOIN MMMountPath MP WITH(NOLOCK) ON Vol.mediaSideId = MP.mediaSideId
WHERE J.jobRetainReason & 32 > 0
		AND EXISTS (SELECT 1 FROM #LibraryMountPathList WHERE libraryId = M.libraryId AND mountPathId = ISNULL(MP.mountPathId, 0))
		INSERT INTO #InactiveClientList
		SELECT DISTINCT appId, 0, 0
		FROM #InactiveClientStorageList
		UPDATE T1
		SET LastFullBackup = T2.LastFullBackup
		FROM #InactiveClientList T1 INNER JOIN
		(
		SELECT JBKP.appId, MAX(jbkp.servStartDate) "LastFullBackup"
		FROM JMBkpStats JBKP WITH(NOLOCK) INNER JOIN #InactiveClientList App ON JBKP.appId = App.appId
		WHERE JBKP.status IN (1, 3, 14) AND JBKP.bkpLevel IN (1, 64, 128, 16384, 1024, 32768)
		GROUP BY JBKP.appId
		) T2 ON T1.appId = T2.appId
		--Check admin jobs
		IF EXISTS(SELECT 1 FROM #InactiveClientList WHERE lastFullBackup = 0)
		BEGIN
			UPDATE T1
			SET LastFullBackup = T2.LastFullBackup
			FROM #InactiveClientList T1 INNER JOIN
			(
			SELECT JBKP.appId, MAX(jbkp.servStart) "LastFullBackup"
			FROM JMAdminJobStatsTable JBKP WITH(NOLOCK) INNER JOIN #InactiveClientList App ON JBKP.appId = App.appId
			WHERE JBKP.status IN (1, 3, 14) AND JBKP.ER_BkpLevel IN (1, 64, 128, 16384, 1024, 32768)
			GROUP BY JBKP.appId
			) T2 ON T1.appId = T2.appId
		END
		--Ignore subclients that had a full backup within last 90 days
		DELETE #InactiveClientList
		WHERE LastFullBackup = 0 /*Not sure why it would be 0 here, but just eliminating this case to check if lastFUllBackup is older than 90 days*/
				OR ((@timeNow - LastFullBackup) < @secondsOf90Days)
		UPDATE T1
		SET LastBackup = T2.LastBackup
		FROM #InactiveClientList T1 INNER JOIN
		(
		SELECT JBKP.appId, MAX(jbkp.servStartDate) "LastBackup"
		FROM JMBkpStats JBKP WITH(NOLOCK) INNER JOIN #InactiveClientList App ON JBKP.appId = App.appId
		WHERE JBKP.status IN (1, 3, 14)
		GROUP BY JBKP.appId
		) T2 ON T1.appId = T2.appId
		--Check admin jobs
		IF EXISTS(SELECT 1 FROM #InactiveClientList WHERE LastBackup = 0)
		BEGIN
			UPDATE T1
			SET LastBackup = T2.LastBackup
			FROM #InactiveClientList T1 INNER JOIN
			(
			SELECT JBKP.appId, MAX(jbkp.servStart) "LastBackup"
			FROM JMAdminJobStatsTable JBKP WITH(NOLOCK) INNER JOIN #InactiveClientList App ON JBKP.appId = App.appId
			WHERE JBKP.status IN (1, 3, 14)
			GROUP BY JBKP.appId
			) T2 ON T1.appId = T2.appId
		END
		IF OBJECT_ID('tempdb..#InactiveClientOutputList') IS NOT NULL
			DROP TABLE #InactiveClientOutputList
CREATE TABLE #InactiveClientOutputList (Storage NVARCHAR(MAX), ClientName NVARCHAR(255), AgentName VARCHAR(255), SubclientName NVARCHAR(255), LastFullBackup DateTime, LastBackup DateTime)
		INSERT INTO #InactiveClientOutputList
  		SELECT
  		STUFF((
	    SELECT ';;' + lib.aliasName + ISNULL('\' + MP.MountPathName, '')
	    FROM #InactiveClientStorageList T1
	    INNER JOIN MMLibrary lib WITH(NOLOCK) ON T1.libraryId = lib.libraryId
	    LEFT OUTER JOIN MMS2getMountPathNameGUIView MP WITH(NOLOCK) ON T1.mountPathId = MP.mountPathId
	    WHERE T1.appId = T.appId
	    FOR XML PATH(''),TYPE).value('(./text())[1]','VARCHAR(MAX)')
  		,1,2,''),
  		CL.displayName, AppType.name, App.subclientName, dbo.UTCToClientLocalTime(dbo.GetDateTime(LastFullBackup), 2), dbo.UTCToClientLocalTime(dbo.GetDateTime(LastBackup), 2)
		FROM #InactiveClientList T
		INNER JOIN App_Application App WITH(NOLOCK) ON T.appId = App.id
		INNER JOIN App_Client CL WITH(NOLOCK) ON App.clientId = CL.id
		--INNER JOIN App_BackupSetName BKP WITH(NOLOCK) ON App.backupSet = BKP.id
		--INNER JOIN App_InstanceName INS WITH(NOLOCK) ON App.instance = INS.id
		INNER JOIN App_IDAType AppType WITH(NOLOCK) ON App.appTypeId = AppType.type
		IF OBJECT_ID('tempdb..#tblOutDAGetInactiveClientInfo') IS NOT NULL
			INSERT INTO #tblOutDAGetInactiveClientInfo
			SELECT * FROM #InactiveClientOutputList
		ELSE
			SELECT * FROM #InactiveClientOutputList
			ORDER BY ClientName, AgentName, SubclientName
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @r_errorCode = -1
		;THROW
	END CATCH
PROC_EXIT:
IF OBJECT_ID('tempdb..#LibraryMountPathList') IS NOT NULL
	DROP TABLE #LibraryMountPathList
IF OBJECT_ID('tempdb..#InactiveClientList') IS NOT NULL
	DROP TABLE #InactiveClientList
IF OBJECT_ID('tempdb..#InactiveClientStorageList') IS NOT NULL
	DROP TABLE #InactiveClientStorageList
IF OBJECT_ID('tempdb..#InactiveClientOutputList') IS NOT NULL
	DROP TABLE #InactiveClientOutputList
RETURN @r_errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'DAGetInactiveClientInfo')
	delete from GxQscripts where name = 'DAGetInactiveClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetInactiveClientInfo')
	delete from GXDBVersions where aliasname = 'DAGetInactiveClientInfo'
GO

insert into GXDBVersions values(2, 'DAGetInactiveClientInfo',  '00010001000200010000', 'DAGetInactiveClientInfo', '00010001000200010000')
GO

