

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DAGetEdgeSubclientsToAge.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  DAGetEdgeSubclientsToAge.sp	                              */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DAGetEdgeSubclientsToAge.sp,v $ $Id: DAGetEdgeSubclientsToAge.sp,v 1.2.2.1 2020/09/19 04:42:15 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DAGetEdgeSubclientsToAge')
BEGIN
	print '>>> Drop Stored Procedure: DAGetEdgeSubclientsToAge <<<'
	drop procedure DAGetEdgeSubclientsToAge
END
IF EXISTS (select * from GxQscripts where name='DAGetEdgeSubclientsToAge')
	delete from GxQscripts where name = 'DAGetEdgeSubclientsToAge'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetEdgeSubclientsToAge')
	delete from GXDBVersions where aliasname = 'DAGetEdgeSubclientsToAge'
GO
print '... Creating Procedure: DAGetEdgeSubclientsToAge'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DAGetEdgeSubclientsToAge
AS
  DECLARE @r_appId INTEGER;
  DECLARE @r_isDeleted INTEGER;
  DECLARE @r_analyticsEngineType INTEGER;
IF OBJECT_ID('tempdb..#edgeSubclientsToProcess') IS NOT NULL
	DROP TABLE #edgeSubclientsToProcess
CREATE TABLE #edgeSubclientsToProcess (appId INT, isDeleted INT, analyticsEngineType INT, PRIMARY KEY(appId))
IF EXISTS(SELECT 1 FROM archFileEdgeDrive WITH(NOLOCK) WHERE analyticsEngineType = 0)
BEGIN
	INSERT INTO #edgeSubclientsToProcess
	SELECT distinct appId, 0, 0 FROM archFileEdgeDrive WITH(NOLOCK)
	/*
    Updating analyticsenginetype this way because if there were rows in table before this new update, they might have enginetype as 0.
    So assuming a case of same appId having mix of rows, some with analyticsEngineType = 0 and some with > 0, setting analyticsEngineType
	by picking them from rows with valid analyticsEngineType
    */
    UPDATE T1 SET analyticsEngineType = T2.analyticsEngineType
    FROM #edgeSubclientsToProcess T1,
    (SELECT distinct appId, analyticsEngineType FROM archFileEdgeDrive WITH(NOLOCK) WHERE analyticsEngineType > 0) T2
    WHERE T1.appId = T2.appId
END
ELSE
BEGIN
	/*
	This query would have been prone to error if there were mix of analyticsEngineType value for same appId.
	Hence doing this only if there are no rows with analyticsEngineType = 0
	*/
	INSERT INTO #edgeSubclientsToProcess
	SELECT distinct appId, 0, analyticsEngineType FROM archFileEdgeDrive WITH(NOLOCK)
END
UPDATE #edgeSubclientsToProcess
SET isDeleted = 1
WHERE NOT EXISTS (SELECT 1 FROM App_Application (NOLOCK) WHERE id = #edgeSubclientsToProcess.appId)
SELECT appId, isDeleted, analyticsEngineType
FROM #edgeSubclientsToProcess
IF OBJECT_ID('tempdb..#edgeSubclientsToProcess') IS NOT NULL
	DROP TABLE #edgeSubclientsToProcess
GO

IF EXISTS (select * from GxQscripts where name = 'DAGetEdgeSubclientsToAge')
	delete from GxQscripts where name = 'DAGetEdgeSubclientsToAge'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetEdgeSubclientsToAge')
	delete from GXDBVersions where aliasname = 'DAGetEdgeSubclientsToAge'
GO

insert into GXDBVersions values(2, 'DAGetEdgeSubclientsToAge',  '00010002000200010000', 'DAGetEdgeSubclientsToAge', '00010002000200010000')
GO

