

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DAGetDeconfiguredClientsWithNoData.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  DAGetDeconfiguredClientsWithNoData.sp                      */
/*                                                                            */
/*  Description :  Stored procedure that returns deconfigured clients		  */
/*				   with no valid data for pruning 							  */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DAGetDeconfiguredClientsWithNoData.sp,v $ $Id: DAGetDeconfiguredClientsWithNoData.sp,v 1.6.40.3 2018/03/20 19:55:55 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DAGetDeconfiguredClientsWithNoData <<<'

IF EXISTS (select * from sysobjects where name='DAGetDeconfiguredClientsWithNoData')
	drop procedure DAGetDeconfiguredClientsWithNoData
IF EXISTS (select * from GxQscripts where name='DAGetDeconfiguredClientsWithNoData')
	delete from GxQscripts where name = 'DAGetDeconfiguredClientsWithNoData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetDeconfiguredClientsWithNoData')
	delete from GXDBVersions where aliasname = 'DAGetDeconfiguredClientsWithNoData'
GO
print '... Creating Procedure: DAGetDeconfiguredClientsWithNoData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DAGetDeconfiguredClientsWithNoData
  @userId INTEGER
AS
  DECLARE @clientId INTEGER;
  DECLARE @clientName NVARCHAR(255);
  DECLARE @commCellId INTEGER;
  DECLARE @reason NVARCHAR(1024);
  DECLARE @reasonFlags INTEGER;
-- reasonBit = 1 		Client is not de-configured
-- reasonBit = 2		User does not have required capability to delete clients
-- reasonBit = 4		Active license found
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	if object_id('tempdb.dbo.#tmpClientList') is not null DROP TABLE #tmpClientList
	CREATE	TABLE #tmpClientList(
			clientId 		INTEGER,
			clientName 	NVARCHAR(255),
			commCellId 	INTEGER,
			reasonFlags INTEGER,
			reason			NVARCHAR(1024)
			PRIMARY KEY (clientId)
	)
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @flagBit  INTEGER
SET 		@flagBit 	= CAST(0x400 AS INT)
	--Get the list of clients with CLIENT_WITH_NO_ARCHIVE_DATA bit set
	INSERT INTO #tmpClientList
	SELECT C.id, C.name, 2, 0, N''
	FROM APP_Client C WITH (NOLOCK)
	WHERE C.specialClientFlags & @flagBit > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Mark clients that are not de-configured
	UPDATE #tmpClientList
	SET reasonFlags = reasonFlags | 1,
			reason = reason + N'Client is not de-configured\n'
	FROM #tmpClientList T, APP_Client C WITH (NOLOCK)
	WHERE T.clientId = C.id
AND		(C.status & 0x00002) = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Mark clients for which user does not have required permission to delete
	DECLARE @clientListWithPermission TABLE (clientId INTEGER PRIMARY KEY)
	INSERT INTO @clientListWithPermission
EXEC daGetEntityForUser @userId, 2009/*Client item*/, 2
	--If user does not have required permission on all clients
	IF NOT EXISTS (SELECT clientId FROM @clientListWithPermission WHERE clientId = 0)
	BEGIN
		UPDATE #tmpClientList
		SET reasonFlags = reasonFlags | 2,
		reason = reason + N'User does not have required capability to delete clients\n'
		WHERE clientId NOT IN (SELECT clientId
													 FROM @clientListWithPermission
													 WHERE clientId != 0
													)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	--Mark clients with active license found
	UPDATE #tmpClientList
	SET reasonFlags = reasonFlags | 4,
	reason = reason + N'Active license found for client\n'
	WHERE EXISTS (SELECT id
								FROM LicUsage WITH (NOLOCK)
								WHERE cid = clientId
								AND OpType = 'Install'
								AND InstallFlag = 0
								AND Lictype NOT IN (71, 10, 26, 16777216, 33554432, 50331648, 67108864)
								AND (Eval = 0 OR ExpiryDateUTC > GETUTCDATE())
							 )
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	CX_EXIT:
		IF @errorCode != 0
			SELECT -1, N'', -1, N'', -1
		ELSE
			SELECT clientId, clientName, commCellId, reason, reasonFlags
			FROM #tmpClientList
			ORDER BY clientId
		if object_id('tempdb.dbo.#tmpClientList') is not null DROP TABLE #tmpClientList
		RETURN @errorCode;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DAGetDeconfiguredClientsWithNoData')
	delete from GxQscripts where name = 'DAGetDeconfiguredClientsWithNoData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetDeconfiguredClientsWithNoData')
	delete from GXDBVersions where aliasname = 'DAGetDeconfiguredClientsWithNoData'
GO

insert into GXDBVersions values(2, 'DAGetDeconfiguredClientsWithNoData',  '00010006004000030000', 'DAGetDeconfiguredClientsWithNoData', '00010006004000030000')
GO

