

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DAGetClientsToDeconfigure.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  DAGetClientsToDeconfigure.sp			                      */
/*                                                                            */
/*  Description :  Stored procedure that returns clients that are to be       */
/*					deconfigured from data aging							  */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DAGetClientsToDeconfigure.sp,v $ $Id: DAGetClientsToDeconfigure.sp,v 1.1.2.2 2018/10/22 19:47:36 pankajkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DAGetClientsToDeconfigure')
BEGIN
	print '>>> Drop Stored Procedure: DAGetClientsToDeconfigure <<<'
	drop procedure DAGetClientsToDeconfigure
END
IF EXISTS (select * from GxQscripts where name='DAGetClientsToDeconfigure')
	delete from GxQscripts where name = 'DAGetClientsToDeconfigure'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetClientsToDeconfigure')
	delete from GXDBVersions where aliasname = 'DAGetClientsToDeconfigure'
GO
print '... Creating Procedure: DAGetClientsToDeconfigure'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DAGetClientsToDeconfigure
  @userId INTEGER
AS
  DECLARE @o_clientId INTEGER;
  DECLARE @o_clientName NVARCHAR(255);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	IF OBJECT_ID('tempdb..#tmpClientList') IS NOT NULL
		DROP TABLE #tmpClientList
	CREATE TABLE #tmpClientList(
			clientId 		INTEGER,
			clientName 	NVARCHAR(255)
			PRIMARY KEY (clientId)
	)
	INSERT INTO #tmpClientList
	SELECT DISTINCT C.id, C.name
	FROM APP_Application App WITH (NOLOCK) INNER JOIN App_Client C WITH(NOLOCK) ON App.clientId = C.id
	INNER JOIN App_InstanceProp IPROP WITH(NOLOCK) ON App.instance = IPROP.componentNameId
WHERE  ((C.status & 0x00002) = 0) AND IPROP.attrName = 'Distributed Cluster Type' AND IPROP.attrVal = 7 AND IPROP.modified = 0
	GROUP BY C.id, C.name
	HAVING (MAX(App.dataArchGrpId) = 1) AND (MAX(App.logArchGrpId) = 1)
	IF @@ROWCOUNT > 0
	BEGIN
		--Remove clients for which user does not have required permission to deconfigure
		DECLARE @clientListWithPermission TABLE (clientId INTEGER PRIMARY KEY)
		INSERT INTO @clientListWithPermission
EXEC daGetEntityForUser @userId, 2009/*Client item*/, 2
		--If user does not have required permission on all clients
		IF NOT EXISTS (SELECT clientId FROM @clientListWithPermission WHERE clientId = 0)
		BEGIN
			DELETE #tmpClientList
			WHERE clientId NOT IN (SELECT clientId FROM @clientListWithPermission WHERE clientId != 0)
		END
	END
	SELECT clientId, clientName FROM #tmpClientList
	IF OBJECT_ID('tempdb..#tmpClientList') IS NOT NULL
		DROP TABLE #tmpClientList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DAGetClientsToDeconfigure')
	delete from GxQscripts where name = 'DAGetClientsToDeconfigure'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAGetClientsToDeconfigure')
	delete from GXDBVersions where aliasname = 'DAGetClientsToDeconfigure'
GO

insert into GXDBVersions values(2, 'DAGetClientsToDeconfigure',  '00010001000200020000', 'DAGetClientsToDeconfigure', '00010001000200020000')
GO

