

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DACallDAPopulateTroubleshootingInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DACallDAPopulateTroubleshootingInfo.sp,v $ $Id: DACallDAPopulateTroubleshootingInfo.sp,v 1.1.2.1 2020/09/23 03:29:44 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DACallDAPopulateTroubleshootingInfo')
BEGIN
	print '>>> Drop Stored Procedure: DACallDAPopulateTroubleshootingInfo <<<'
	drop procedure DACallDAPopulateTroubleshootingInfo
END
IF EXISTS (select * from GxQscripts where name='DACallDAPopulateTroubleshootingInfo')
	delete from GxQscripts where name = 'DACallDAPopulateTroubleshootingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DACallDAPopulateTroubleshootingInfo')
	delete from GXDBVersions where aliasname = 'DACallDAPopulateTroubleshootingInfo'
GO
print '... Creating Procedure: DACallDAPopulateTroubleshootingInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DACallDAPopulateTroubleshootingInfo
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
SET NOCOUNT ON
BEGIN TRY
	DECLARE	@spName VARCHAR(1024)
	DECLARE	@spArgs VARCHAR(MAX)
	DECLARE	@procId INTEGER
	DECLARE	@lastAttemptTime BIGINT
	DECLARE	@lastRunOutput VARCHAR(MAX)
	IF EXISTS(SELECT 1 FROM MMConfigs WITH(NOLOCK) WHERE name = 'DA_CONFIG_DISABLE_DATROUBLESHOOTING_DATA_COLLECTION' AND value = 1)
		RETURN
	SET @spName = OBJECT_NAME (@@PROCID)
	SET @spArgs = CONVERT(VARCHAR, @i_reserveParam)
	SET @procId = ISNULL (CHECKSUM(@spName, @spArgs), 0)
	SELECT @lastAttemptTime = ISNULL(lastAttemptTime, -1),
			@lastRunOutput = ISNULL(lastRunOut, '')
	FROM MMProcsToRun WITH (READUNCOMMITTED) WHERE ProcId = @procId
	IF(@lastAttemptTime = -1)
		RETURN
	--
	-- Is it already time for me to run?
	--
	DECLARE	@currentTime INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @lastDataAgingJobTime INT = 0
	SELECT @lastDataAgingJobTime = MAX(servEnd) FROM JMAdminJobStatsTable WITH(READUNCOMMITTED) WHERE opType = 10 /* enum CVOpType  PRUNE = 10 */
DECLARE @intervalMinsToRecompute INT = 1440
	SELECT @intervalMinsToRecompute = value FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'DA_CONFIG_INTERVAL_MINUTES_RECOMPUTE_DA_TROUBLESHOOTING_INFO'
	DECLARE @inputFlags INT = 0
	IF (@lastDataAgingJobTime > @lastAttemptTime)
		SET @inputFlags = 0
	/*
	In case data aging doesn't run, still recompute but do not re-process job retention based errors as they wouldn't have been recomputed.
	Errors that do not depend on data aging job can still be set.
	*/
	ELSE IF((@currentTime - @lastAttemptTime)/60) > @intervalMinsToRecompute
SET @inputFlags = 1
	ELSE
		RETURN
	-- Update the attempt time before starting the main logic in the proc.. if any failure, it wont be tried again till interval has passed
	UPDATE MMProcsToRun
	SET lastAttemptTime = @currentTime
	WHERE ProcId = @procId
	IF(OBJECT_ID('tempdb..#tblResultDAPopulateTroubleshootingInfo') IS NOT NULL)
		DROP TABLE #tblResultDAPopulateTroubleshootingInfo
	CREATE TABLE #tblResultDAPopulateTroubleshootingInfo(errorCode INT)
	EXEC DAPopulateTroubleshootingInfo @inputFlags
	IF(OBJECT_ID('tempdb..#tblResultDAPopulateTroubleshootingInfo') IS NOT NULL)
		DROP TABLE #tblResultDAPopulateTroubleshootingInfo
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    ;THROW
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'DACallDAPopulateTroubleshootingInfo')
	delete from GxQscripts where name = 'DACallDAPopulateTroubleshootingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DACallDAPopulateTroubleshootingInfo')
	delete from GXDBVersions where aliasname = 'DACallDAPopulateTroubleshootingInfo'
GO

insert into GXDBVersions values(2, 'DACallDAPopulateTroubleshootingInfo',  '00010001000200010000', 'DACallDAPopulateTroubleshootingInfo', '00010001000200010000')
GO

