

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DAAgeArchFilesBySpaceReclamation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DAAgeArchFilesBySpaceReclamation.sp,v $ $Id: DAAgeArchFilesBySpaceReclamation.sp,v 1.1.2.3 2019/12/27 12:20:32 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DAAgeArchFilesBySpaceReclamation')
BEGIN
	print '>>> Drop Stored Procedure: DAAgeArchFilesBySpaceReclamation <<<'
	drop procedure DAAgeArchFilesBySpaceReclamation
END
IF EXISTS (select * from GxQscripts where name='DAAgeArchFilesBySpaceReclamation')
	delete from GxQscripts where name = 'DAAgeArchFilesBySpaceReclamation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAAgeArchFilesBySpaceReclamation')
	delete from GXDBVersions where aliasname = 'DAAgeArchFilesBySpaceReclamation'
GO
print '... Creating Procedure: DAAgeArchFilesBySpaceReclamation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DAAgeArchFilesBySpaceReclamation
  @i_flags bigint,
  @i_DbgLevel bigint
AS
  DECLARE @o_archiveFilesDeleted XML;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRY
	IF NOT EXISTS(SELECT 1 FROM ArchFileSpaceReclamation WITH(NOLOCK)) --Nothing to age
		GOTO PROC_EXIT
	IF OBJECT_ID('tempdb..#ToBeAgedAF') IS NOT NULL
		DROP TABLE #ToBeAgedAF
	CREATE TABLE #ToBeAgedAF (
	    archFileId INT, commCellId INT, archCopyId INT,
	    PRIMARY KEY (archFileId, commCellId, archCopyId) WITH(IGNORE_DUP_KEY = ON))
	IF OBJECT_ID('tempdb..#TempJobsToProcess') IS NOT NULL
		DROP TABLE #TempJobsToProcess
	CREATE TABLE #TempJobsToProcess (
		jobId INT, commcellId INT, archCopyId INT, retentionDays INT, jobStatusComplete INT, PRIMARY KEY (jobId, commcellId, archCopyId))
	DECLARE @l_graceDays INT
	SELECT @l_graceDays = CAST(value AS INT) FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'DelayAgingAfterSpaceReclamationDays'
	IF (@l_graceDays IS NULL)
		SELECT @l_graceDays = value FROM MMConfigs WITH(NOLOCK) WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_EDGE_ARCHIVEFILES_AFTER_SYNTHFULL'
	IF (@l_graceDays IS NULL)
SELECT @l_graceDays = 90
	IF(@l_graceDays < 0)
		SET @l_graceDays = 0
	DECLARE @l_ageArchiveFilesBefore BIGINT = dbo.GetUnixTime(GETUTCDATE()) - (@l_graceDays * 24 * 60 * 60)
	DECLARE @archiveFileXML XML
	/*Pick older archive files and age them from all copies*/
	INSERT INTO #ToBeAgedAF
	SELECT DISTINCT AFR.archFileId, AFR.ArchFileCCId, 0
	FROM ArchFileSpaceReclamation AFR WITH(NOLOCK) LEFT OUTER JOIN JMJobInfo JI WITH(NOLOCK) ON AFR.SpaceReclamationJobId = JI.jobId AND AFR.SpaceReclamationJobCCId = JI.commcellId
	WHERE AFR.CreationTime < @l_ageArchiveFilesBefore AND JI.jobId IS NULL
	DECLARE @l_maxInt INT = 2147483647
	/*Pick recent archive files and retain them only on highest retention copy and age them from all other copies*/
	INSERT INTO #TempJobsToProcess
	SELECT DISTINCT JDS.jobId, JDS.commcellId, JDS.archGrpCopyId, CASE WHEN AAR.retentionDays = -1 THEN @l_maxInt ELSE AAR.retentionDays END, CASE WHEN MAX(JDS.status) = 100 AND MIN(JDS.status) = 100 THEN 1 ELSE 0 END
	FROM ArchFileSpaceReclamation AFR WITH(NOLOCK) LEFT OUTER JOIN JMJobInfo JI WITH(NOLOCK) ON AFR.SpaceReclamationJobId = JI.jobId AND AFR.SpaceReclamationJobCCId = JI.commcellId
	INNER JOIN ArchFile AF WITH(NOLOCK) ON AFR.archFileId = AF.id AND AFR.archFileCCId = AF.commcellId
	INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON AF.jobId = JDS.jobId AND AF.commcellId = JDS.commcellId
	INNER JOIN ArchAgingRule AAR WITH(NOLOCK) ON JDS.archGrpCopyId = AAR.copyId
	WHERE AFR.CreationTime >= @l_ageArchiveFilesBefore AND JI.jobId IS NULL
	GROUP BY JDS.jobId, JDS.commcellId, JDS.archGrpCopyId, AAR.retentionDays
HAVING MAX(JDS.disabled & 256) = 0
	--Do not process jobs that are still to-be-copied
	DELETE T
	FROM #TempJobsToProcess T INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON T.jobId = JDS.jobID AND T.commcellId = JDS.commcellId AND JDS.status IN (101, 102, 103) AND (JDS.disabled & 1 = 0)
	--We are left with jobs that are alreay auxcopied, now retain only the highest retention copy
	DELETE T
	FROM #TempJobsToProcess T INNER JOIN
	(
		SELECT jobId, commcellId, archCopyId FROM
		(
		SELECT jobId, commcellId, archCopyId, row_number() OVER(partition by jobId, commcellId order by jobStatusComplete desc, retentionDays desc, archCopyId desc) as rn
		FROM #TempJobsToProcess
		) T1
		WHERE rn = 1
	) T2
	ON
	T.jobId = T2.jobId AND T.commcellId = T2.commcellId AND T.archCopyId = T2.archCopyId
	INSERT INTO #ToBeAgedAF
	SELECT DISTINCT AFR.archFileId, AFR.ArchFileCCId, T.archCopyId
	FROM ArchFileSpaceReclamation AFR WITH(NOLOCK) INNER JOIN ArchFile AF WITH(NOLOCK) ON AFR.ArchFileId = AF.id AND AFR.archFileCCId = AF.commcellId
	INNER JOIN #TempJobsToProcess T ON AF.jobId = T.jobId AND AF.commcellId = T.commcellId
	WHERE AFR.CreationTime >= @l_ageArchiveFilesBefore
	SET @archiveFileXML =
	(
	SELECT DISTINCT archFileId AS archFileId, commCellId AS commCelld, archCopyId AS copyId
	FROM #ToBeAgedAF archFileInfo
	FOR  XML AUTO, ROOT('GalaxyOperations_PruneArchiveFiles')
	)
	IF(@archiveFileXML IS NOT NULL)
	BEGIN
		DECLARE @retVal int
		DECLARE @retStr varchar(1024)
		IF OBJECT_ID('tempdb..#tblResultarchDeleteArchiveFiles') IS NOT NULL  DROP TABLE #tblResultarchDeleteArchiveFiles
	        CREATE TABLE #tblResultarchDeleteArchiveFiles(retCode int, retStr varchar(1024))
EXEC @retVal = archDeleteArchiveFiles @archiveFileXML, 137438953472, 1
	    IF  (@retVal != 0)
	    BEGIN
	        SET @retStr = 'Failed to prune archive files. ' + ISNULL((SELECT top 1 retStr FROM #tblResultarchDeleteArchiveFiles), '')
	        RAISERROR(@retStr, 16, 1)
	    END
	    /*Clean up entries that do not have any more archive file reference*/
	    DELETE AFR FROM
	    ArchFileSpaceReclamation AFR LEFT OUTER JOIN ArchFile AF WITH(NOLOCK) ON AFR.ArchFileId = AF.id AND AFR.ArchFileCCId = AF.commcellId
	    WHERE AF.id IS NULL
IF(@i_DbgLevel >=  3)
	    	SET @o_archiveFilesDeleted = @archiveFileXML
	    ELSE
	    	SET @o_archiveFilesDeleted = ''
	END
PROC_EXIT:
	IF OBJECT_ID('tempdb..#ToBeAgedAF') IS NOT NULL
		DROP TABLE #ToBeAgedAF
    IF OBJECT_ID('tempdb..#TempJobsToProcess') IS NOT NULL
		DROP TABLE #TempJobsToProcess
	IF OBJECT_ID('tempdb..#tmpResultDAAgeArchFilesBySpaceReclamation') IS NOT NULL
	BEGIN
		INSERT #tmpResultDAAgeArchFilesBySpaceReclamation
		SELECT ISNULL(@o_archiveFilesDeleted, '')
	END
	ELSE
		SELECT ISNULL(@o_archiveFilesDeleted, '')
END TRY
BEGIN CATCH
	SELECT ''
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
	THROW
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DAAgeArchFilesBySpaceReclamation')
	delete from GxQscripts where name = 'DAAgeArchFilesBySpaceReclamation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DAAgeArchFilesBySpaceReclamation')
	delete from GXDBVersions where aliasname = 'DAAgeArchFilesBySpaceReclamation'
GO

insert into GXDBVersions values(2, 'DAAgeArchFilesBySpaceReclamation',  '00010001000200030000', 'DAAgeArchFilesBySpaceReclamation', '00010001000200030000')
GO

