

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CreateUpdateEmailTemplate.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Divya Trivedi
-- Create date: 1/8/2018
-- Description:	To add/edit email templates
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CreateUpdateEmailTemplate')
BEGIN
	print '>>> Drop Stored Procedure: CreateUpdateEmailTemplate <<<'
	drop procedure CreateUpdateEmailTemplate
END
IF EXISTS (select * from GxQscripts where name='CreateUpdateEmailTemplate')
	delete from GxQscripts where name = 'CreateUpdateEmailTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CreateUpdateEmailTemplate')
	delete from GXDBVersions where aliasname = 'CreateUpdateEmailTemplate'
GO
print '... Creating Procedure: CreateUpdateEmailTemplate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CreateUpdateEmailTemplate
  @i_userId INT,
  @i_localeId INT,
  @i_emailTemplateInfoXml XML,
  @o_xmlText XML OUTPUT
AS
SET XACT_ABORT ON
-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @debug  AS INT = 0
DECLARE @errorCode          INT = 0
DECLARE @errorString        NVARCHAR(MAX) = ''
DECLARE @emailTemplateId INT
DECLARE @name nvarchar(255)
DECLARE @description nvarchar(max)
DECLARE @emailTemplateTypeId INT
DECLARE @localeId INT
DECLARE @emailTemplateLocaleId INT
DECLARE @isDefault tinyint
DECLARE @subject nvarchar(255)
DECLARE @emailBody nvarchar(max)
DECLARE @cc nvarchar(255)
DECLARE @bcc nvarchar(255)
DECLARE @fromName nvarchar(255)
DECLARE @fromEmail nvarchar(255)
declare @unixTime int
DECLARE @canManageProvider INT
DECLARE @ownerCompany INT = 0
DECLARE @status INT = 0 -- first bit used for system created templates should be false
--Read the input XML - START
SELECT
		@emailTemplateId = ISNULL((ref.value('@emailTemplateId', 'INT')), 0),
		@name = ISNULL((ref.value('@name', 'nvarchar(255)')), ''),
		@description = ISNULL((ref.value('@description', 'nvarchar(max)')), ''),
		@emailTemplateTypeId = ISNULL((ref.value('@emailTemplateTypeId', 'INT')), 0),
		@isDefault = ISNULL((ref.value('@isDefault', 'tinyint')), 0),
		@subject = ISNULL((ref.value('@subject', 'nvarchar(255)')), ''),
		@emailBody = ISNULL((ref.value('@emailBody', 'nvarchar(max)')), ''),
		@cc = ISNULL((ref.value('@cc', 'nvarchar(255)')), ''),
		@bcc = ISNULL((ref.value('@bcc', 'nvarchar(255)')), '')
FROM @i_emailTemplateInfoXml.nodes('/Api_EmailTemplateInfo') R(ref)
SELECT
		@emailTemplateLocaleId = ISNULL((ref.value('@localeId', 'INT')), 0)
FROM @i_emailTemplateInfoXml.nodes('/Api_EmailTemplateInfo/locale') R(ref)
SELECT
		@fromName = ISNULL((ref.value('@fullName', 'nvarchar(255)')), ''),
		@fromEmail = ISNULL((ref.value('@email', 'nvarchar(255)')), '')
FROM @i_emailTemplateInfoXml.nodes('/Api_EmailTemplateInfo/from') R(ref)
--Read the input XML - END
set @unixTime= dbo.GetUnixTime(GetUTCDate())
--if email type is null or 0 give error. it can be null if input xml doesnt have Api_EmailTemplateInfo as root node
if(@emailTemplateTypeId is null or @emailTemplateTypeId = 0)
BEGIN
SET @errorCode =  (3700 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
END
BEGIN TRY
		if(@emailTemplateId = 0)
		--CREATE - START
		begin
			--Get company for logged in user. It will be 0 for msp admin.
			--On Create, ownerCompanyId is determined based on logged in user's company
			--SET @ownerCompany = dbo.AppgetOrganizationforuser(@i_userId)
			SELECT @ownerCompany = ISNULL((ref.value('@providerId', 'INT')), 0)
			FROM @i_emailTemplateInfoXml.nodes('/Api_EmailTemplateInfo/ownerCompany') R(ref)
EXEC sec_checkPermissionOnEntity  @i_userId, 1, @canManageProvider OUTPUT, 61, @ownerCompany
			if(@canManageProvider = 1)
			BEGIN
				IF EXISTS(SELECT 1 FROM App_EmailTemplate WITH (NOLOCK) WHERE ownerCompanyId=@ownerCompany AND name = @name )
				BEGIN
SET @errorCode = (3699 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3699 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @i_localeId)
					 GOTO PROC_EXIT
				END
				BEGIN TRAN
				if(@isDefault = 1)
					update App_emailtemplate set isDefault = 0 where type = @emailTemplateTypeId and ownerCompanyId = @ownerCompany
				insert into App_EmailTemplate(name, description, createdBy, modifiedBy, createdOn, modifiedOn, type, ownerCompanyId, localeId, isDefault, fromName, fromEmail, subject, emailBody, cc, bcc, status)
				values (@name, @description, @i_userId, @i_userId, @unixTime, @unixTime, @emailTemplateTypeId, @ownerCompany, @emailTemplateLocaleId, @isDefault,  @fromName, @fromEmail, @subject, @emailBody, @cc, @bcc, @status)
				SET  @emailTemplateId = SCOPE_IDENTITY()
				--  Populate App_EmailTemplateProp table here, once we have properties
				COMMIT TRAN
				SET @errorCode =  0
				GOTO PROC_EXIT
			END
			ELSE
			BEGIN
				-- User don't have rights to create email template
SET @errorCode =  (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO PROC_EXIT
			END
		end
		--CREATE - END
		--UPDATE - START
		if(@emailTemplateId is not null and @emailTemplateId != 0)
		begin
			SET @ownerCompany = (select ownerCompanyId from App_EmailTemplate where id = @emailTemplateId) -- get company for the email template
			if(@ownerCompany is not null) -- record found. ownerCompanyId is not null column
			BEGIN
EXEC sec_checkPermissionOnEntity  @i_userId, 1, @canManageProvider OUTPUT, 61, @ownerCompany
				if(@canManageProvider = 1)
				BEGIN
					BEGIN TRAN
					if(@isDefault = 1)
						update App_emailtemplate set isDefault = 0 where type = @emailTemplateTypeId and ownerCompanyId = @ownerCompany
					update App_EmailTemplate
					set name = @name,
					description = @description,
					modifiedBy = @i_userId,
					modifiedOn = @unixTime,
					type = @emailTemplateTypeId,
					localeId = @emailTemplateLocaleId,
					isDefault = @isDefault,
					fromName = @fromName,
					fromEmail = @fromEmail,
					subject = @subject,
					emailBody = @emailBody,
					cc = @cc,
					bcc = @bcc
					where id = @emailTemplateId -- ownerCompanyId cannot be edited on update
					--no flag in status needs to be updated currently
					--  update App_EmailTemplateProp table here, once we have properties
					COMMIT TRAN
					SET @errorCode =  0
					GOTO PROC_EXIT
				END
				ELSE
				BEGIN
					-- User don't have rights to update email template
SET @errorCode =  (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO PROC_EXIT
				END
			END
			ELSE
			BEGIN
SET @errorCode = (3702 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					GOTO PROC_EXIT
			END
		end
		--UPDATE - END
END TRY
BEGIN CATCH
	IF XACT_STATE() <> 0
		ROLLBACK TRAN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR) --dbUpgrade scripts replace this const with a print statement to log errors. required for all catch blocks.
SELECT @errorCode = (3701 | (CAST(POWER(2, 24) AS BIGINT) * 35)), @errorString = ERROR_MESSAGE()
	GOTO PROC_EXIT
END CATCH
PROC_EXIT:
	 SET @o_xmlText = (SELECT
							 (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
								 FOR XML PATH('error'), TYPE),
							 (SELECT @emailTemplateId AS '@emailTemplateId'
								 FOR XML PATH('emailTemplateEntity'),TYPE)
						 FOR XML PATH('Api_EmailTemplateInfoResponse'), TYPE)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CreateUpdateEmailTemplate')
	delete from GxQscripts where name = 'CreateUpdateEmailTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CreateUpdateEmailTemplate')
	delete from GXDBVersions where aliasname = 'CreateUpdateEmailTemplate'
GO

insert into GXDBVersions values(2, 'CreateUpdateEmailTemplate',  '00000000000000000000', 'CreateUpdateEmailTemplate', '00000000000000000000')
GO

