

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CreateTempDbGrowthEvent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CreateTempDbGrowthEvent.sp,v $ $Id: CreateTempDbGrowthEvent.sp,v 1.1.2.4 2018/06/20 19:47:08 rsivadas Exp $";
--
--  +========================================================================+
--  | Stored Precedure: CreateTempDbGrowthEvent
--  |
--  | Description:
--  |  Creates event for TempDbGrowth
--  |
--  |   Revisions  Author				Description
--  |   ---------  --------------		---------------------------------------------
--  |   1.0        rsivadas				Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CreateTempDbGrowthEvent <<<'

IF EXISTS (select * from sysobjects where name='CreateTempDbGrowthEvent')
	drop procedure CreateTempDbGrowthEvent
IF EXISTS (select * from GxQscripts where name='CreateTempDbGrowthEvent')
	delete from GxQscripts where name = 'CreateTempDbGrowthEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CreateTempDbGrowthEvent')
	delete from GXDBVersions where aliasname = 'CreateTempDbGrowthEvent'
GO
print '... Creating Procedure: CreateTempDbGrowthEvent'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CreateTempDbGrowthEvent
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--Fix to only create alert for temp size over 1 GB
--Setups starting of with small TempDB sizes are causing lot of false positive events to get created
DECLARE @SizeGB int = (select ((size*8)/power(1024,2)) from Tempdb.sys.database_files where Name = 'templog')
IF @SizeGB  > 1
BEGIN
	DECLARE @MessageId INTEGER = 989855810;
	DECLARE @evMsgId INTEGER
		,@Client VARCHAR(MAX);
	DECLARE @CurrentTime INTEGER = dbo.getUnixTime(getUTCDate())
	DECLARE @NextEvIDTable TABLE (id INT)
	INSERT INTO @NextEvIDTable
	EXECUTE GetNextEventId
	SELECT @evMsgId = id
	FROM @NextEvIDTable
	SELECT @Client = NAME
	FROM APP_Client(NOLOCK)
	WHERE id = 2
	INSERT INTO EvMsg (
		id
		,TimeSource
		,TimeServer
		,Severity
		,Ack
		,Acked
		,Type
		,ParamNum
		,MessageId
		,JobId_h
		,JobId_l
		,ClientId
		,CommcellId
		,UserId
		,SubSystemId
		,Client
		,CommCell
		,UserName
		,SubSystem
		,MsgEnglish
		,RepeatCount
		,LastOccurrence
		,NextPost
		,mediaId
		,driveId
		,libraryId
		,maClientId
		)
	SELECT @evMsgId		--id
		,@CurrentTime	--TimeSource
		,@CurrentTime	--TimeServer
		,6				--Severity
		,0				--Ack
		,0				--Acked
		,0				--Type
		,0				--ParamNum
		,@MessageId		--MessageId
		,0				--JobId_h
		,0				--JobId_l
		,2				--ClientId
		,2				--CommcellId
		,0				--UserId
		,0				--SubSystemId
		,@Client		--Client
		,''				--CommCell
		,''				--UserName
		,'Sql Agent'	--SubSystem
		,''				--MsgEnglish
		,1				--RepeatCount
		,@CurrentTime	--LastOccurrence
		,1				--NextPost
		,0				--driveId
		,0				--driveId
		,0 				--libraryId
		,2				--maClientId
END
GO

IF EXISTS (select * from GxQscripts where name = 'CreateTempDbGrowthEvent')
	delete from GxQscripts where name = 'CreateTempDbGrowthEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CreateTempDbGrowthEvent')
	delete from GXDBVersions where aliasname = 'CreateTempDbGrowthEvent'
GO

insert into GXDBVersions values(2, 'CreateTempDbGrowthEvent',  '00010001000200040000', 'CreateTempDbGrowthEvent', '00010001000200040000')
GO

