

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CreateTPPMForISToCA.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  CreateTPPMForISToCA
--  | Description:   Add the firewall configuration for index server node clients and content analyzer client in firewall configuration table.
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CreateTPPMForISToCA.sp,v $ $Id: CreateTPPMForISToCA.sp,v 1.1.2.4 2020/07/01 15:51:44 jjindal Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CreateTPPMForISToCA')
BEGIN
	print '>>> Drop Stored Procedure: CreateTPPMForISToCA <<<'
	drop procedure CreateTPPMForISToCA
END
IF EXISTS (select * from GxQscripts where name='CreateTPPMForISToCA')
	delete from GxQscripts where name = 'CreateTPPMForISToCA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CreateTPPMForISToCA')
	delete from GXDBVersions where aliasname = 'CreateTPPMForISToCA'
GO
print '... Creating Procedure: CreateTPPMForISToCA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CreateTPPMForISToCA
  @i_dcPlanID INTEGER = 0,
  @i_datasourceId INTEGER = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @SourceISClient TABLE (clientID INT PRIMARY KEY)
DECLARE @SEPARATOR CHAR = ','
DECLARE @fromClientID INT
DECLARE @dcPlanID INT = 0
DECLARE @caCloudId INT = 0
DECLARE @caClientId INT = 0
DECLARE @caInstanceName NVARCHAR(256) =N''
DECLARE @caPortNo NVARCHAR(256) =N''
DECLARE @IndexServerClientIDs NVARCHAR(MAX) = 0
IF @i_datasourceId <> 0 OR @i_dcPlanID <>0
BEGIN
	--Get Plan ID from the data source property if it is not passed.
	if @i_dcPlanID = 0
	BEGIN
		SELECT @dcPlanID =  DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
		WHERE DSP.DataSourceId = @i_datasourceId
		AND DSP.PropertyId =(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'dcplanid')
	END
	ELSE
	BEGIN
		SET @dcPlanID = @i_dcPlanID
	END
	--Get Content Analyzer cloud ID and Index Server Cloud ID
	IF @dcPlanID <> 0
	BEGIN
SELECT @caCloudId = dbo.AppPlanGetEntityValueV2(@dcPlanID,'Content Analyzer Cloud Id',default) -- 'Content Analyzer Cloud Id' - 'Content Analyzer Cloud Id'
		--Get client ID where Index Server is installed
		INSERT INTO @SourceISClient
		SELECT DSC.ClientId
		FROM DM2SearchServerCoreInfo DSC (NOLOCK)
		JOIN DM2Cloud DC (NOLOCK)
		ON DSC.cloudId = DC.cloudId
where DC.CloudType IN (1, 5) AND pseudoClientId =dbo.AppPlanGetEntityValueV2(@dcPlanID,'Analytics Index Server Id',default) -- 'Analytics Index Server Id' - 'Analytics Index Server Id'
	END
	ELSE IF @i_datasourceId <> 0
	BEGIN
		SELECT @caCloudId =  DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
		WHERE DSP.DataSourceId = @i_datasourceId
		AND DSP.PropertyId =(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'cacloudid')
		--Get client ID where Index Server is installed
		INSERT INTO @SourceISClient
		SELECT DSC.ClientId
		FROM DM2SearchServerCoreInfo DSC (NOLOCK)
		JOIN  SECollectionInfo SC (NOLOCK)
		ON DSC.CloudId = SC.cloudID
		JOIN SEDataSource SD (NOLOCK)
		ON SC.CoreId = SD.CoreId
		where SD.DataSourceId = @i_datasourceId
	END
	--Get client ID where content analyzer is installed and get the port number for the content extractor service.
	IF @caCloudId <> 0
	BEGIN
SELECT @caClientId = ClientId FROM DM2SearchServerCoreInfo (NOLOCK) where CloudId = @caCloudId and cloudType = 2
		SELECT @caInstanceName = attrVal FROM APP_ClientProp (NOLOCK) WHERE componentNameId = @caClientId AND attrName = 'Galaxy Instance name' and modified = 0
		SELECT @caPortNo = ISNULL(attrVal,
		(CASE WHEN @caInstanceName = 'Instance001' THEN '22000'
		ELSE ('2200'+ SUBSTRING (@caInstanceName, LEN(@caInstanceName), LEN(@caInstanceName))) END))
		FROM APP_ClientProp (NOLOCK) WHERE componentNameId = @caClientId AND attrName = 'contentPreviewPort' and modified = 0
	END
	IF @caClientID<>0 AND @caPortNo<>0
	BEGIN
		WHILE EXISTS(SELECT TOP 1 clientID FROM @SourceISClient)
		BEGIN
			SELECT @fromClientID = (SELECT TOP 1 clientID FROM @SourceISClient)
			IF @fromClientID <> @caClientId
			BEGIN
EXEC AppSetFirewallTPPM @i_tppmType = 9,@i_fromEntityType = 3 /* CLIENT_ENTITY */, @i_fromEntityId=@fromClientID,@i_fromPortNumber=0,
@i_toEntityType=3 /* CLIENT_ENTITY */,@i_toEntityId=@caClientId,@i_toPortNumber=@caPortNo,@i_tppmParams=''
			END
			DELETE TOP (1) FROM @SourceISClient WHERE clientID = @fromClientID
		END
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CreateTPPMForISToCA')
	delete from GxQscripts where name = 'CreateTPPMForISToCA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CreateTPPMForISToCA')
	delete from GXDBVersions where aliasname = 'CreateTPPMForISToCA'
GO

insert into GXDBVersions values(2, 'CreateTPPMForISToCA',  '00010001000200040000', 'CreateTPPMForISToCA', '00010001000200040000')
GO

