

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CreateStoragePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='createStoragePolicy')
BEGIN
	print '>>> Drop Stored Procedure: createStoragePolicy <<<'
	drop procedure createStoragePolicy
END
IF EXISTS (select * from GxQscripts where name='createStoragePolicy')
	delete from GxQscripts where name = 'createStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='createStoragePolicy')
	delete from GXDBVersions where aliasname = 'createStoragePolicy'
GO
print '... Creating Procedure: createStoragePolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure createStoragePolicy
  @i_sp_options varchar(MAX)
AS
  DECLARE @o_agrcpyID integer;
  DECLARE @o_agrID integer;
  DECLARE @o_error integer;
  DECLARE @o_xmltxt XML;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/*Local Variables*/
 DECLARE @EVCODE BIGINT
 DECLARE @spname varchar(100)
 DECLARE @legalhold INT
 DECLARE @incrsp INT
 DECLARE @maxstreams INT
 DECLARE @siblocksizekb INT
 DECLARE @copyname varchar(100)
 DECLARE @basicdays INT
 DECLARE @basiccycles INT
 DECLARE @archiverdays INT
 DECLARE @library varchar(100)
 DECLARE @drivepool varchar(100)
 DECLARE @sparegroup varchar(100)
 DECLARE @IsHardwareCompressed INT
 DECLARE @dedupEnable INT
 DECLARE @mediaagent varchar(100)
 DECLARE @pathname varchar(100)
 DECLARE @siloappid INT
 DECLARE @silosincache INT
 DECLARE @EVMSG VARCHAR(1000)
 DECLARE @sp_options XML
 set @sp_options = cast(@i_sp_options AS XML)
BEGIN
	select  @spname = Node.value('@SPName','varchar(100)'),
			@legalhold = Node.value('@LegalHold','INT'),
			@incrsp = Node.value('@IncrSP','INT'),
			@maxstreams= Node.value('@MaxStreams','INT'),
			@siblocksizekb = Node.value('@SIBlockSizeKB','INT')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/SPDetails') tmpxml (Node);
	select	@copyname = Node.value('@CopyName','varchar(100)')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/CopyDetails/copy') Tmpxml2(Node);
	select	@basicdays = Node.value ('@BasicDays','INT'),
		@archiverdays = Node.value ('@ArchiverDays','INT')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/CopyDetails/Retention')Tmpxml3(Node);
	select	@library = Node.value('@Library','varchar(100)'),
			@drivepool = Node.value('@DrivePool','varchar(100)'),
			@sparegroup = Node.value('@SpareGroup','varchar(100)'),
			@IsHardwareCompressed = Node.value('@CompressHardware','INT')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/CopyDetails/DPInfo/defaultDP') tmpxml4(Node);
	select	@dedupEnable = Node.value('@DedupEnable','INT'),
			@mediaagent = Node.value('@MediaAgent','varchar(100)'),
			@pathname = Node.value('@Path','varchar(100)'),
			@siloappid = Node.value('@SiloAppID','INT'),
			@silosincache = Node.value('@SilosInCache','INT')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/CopyDetails/dedup') Tmpxml5(Node);
	SET @basiccycles = 1
 END
 DECLARE @defaultCopy INT
 DECLARE @defaultSnapCopy INT
 DECLARE @archGroupID INT
 DECLARE @todayDate INT
 DECLARE @SIDBStoreID INT
 DECLARE @ArchGroupCopyID INT
 DECLARE @LibraryID INT
 DECLARE @MasterPoolID INT
 DECLARE @DrivePoolID INT
 DECLARE @MediaTypeID INT
 DECLARE @comCellID INT
 DECLARE @RecordingFormatID INT
 DECLARE @ClientID INT
 DECLARE @todayDateTime DATETIME
 DECLARE @archFlags INT
 DECLARE @maxstreamNUM INT
 DECLARE @AgingRuleflags INT
 DECLARE @weekStart INT
 DECLARE @monthStart INT
 DECLARE @yearStart INT
 DECLARE @mediaPasswd VARCHAR(100)
 DECLARE @SpareGroupId INT
 DECLARE @LibType INT
 DECLARE @DEDUPXML XML
 DECLARE @minutesSinceDayStarts  INT
	SET @defaultCopy = 0
	SET @defaultSnapCopy = 0
	SET @archFlags = 0
SET @archFlags |= 16384
	SET @maxstreamNUM = 0
	SET @AgingRuleflags = 2 --#define	AM_AGING_FLAGS_EXT_DIRTY	2	flag Defined in AMAgingRule.h
	SET @weekStart = 5
	SET @monthStart  = 1
	SET @yearStart  = 0
	SET @minutesSinceDayStarts=0
	SET @SIDBStoreID = 0
	SET @o_xmltxt = ''
	SET @o_error = 0
 select @mediaPasswd = value from GxGlobalParam where name='MediaPassword';
 IF @mediaPasswd = '1' OR @mediaPasswd = '2'
 BEGIN
	SET @mediaPasswd = ''
 END
 BEGIN TRANSACTION
 DECLARE @RETVAL_ARCH_TMP TABLE(ERRORNUM INTEGER)
 IF ISNULL((select count(*) from archGroup where name = @spname), 0) <> 0
 BEGIN
	SET @o_error = 1
SET @EVCODE = (99 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @EVMSG = 'EV_E_SP_NAME_EXISTIG'
SET @o_xmltxt = dbo.getXMLError((104 | (CAST(POWER(2, 24) AS BIGINT) * 80)),@EVCODE,@spname,NULL,NULL)
	GOTO ERROR_EXIT
 END
 INSERT archGroup(defaultCopy,name,description,maxStreams,type,incrSP,origCCcommCellID,
		 origCCarchGroupId,defaultSnapCopy,SIBlockSizeKB,AuxCopyAlertGB,
		 AuxCopyAlertDays,flags,mediaPassword,TimeZoneType,TimeZone)
	VALUES	(@defaultCopy,@spname,'',@maxstreams,1,@incrsp,0,0,0,@siblocksizekb,
		-1,-1,36,@mediaPasswd,0,'');
 select @archGroupID = id from archGroup where name = @spname;
 /*GetDate and convert into unixTime*/
 select  @todayDate = dbo.GetUnixTime(GETDATE());
 IF ISNULL((select count(*) from archGroupCopy where name = @copyname), 0) <> 0
 BEGIN
	SET @o_error = 1
SET @EVCODE = (100 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @EVMSG = 'EV_E_SP_COPY_NAME_EXISTIG'
SET @o_xmltxt = dbo.getXMLError((104 | (CAST(POWER(2, 24) AS BIGINT) * 80)),@EVCODE,@copyname,NULL,NULL)
	GOTO ERROR_EXIT
 END
 INSERT archGroupCopy
		(archGroupId, copy, name, flags,
		maxMultiplex, isActive, type, startTime, waitForIfOffline,
		waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId,
		delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId,
		encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
		SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags,
		blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
		sealStoreTaskId, archCheckValidPeriodType, endTime)
 VALUES (@archGroupID, 1, @copyname, @archFlags,
		0, 1, 1, -@todayDate, 1,
		0, -@todayDate, 0, 0, 0,
		0, @maxstreamNUM, 0, 1, @SIDBStoreID,
		0, 0, 0, 0, 0,
		0, 0, 1,'', 0,
		0, 0, 0, 0, 0,
		0, 0, 2147483647);
IF ISNULL((select count(*) from MMLibrary where AliasName = @library), 0) = 0
 BEGIN
	SET @o_error = 1
SET @EVCODE = (101 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @EVMSG = 'EV_E_LIBRARY_NOT_EXISTIG'
SET @o_xmltxt = dbo.getXMLError((104 | (CAST(POWER(2, 24) AS BIGINT) * 80)),@EVCODE,@library,NULL,NULL)
	GOTO ERROR_EXIT
 END
 select @ArchGroupCopyID = id from archGroupCopy where name = @copyname;
 select @LibraryID = LibraryId from MMLibrary where AliasName = @library;
 select @MasterPoolID = MasterPoolID from MMMasterPool where Libraryid = @LibraryID;
 select @DrivePoolID = DrivePoolid,@ClientID = ClientId from MMDrivePool where MasterPoolId = @MasterPoolID;
 select @comCellID = origCCcommCellID from MMMedia where Libraryid = @LibraryID;
 select DISTINCT @MediaTypeID = MediaTypeId from MMMedia where libraryid = @LibraryID;
 select DISTINCT @SpareGroupId = SpareGroupId from MMMedia where libraryid = @LibraryID;
 select @LibType = LibraryTypeId from MMLibrary where libraryid = @LibraryID;
 SET  @RecordingFormatID = @MediaTypeID
 SET  @o_agrcpyID = @ArchGroupCopyID
 SET  @o_agrID = @archGroupID
 IF @LibType = 3 AND @IsHardwareCompressed = 1
 BEGIN
	SET @o_error = 1
SET @EVCODE = (103 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @EVMSG = 'EV_E_HW_CAN_NOT_COMPRESS'
SET @o_xmltxt = dbo.getXMLError((104 | (CAST(POWER(2, 24) AS BIGINT) * 80)),@EVCODE,NULL,NULL,NULL)
	GOTO ERROR_EXIT
 END
 IF @LibType = 1  AND @DedupEnable = 1
 BEGIN
	SET @o_error = 1
SET @EVCODE = (102 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @EVMSG = 'EV_E_DEDUP_CAN_NOT_ENABLE'
SET @o_xmltxt = dbo.getXMLError((104 | (CAST(POWER(2, 24) AS BIGINT) * 80)),@EVCODE,NULL,NULL,NULL)
	GOTO ERROR_EXIT
 END
 /*Create archStream*/
 INSERT @RETVAL_ARCH_TMP EXEC archStreamCreate @archGroupID,@ArchGroupCopyID,0,@maxstreams,0,@DrivePoolID,0,@MediaTypeID,@RecordingFormatID
  /*update ArchGroup with new defaultCopy Value*/
 UPDATE ArchGroup SET defaultCopy = @ArchGroupCopyID WHERE Id = @archGroupID;
 INSERT archAgingRule(copyId,retentionDays,fullCycles,flags,weekStart,monthStart,yearStart,archiverRetDays,minutesSinceDayStarts)
		VALUES	 (@ArchGroupCopyID,@basicdays,@basiccycles,@AgingRuleflags,@weekStart,@monthStart,@yearStart,
				 @archiverdays,@minutesSinceDayStarts);
 INSERT MMDatapath (CopyId,DrivePoolId,HostClientId,Flag,SpareGroupId,ReadinessFlag,Priority,IsHardwareCompressed,
		ChunkSizeMB,FlushBlockSizeKB,UseHardwareEncryption)
	VALUES(@ArchGroupCopyID,@DrivePoolID,@ClientID,7,@SpareGroupId,0,0,@IsHardwareCompressed,0,0,0);
 IF (@DedupEnable = 1 ) --If Deduplication is enabled
 BEGIN
	SET @DEDUPXML = '<OpType op = "archCopySetDEDUP">
			<SPDetails SPName = "'+@spname+'"/>
			<CopyDetails>
			<copy CopyName = "'+@copyname+'"/>
<dedup DedupEnable = "1"Path = "'+@pathname+'"
					SiloAppID = "'+CAST(@siloappid AS VARCHAR(100))+'"
					SilosInCache = "'+CAST(@silosincache AS VARCHAR(100))+'"/>
			</CopyDetails>
			<CsDetails	CommCellID = "'+CAST(@comCellID AS VARCHAR(100))+'"
					ClientID = "'+CAST(@ClientID AS VARCHAR(100))+'"/>
			</OpType>'
	EXEC archCopySetDEDUP @DEDUPXML
 END
	IF @o_error = 0
	BEGIN
		COMMIT TRANSACTION
	END
ERROR_EXIT:
	IF @o_error <> 0
	BEGIN
		ROLLBACK TRANSACTION
	END
SELECT @o_agrcpyID, @o_agrID, @o_error, @o_xmltxt


IF EXISTS (select * from GxQscripts where name = 'CreateStoragePolicy')
	delete from GxQscripts where name = 'CreateStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CreateStoragePolicy')
	delete from GXDBVersions where aliasname = 'CreateStoragePolicy'
GO

insert into GXDBVersions values(2, 'CreateStoragePolicy',  '00000000000000000000', 'CreateStoragePolicy', '00000000000000000000')
GO

