

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CreateBackupSetOnVMInstance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CreateBackupSetOnVMInstance.sp,v $ $Id: CreateBackupSetOnVMInstance.sp,v 1.1.2.12 2019/05/29 18:01:21 asenguttuvan Exp $";
-- =============================================
-- Author:		Shravani Chepuri
-- Create date: 04/04/2016
-- Description:	Creates BackupSet on VM Instance, Activity will be disabled under this backupset.
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CreateBackupSetOnVMInstance')
BEGIN
	print '>>> Drop Stored Procedure: CreateBackupSetOnVMInstance <<<'
	drop procedure CreateBackupSetOnVMInstance
END
IF EXISTS (select * from GxQscripts where name='CreateBackupSetOnVMInstance')
	delete from GxQscripts where name = 'CreateBackupSetOnVMInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CreateBackupSetOnVMInstance')
	delete from GXDBVersions where aliasname = 'CreateBackupSetOnVMInstance'
GO
print '... Creating Procedure: CreateBackupSetOnVMInstance'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CreateBackupSetOnVMInstance
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML,
  @vsaClientName NVARCHAR(MAX),
  @o_backupSetId INT OUT,
  @o_subclientId INT OUT,
  @o_errorString VARCHAR(MAX) OUT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @i_clientId			INT
	DECLARE @i_appTypeId		INT
	DECLARE @i_commcellId		INT
	DECLARE @i_dataArchGrpId	INT
	DECLARE @instanceId			INT
	DECLARE @valid				INT
	DECLARE @backupSetId		INT
	DECLARE @subClientId		INT
	DECLARE @createTime			INT
	DECLARE @i_subClientName	NVARCHAR(1024)
	DECLARE @i_backupSetName	NVARCHAR(1024)
	SET @o_errorString = ''
	SET @o_backupSetId = 0
	SET @o_subclientId = 0
	--GET COMMCELL
	SET @i_commcellId = ISNULL(( SELECT ref.value('@commcellId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 2)
	--GET CLIENT ID
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 0)
	--GET APPTYPE ID
	SET @i_appTypeId = ISNULL(( SELECT ref.value('@appTypeId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 0)
	--USE DEFAULT INSTANCE
	SET @instanceId = ISNULL(( SELECT ref.value('@instanceId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 1)
	IF @i_clientId = 0
	BEGIN
		SET @o_backupSetId = -1
		SET @o_errorString = 'Invalid ClientId.'
		RETURN
	END
	IF @i_appTypeId = 0
	BEGIN
		SET @o_backupSetId = -2
		SET @o_errorString = 'Invalid appTypeId.'
		RETURN
	END
	--CANNOT CREATE BACKUPSET FOR SUBCLIENT POLICY
IF @i_appTypeId = 1030
	BEGIN
		SET @o_backupSetId = -3
		SET @o_errorString = 'Invalid appTypeId'
		RETURN
	END
	--MAKE SURE BACKUPSET NAME IS NOT EMPTY
	SET @i_backupSetName = ISNULL(( SELECT ref.value('@backupSetName', 'NVARCHAR(1024)')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), '')
	IF @i_backupSetName = ''
	BEGIN
		SET @o_backupSetId = -4
		SET @o_errorString = 'Backup set name can not be empty'
		RETURN
	END
	--GET SUBCLIENT NAME. CHECK FOR ATTRIBUTE NOT SENT
	SET @i_subClientName = ISNULL(( SELECT ref.value('@subClientName', 'NVARCHAR(1024)')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 'default')
	--CHECK FOR EMPTY INPUT subClientName
	IF @i_subClientName = ''
		SET @i_subClientName = 'default'
	SET @createTime = dbo.getunixtime(GETUTCDATE())
	--VERIFY ARGUMENTS
	SET @valid = (SELECT COUNT(*) FROM APP_CommCell AS CC WITH(NOLOCK), APP_Client AS CL WITH(NOLOCK), APP_iDAType as AT WITH(NOLOCK), ArchGroup AS AG WITH(NOLOCK)
					WHERE CC.id = @i_commcellId AND CL.id = @i_clientId AND AT.type = @i_appTypeId)
	IF @valid = 0
	BEGIN
		SET @o_backupSetId = -5
		SET @o_errorString = 'Invalid arguments'
		RETURN
	END
	--GET ARCHGROUP INFORMATION
	SET @i_dataArchGrpId = ISNULL(( SELECT ref.value('@dataArchGrpId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 0)
	IF @i_dataArchGrpId = 0 OR NOT EXISTS (SELECT * FROM ArchGroup WITH(NOLOCK) WHERE id = @i_dataArchGrpId)
	BEGIN
		SET @o_backupSetId = -6
		SET @o_errorString = 'Invalid ArchGrp arguments'
		RETURN
	END
	IF EXISTS( SELECT name FROM APP_BackupSetName WITH (NOLOCK) WHERE name = @i_backupSetName and id in(select backupset from APP_Application WITH (NOLOCK) where clientId=@i_clientId and appTypeId=@i_appTypeId) )
	BEGIN
		DECLARE @backupSetNameExists INT
		SET @backupSetNameExists=1
		IF LEN(@vsaClientName) <> 0
		BEGIN
			SET @i_backupSetName = @i_backupSetName+'_'+@vsaClientName
				IF NOT EXISTS( SELECT name FROM APP_BackupSetName WITH(NOLOCK) WHERE name = @i_backupSetName and id in(select backupset from APP_Application WITH(NOLOCK) where clientId=@i_clientId and appTypeId=@i_appTypeId) )
				SET @backupSetNameExists = 0
		END
		IF @backupSetNameExists = 1
		BEGIN
			SET @o_backupSetId = -7
			SET @o_errorString = 'Backup set name already exists'
			RETURN
		END
	END
BEGIN TRY
	DECLARE @tranCnt INT = @@TRANCOUNT
    IF (@tranCnt > 0)
    BEGIN
       SAVE TRAN CreateBackupSetOnVMInstance_Tran
    END
    ELSE
    BEGIN
       BEGIN TRAN CreateBackupSetOnVMInstance_Tran
    END
	--CREATE BACKUP SET
	INSERT INTO APP_BackupSetName (name, refTime, modified, status, origCCId, GUID)
VALUES(@i_backupSetName, @createTime, @createTime, 0x200000, 2, newid())
	SET @backupSetId = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
	--CREATE DEFAULT SUBCLIENT
	INSERT INTO APP_Application (clientId, appTypeId, instance, backupSet, dataArchGrpID, logArchGrpID, appNumber, refTime, modified, subclientName, subclientStatus, origCCId, GUID)
SELECT @i_clientId, @i_appTypeId, @instanceId, @backupSetId, @i_dataArchGrpId, @i_dataArchGrpId, 0, @createTime, @createTime, @i_subClientName, 0x200000 | CONVERT(INT, 0x00008), 2, newid()
		FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref )
	SET @subClientId = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
	--ADD SUBCLIENT PROPERTIES
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'last data SP', 10, 1, @createTime, 0),
				(@subClientId, 'last log SP', 10, 1, @createTime, 0),
				(@subClientId, 'Single Instancing Option', 7, 1, @createTime, 0),
				(@subClientId, 'Encrypt: encryption', 10, 2, @createTime, 0),
				(@subClientId, 'prepost password', 1, 2, @createTime, 0),
				(@subClientId, 'sys: pre post option', 10, 0, @createTime, 0),
				(@subClientId, 'sys:nStreams', 7, 5, @createTime, 0),
				(@subClientId, 'New Index Cycle', 10, 100, @createTime, 0),
				(@subClientId, 'last content change', 10, @createTime, @createTime, 0)
	--CREATE BACKUP SET PROPERTIES FOR:
	--ALL APPTYPES
	INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@backupSetId, 'Use Change Journal', 2, 0, @createTime, 0)
	--ON SUCCESS RETURN BACKUPSET ID
	SET @o_backupSetId = @backupSetId
	SET @o_subclientId = @subClientId
	IF (@tranCnt = 0)
    BEGIN
       COMMIT TRAN CreateBackupSetOnVMInstance_Tran
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_backupSetId OUTPUT
	--CHANGE ERROR CODE TO NEGATIVE TO DISTINGUISH FROM ACTUAL BACKUP SET ID
	IF @o_backupSetId > 0
		SET @o_backupSetId = -1 * @o_backupSetId
	ROLLBACK TRAN CreateBackupSetOnVMInstance_Tran
END CATCH
END
GO


IF EXISTS (select * from GxQscripts where name = 'CreateBackupSetOnVMInstance')
	delete from GxQscripts where name = 'CreateBackupSetOnVMInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CreateBackupSetOnVMInstance')
	delete from GXDBVersions where aliasname = 'CreateBackupSetOnVMInstance'
GO

insert into GXDBVersions values(2, 'CreateBackupSetOnVMInstance',  '00010001000200120000', 'CreateBackupSetOnVMInstance', '00010001000200120000')
GO

