

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ConfigureVSAApplOnVMClient.sp] ---------- 

--  +========================================================================+
--  | Name:  ConfigureVSAApplOnVMClient
--  | Description: It will take input as list of VM ClientIds and VSA backupset Id
--  | and creates corresponding backupset\subclient under each VM client
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ConfigureVSAApplOnVMClient')
BEGIN
	print '>>> Drop Stored Procedure: ConfigureVSAApplOnVMClient <<<'
	drop procedure ConfigureVSAApplOnVMClient
END
IF EXISTS (select * from GxQscripts where name='ConfigureVSAApplOnVMClient')
	delete from GxQscripts where name = 'ConfigureVSAApplOnVMClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ConfigureVSAApplOnVMClient')
	delete from GXDBVersions where aliasname = 'ConfigureVSAApplOnVMClient'
GO
print '... Creating Procedure: ConfigureVSAApplOnVMClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ConfigureVSAApplOnVMClient
  @i_xmlText XML OUTPUT
AS
BEGIN TRY
	DECLARE @lockResult INT
	DECLARE @errorCode		INT = 0
	DECLARE @errorStr	NVARCHAR(1024) = N''
	EXEC @lockResult = sp_getapplock @Resource = 'configureVSAApplOnVMClient', @LockMode = 'Exclusive', @LockTimeout = 60000 --Time to wait for the lock
	IF @lockResult < 0
	BEGIN
		SET @errorCode = @lockResult
		SET @errorStr = 'Procedure Already Running - Concurrent execution is not supported.'
		RAISERROR(@errorStr, 16,1)
	END
	DECLARE @vmClientId bigint
	DECLARE @unixTime bigint
	DECLARE @vsaBackupSetId INT=0
	DECLARE @vsaSubClientId INT=0
	DECLARE @dataArchGrpId  INT=0
	DECLARE @vsaClientId	INT=0
	DECLARE @parentJobId	bigint=0
	DECLARE @vsaClientName NVARCHAR(MAX) = N''
	DECLARE @vsaBackupSetName NVARCHAR(MAX) = N''
	DECLARE @discoveredVMInstanceId INT=0
	DECLARE @v2propTime INT = 0
	SET @unixTime = dbo.GetUnixTime(GetUTCDate())
	SET @discoveredVMInstanceId = ISNULL((select componentNameId from APP_InstanceProp INNER JOIN App_InstanceName ON App_instancename.id=componentNameId and attrName = 'Discovered VM Instance' and APP_InstanceProp.modified=0 and status=0x200000), 0)
	IF @discoveredVMInstanceId = 0
	BEGIN
		SET @errorCode = -1
		SET @errorStr = 'VMInstance is either not present or status is incorrect.'
		RAISERROR(@errorStr, 16,1)
	END
	IF object_id('tempdb.dbo.#tmpVMclientInfo') IS NOT null DROP TABLE #tmpVMclientInfo
	CREATE  TABLE #tmpVMclientInfo
	(
		clientId bigint,
		backupSetId int,
		needsbackupsetrename int,
		backupsetnameconflict int,
		subclientId int,
		backupsetGuid uniqueidentifier,
		failureReason NVARCHAR(max),
		subclientGuid NVARCHAR(1024)
	)
	SET @vsaSubClientId=ISNULL( (SELECT  T.c.value('@vsaSubClientId', 'int') FROM   @i_xmlText.nodes('App_VMClientBackupSetReq') T(c)), 0)
	SET @parentJobId=ISNULL( (SELECT  T.c.value('@vsaParentJobID', 'bigint') FROM   @i_xmlText.nodes('App_VMClientBackupSetReq') T(c)), 0)
	IF @parentJobId > 0
	BEGIN
		SELECT @v2propTime = jobStartTime - 1
		FROM JMJobInfo (NOLOCK)
		WHERE jobId = CAST(@parentJobId AS INT)
		AND commCellId = 2 -- DEFAULT_COMM_CELL_ID
	END
	ELSE
	BEGIN
		SET @v2propTime = @unixTime
	END
	SELECT @vsaBackupSetId=backupSet,@dataArchGrpId=dataArchGrpID,@vsaClientId=clientId from APP_Application WITH(READUNCOMMITTED) where id=@vsaSubClientId
	SELECT @vsaBackupSetName=name from APP_BackupSetName WITH(READUNCOMMITTED) where id=@vsaBackupSetId
	SELECT @vsaClientName=name from APP_Client WITH(READUNCOMMITTED) where id=@vsaClientId
	INSERT INTO #tmpVMclientInfo
		SELECT
                     CASE
                           WHEN cl.id IS NOT NULL THEN cl.id
                           ELSE T.c.value('@val', 'int')
                     END,
                     CASE
                           WHEN cl.id IS NULL THEN -1
                           ELSE
						   CASE
								WHEN d.ChildBackupSetId IS NOT NULL THEN d.ChildBackupSetId
								ELSE 0
							END
                     END,
					 CASE
                           WHEN cl.id IS NULL THEN 0
                           ELSE
						   CASE
								WHEN d.BackupSetName <> @vsaBackupSetName THEN 1
								ELSE 0
						   END
                     END,
					 0,
                     CASE
                           WHEN cl.id IS NULL THEN -1
                           ELSE
						   CASE
								WHEN d.subClientId IS NOT NULL THEN d.subClientId
								ELSE 0
							END
                     END,
					  CASE
							WHEN cl.id IS NULL THEN NULL
							ELSE
							CASE
								WHEN d.backupsetGuid IS NOT NULL THEN d.backupsetGuid
								ELSE NULL
							END
					 END,
                     CASE
                           WHEN cl.id IS NULL THEN 'Client does not exists in the DB.'
                           ELSE
						   CASE
								WHEN d.ChildBackupSetId IS NOT NULL THEN 'Associated BackupSet is already Created.'
								ELSE ' '
							END
                     END,
					 CASE
                           WHEN cl.id IS NULL THEN NULL
                           ELSE
						   CASE
								WHEN d.subClientGuid IS NOT NULL THEN d.subClientGuid
								ELSE NULL
							END
                     END
              FROM    @i_xmlText.nodes('App_VMClientBackupSetReq/vmClientIds') T(c)
                     LEFT OUTER JOIN APP_Client cl WITH(READUNCOMMITTED) ON
                           cl.id = T.c.value('@val', 'int')
                     LEFT OUTER JOIN (
                           SELECT
                                  vmb.VMClientId clientId,
                                  vmb.ChildBackupSetId ChildBackupSetId,
								  bs.name BackupSetName,
                                  subCl.id subClientId,
								  bs.GUID backupsetGuid,
								  subCl.GUID subClientGuid
                           FROM APP_VMBackupSet vmb  WITH(READUNCOMMITTED)
                                  INNER JOIN APP_BackupSetName bs WITH(READUNCOMMITTED) ON
                                         bs.id=vmb.ChildBackupSetId
                                  INNER JOIN APP_Application subCl  WITH(READUNCOMMITTED) ON
                                         subCl.backupSet=vmb.ChildBackupSetId
										AND vmb.ParentBackupSetId=@vsaBackupSetId
AND (subCl.subClientStatus & 0x200000) = 0x200000
                     ) d ON
                           d.clientId = T.c.value('@val', 'int')
	IF OBJECT_ID('tempdb.dbo.#ConfigureOrDeConfigureVMBackupsets_vmClientIdList') IS NOT NULL
		DROP TABLE #ConfigureOrDeConfigureVMBackupsets_vmClientIdList
	CREATE TABLE #ConfigureOrDeConfigureVMBackupsets_vmClientIdList (
		vmClientId INT,
		vmBackupSetId INT,
		PRIMARY KEY (vmClientId, vmBackupSetId)
	)
	--Configure VM clients which are actively getting backedup
	INSERT INTO #ConfigureOrDeConfigureVMBackupsets_vmClientIdList
		select clientId,backupSetId from  #tmpVMclientInfo
	IF EXISTS (SELECT 1 from #ConfigureOrDeConfigureVMBackupsets_vmClientIdList)
	BEGIN
		EXEC ConfigureOrDeConfigureVMBackupsets 2
	END
	--VSA backup set name and discovered client backup set name should be same for easy association in the GUI display
    Update VMClientInfo set backupsetnameconflict = 1
    FROM #tmpVMclientInfo VMClientInfo WHERE needsbackupsetrename = 1
    AND EXISTS( select 1 from APP_BackupSetName BackupSet
    INNER JOIN APP_Application subCl ON subCl.backupSet=BackupSet.id AND subCl.clientId=VMClientInfo.clientId
    WHERE BackupSet.id <> VMClientInfo.backupSetId AND BackupSet.name = @vsaBackupSetName )
    Update BackupSet SET name=
    CASE
        WHEN VMClientInfo.backupsetnameconflict = 1 THEN @vsaBackupSetName+'_'+@vsaClientName
        ELSE @vsaBackupSetName
    END
    FROM APP_BackupSetName BackupSet
    INNER JOIN #tmpVMclientInfo VMClientInfo ON VMClientInfo.backupSetId=BackupSet.id AND VMClientInfo.needsbackupsetrename = 1
	--Storage policy for Virtualization client subclient and VM subclient should be same always.
	Update Subclient SET dataArchGrpID=@dataArchGrpId,logArchGrpID=@dataArchGrpId
	FROM APP_Application Subclient
	INNER JOIN #tmpVMclientInfo VMClientInfo ON Subclient.id = VMClientInfo.subclientId
	WHERE Subclient.dataArchGrpID <> @dataArchGrpId OR Subclient.logArchGrpID <> @dataArchGrpId
	--Enable IndexingV2 for each VM client for the browse to work
	MERGE APP_ClientProp AS T1
	USING #tmpVMclientInfo T2
	ON T1.componentNameId = T2.clientId  AND T1.attrName='IndexingV2_VSA' and T1.modified=0
	WHEN MATCHED and T1.attrVal <> '1' THEN
		UPDATE SET T1.attrVal ='1', T1.created = @v2propTime
	WHEN NOT MATCHED THEN
		INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
		VALUES(T2.clientId,'IndexingV2_VSA',2,'1', @v2propTime,0);
	-- Update IndexingV2 bitmask after adding/setting for client
	EXEC UpdateIdxV2AppTypesBitmask
	--Add VSA appType on VM client if not already exists
	MERGE APP_IDAName AS T1
	USING #tmpVMclientInfo T2
ON T1.clientId = T2.clientId and T1.appTypeId = 106
	WHEN NOT MATCHED THEN
		insert(clientId,appTypeId,status,refTime,modified,ccpId,ccpTime)
VALUES(T2.clientId,106,0,0,@unixTime,0,0);
	DECLARE ClientInfoCursor CURSOR LOCAL FORWARD_ONLY READ_ONLY
	FOR
	SELECT clientId AS clientId
		FROM   #tmpVMclientInfo where backupSetId = 0
	OPEN ClientInfoCursor
	FETCH FROM ClientInfoCursor INTO @vmClientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @inputStr NVARCHAR(MAX) = N''
		DECLARE @failureReason	NVARCHAR(1024) = N''
		DECLARE @backupSetId	INT = 0
		DECLARE @subClientId	INT = 0
		DECLARE @backupsetGuid uniqueidentifier
		DECLARE @subclientGuid NVARCHAR(1024)
		SET @vsaBackupSetName = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(@vsaBackupSetName, '&', '&amp;'), '>', '&gt;'), '<', '&lt;'), '"', '&quot;'), '''', '&apos;')
		SET @inputStr = '<CVGui_CreateOnDemandBackupSetReq clientId="' + CAST(@vmclientId as varchar(10)) + '" dataArchGrpId="'
+ CAST(@dataArchGrpId as varchar(10)) + '" instanceId="' + CAST(@discoveredVMInstanceId as varchar(10)) + '" appTypeId="' + CAST(106 as varchar(10))
							+ '" backupSetName="' + @vsaBackupSetName + '" />'
		EXEC CreateBackupSetOnVMInstance @inputStr,@vsaClientName,@backupSetId OUTPUT,@subClientId OUTPUT,@failureReason OUTPUT
		IF @backupSetId <= 0 OR @subClientId <= 0
		BEGIN
			SET @errorCode = -1
			SET @errorStr = 'Failed to create default subclient for VM'
			RAISERROR(@errorStr, 16,1)
		END
		SET @backupsetGuid = ISNULL((select GUID from APP_BackupSetName WITH(NOLOCK) where id=@backupSetId), '')
		SET @subclientGuid = ISNULL((select GUID from APP_APPLICATION WITH(NOLOCK) where id=@subClientId), '')
		Update #tmpVMclientInfo set backupSetId=@backupSetId,subclientId=@subClientId, backupsetGuid=@backupsetGuid, failureReason=@failureReason, subclientGuid=@subclientGuid  where clientId=@vmclientId
		FETCH FROM ClientInfoCursor INTO @vmClientId
	END
	--Close cursor
	CLOSE ClientInfoCursor
	DEALLOCATE ClientInfoCursor
	--Enable Snap Backups for each VM client and subclient if snap enabled at parent subclient
	IF EXISTS (select * from APP_SubClientProp WITH(READUNCOMMITTED) where componentNameId=@vsaSubClientId and attrName = 'Enable Snap Backups' and attrVal ='1' and modified = 0)
	BEGIN
		MERGE APP_ClientProp AS T1
		USING #tmpVMclientInfo T2
		ON T1.componentNameId = T2.clientId  AND T1.attrName='Snap Backups Enabled' AND T1.modified = 0
		WHEN MATCHED and T1.attrVal <> '1' THEN
			UPDATE SET T1.attrVal ='1'
		WHEN NOT MATCHED THEN
			INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(T2.clientId,'Snap Backups Enabled',2,'1',@unixTime,0);
		MERGE App_SubclientProp AS T1
		USING #tmpVMclientInfo T2
		ON T1.componentNameId = T2.subclientId  AND T1.attrName='Enable Snap Backups' AND T1.modified = 0
		WHEN MATCHED and T1.attrVal <> '1' THEN
			UPDATE SET T1.attrVal ='1'
		WHEN NOT MATCHED THEN
			INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(T2.subclientId,'Enable Snap Backups',2,'1',@unixTime,0);
	END
	ELSE
	BEGIN
		MERGE App_SubclientProp AS T1
		USING #tmpVMclientInfo T2
		ON T1.componentNameId = T2.subclientId  AND T1.attrName='Enable Snap Backups' AND T1.modified = 0
		WHEN MATCHED and T1.attrVal <> '0' THEN
			UPDATE SET T1.attrVal ='0'
		WHEN NOT MATCHED THEN
			INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(T2.subclientId,'Enable Snap Backups',2,'0',@unixTime,0);
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
		--Close cursor
	IF ( CURSOR_STATUS('local', 'ClientInfoCursor') >= 0  )/* cursor is open */
		CLOSE ClientInfoCursor
	IF ( CURSOR_STATUS('local','ClientInfoCursor') = -1 ) /* cursor is closed */
		DEALLOCATE ClientInfoCursor
END CATCH
--Save the mapping between VSA backupset to child backup set in APP_VMBackupSet
--It should be done out side the try block to have the mapping for successful subclient creation if it failed in the middle
MERGE APP_VMBackupSet AS T1
USING #tmpVMclientInfo T2
ON clientId = VMClientId  AND ParentBackupSetId=@vsaBackupSetId AND backupSetId > 0 AND subclientId > 0
WHEN MATCHED AND T1.ChildBackupSetId<>T2.backupSetId THEN
	UPDATE SET T1.ChildBackupSetId=T2.backupSetId
WHEN NOT MATCHED AND backupSetId > 0 THEN
	INSERT(VMClientId,ParentBackupSetId,ChildBackupSetId)
	VALUES(T2.clientId,@vsaBackupSetId,T2.backupSetId);
IF (@errorStr = '' OR @errorStr IS NULL) AND @errorCode = 0
	SET @errorStr = 'Success'
SET @i_xmlText = (
	(SELECT
		@errorCode as '@errorCode',
		@errorStr as '@errorMessage',
		( select
			clientId as '@vmClientId',
			failureReason as '@failureReason',
			backupSetId as 'subClient/@backupsetId',
			subclientId as 'subClient/@subclientId',
			backupsetGuid as 'subClient/@backupsetGUID',
			subclientGuid as 'subClient/@subclientGUID'
			from #tmpVMclientInfo FOR XML PATH('vmClientBackupSetIds'), TYPE )
			FOR XML PATH('App_VMClientBackupSetResp'), TYPE)
		)
IF object_id('tempdb.dbo.#tmpVMclientInfo') IS NOT null DROP TABLE #tmpVMclientInfo
GO

IF EXISTS (select * from GxQscripts where name = 'ConfigureVSAApplOnVMClient')
	delete from GxQscripts where name = 'ConfigureVSAApplOnVMClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ConfigureVSAApplOnVMClient')
	delete from GXDBVersions where aliasname = 'ConfigureVSAApplOnVMClient'
GO

insert into GXDBVersions values(2, 'ConfigureVSAApplOnVMClient',  '00000000000000000000', 'ConfigureVSAApplOnVMClient', '00000000000000000000')
GO

