

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ConfigureOrDeConfigureVMBackupsets.sp] ---------- 

--  +========================================================================+
--  | Name:  ConfigureOrDeConfigureVMBackupsets
--  | Description: It will take input as list of VM ClientIds and VSA backupset Id
--  | and configure or deconfigure all associated VM backupsets, subclients and clients
--	| Inputs: isConfigure : 1 -> Confiures all the input VM clients and backupsets
--  |						2 -> Confiures and removes "Marked for Deconfigure" properties from all the input VM clients and backupsets
--  |						0 -> DeConfiures all the input VM backupsets and deconfigure agent\client if no other configured child entities
--  |						-1 -> "Marked for Deconfigure" property will be added for all the input VM backupsets and for agent\client if no other child entities
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ConfigureOrDeConfigureVMBackupsets')
BEGIN
	print '>>> Drop Stored Procedure: ConfigureOrDeConfigureVMBackupsets <<<'
	drop procedure ConfigureOrDeConfigureVMBackupsets
END
IF EXISTS (select * from GxQscripts where name='ConfigureOrDeConfigureVMBackupsets')
	delete from GxQscripts where name = 'ConfigureOrDeConfigureVMBackupsets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ConfigureOrDeConfigureVMBackupsets')
	delete from GXDBVersions where aliasname = 'ConfigureOrDeConfigureVMBackupsets'
GO
print '... Creating Procedure: ConfigureOrDeConfigureVMBackupsets'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ConfigureOrDeConfigureVMBackupsets
  @isConfigure INT
AS
SET NOCOUNT ON
DECLARE @unixTime bigint = dbo.GetUnixTime(GetUTCDate())
IF (OBJECT_ID('tempdb.dbo.#ConfigureOrDeConfigureVMBackupsets_vmClientIdList') IS NULL)
	RETURN
IF object_id('tempdb.dbo.#tempVMclientInfo') IS NOT null DROP TABLE #tempVMclientInfo
CREATE  TABLE #tempVMclientInfo
(
	vmClientId bigint,
	backupSetId int,
	subclientId int,
	deconfigureVSAAppType int,
	deConfigureClient int
)
INSERT INTO #tempVMclientInfo
select vmList.vmClientId, vmList.vmBackupSetId, subCl.id,0,0
		FROM #ConfigureOrDeConfigureVMBackupsets_vmClientIdList vmList
		LEFT JOIN APP_Application subCl  WITH(READUNCOMMITTED) ON subCl.backupSet=vmList.vmBackupSetId
DECLARE @opMsgId INT
IF (@isConfigure =1 OR @isConfigure =2)
BEGIN
	--Mark the clients as configured
	update CP set attrval ='0' from APP_ClientProp CP
	inner join #tempVMclientInfo tmp on tmp.vmClientId = CP.componentNameId
	WHERE attrName ='PlatformDeleted 4' and CP.modified=0 and CP.attrVal <> '0'
	update C set status = status & ~2 from App_client C
	inner join #tempVMclientInfo tmp on tmp.vmClientId = C.id
WHERE (status & 0x00002) > 0
	--Mark the 'Virtual Server' Application as configured
	Update APP_IDAName SET status = status & ~2 FROM APP_IDAName
	INNER JOIN #tempVMclientInfo tmp ON APP_IDAName.clientId = tmp.vmClientId
where appTypeId=106 and (status & 0x00002) > 0
	--Mark the VM backupsets as configured as there will be only one subclient under backupset
	Update BackupSet SET status = status & ~2
	FROM APP_BackupSetName BackupSet
	INNER JOIN #tempVMclientInfo VMClientInfo ON BackupSet.id=VMClientInfo.backupSetId
WHERE (status & 0x00002) > 0
	--Mark the VM subclients as configured
	Update Subclient SET subclientStatus = subclientStatus & ~2
	FROM APP_Application Subclient
	INNER JOIN #tempVMclientInfo VMClientInfo ON Subclient.id = VMClientInfo.subclientId
WHERE (Subclient.subclientStatus & 0x00002) > 0
	IF(@isConfigure =2)
	BEGIN
		MERGE APP_ClientProp AS T1
		USING #tempVMclientInfo T2
ON T1.componentNameId = T2.vmClientId  AND T1.attrName='Marked For Deconfigure' AND T1.modified = 0
		WHEN MATCHED THEN
			DELETE;
		MERGE APP_IDAProp AS T1
		USING (select id from APP_IDAName
INNER JOIN #tempVMclientInfo tmp ON APP_IDAName.clientId = tmp.vmClientId AND appTypeId=106 ) T2
ON T1.componentNameId = T2.id  AND T1.attrName='Marked For Deconfigure' AND T1.modified = 0
		WHEN MATCHED THEN
			DELETE;
		MERGE APP_BackupSetProp AS T1
		USING #tempVMclientInfo T2
ON T1.componentNameId = T2.backupSetId  AND T1.attrName='Marked For Deconfigure' AND T1.modified = 0
		WHEN MATCHED THEN
			DELETE;
		MERGE APP_SubClientProp AS T1
		USING #tempVMclientInfo T2
ON T1.componentNameId = T2.subclientId  AND T1.attrName='Marked For Deconfigure' AND T1.modified = 0
		WHEN MATCHED THEN
			DELETE;
	END
SET @opMsgId = (673 | (CAST(POWER(2, 24) AS BIGINT) * 84))
END
ELSE IF (@isConfigure = 0 )
BEGIN
	update #tempVMclientInfo set deconfigureVSAAppType = 1, deConfigureClient=1
	--Mark the VM subclients as deconfigured
Update Subclient SET subclientStatus = subclientStatus | 0x00002
	FROM APP_Application Subclient
	INNER JOIN #tempVMclientInfo VMClientInfo ON Subclient.id = VMClientInfo.subclientId
WHERE (Subclient.subclientStatus & 0x00002) = 0
	--Mark the VM backupsets as deconfigured as there will be only one subclient under backupset
Update BackupSet SET status = status | 0x00002
	FROM APP_BackupSetName BackupSet
	INNER JOIN #tempVMclientInfo VMClientInfo ON BackupSet.id=VMClientInfo.backupSetId
WHERE (status & 0x00002) = 0
	--Do not Mark the 'Virtual Server' Application and client  as deconfigured if there is VSA package installed on it
	update tmp set deconfigureVSAAppType = 0, deConfigureClient=0
	FROM #tempVMclientInfo tmp
INNER JOIN simInstalledPackages  SIM WITH(READUNCOMMITTED) ON SIM.ClientId = tmp.vmClientId	AND SIM.simPackageId in (1136 , 713)
	--Do not Mark the 'Virtual Server' Application and client as deconfigured if there are backupsets in configured
	update tmp set deconfigureVSAAppType = 0, deConfigureClient=0
	FROM #tempVMclientInfo tmp
	WHERE deconfigureVSAAppType = 1 and EXISTS(
		select VMClientId from APP_VMBackupSet vmb  WITH(READUNCOMMITTED)
INNER JOIN APP_BackupSetName bs WITH(READUNCOMMITTED) ON  bs.id=vmb.ChildBackupSetId AND bs.status & 0x00002 = 0
		WHERE vmb.VMClientId = tmp.vmClientId)
	--Do not Mark the client as deconfigured if there are packages installed on it
	update tmp set deConfigureClient=0
	FROM #tempVMclientInfo tmp
		INNER JOIN simInstalledPackages SIM WITH(READUNCOMMITTED) ON SIM.ClientId = tmp.vmClientId
	WHERE deConfigureClient = 1
	--Mark the 'Virtual Server' Application as deconfigured
Update APP_IDAName SET status = status | 0x00002 FROM APP_IDAName
	INNER JOIN #tempVMclientInfo tmp ON APP_IDAName.clientId = tmp.vmClientId AND tmp.deconfigureVSAAppType = 1
where appTypeId=106 and (status & 0x00002) = 0
	--Mark the clients as deconfigured
	update CP set attrval ='1' from APP_ClientProp CP
	inner join #tempVMclientInfo tmp on tmp.vmClientId = CP.componentNameId  AND tmp.deConfigureClient = 1
	WHERE attrName ='PlatformDeleted 4' and CP.modified=0 and CP.attrVal <> '1'
update C set status = status | 0x00002 from App_client C
	inner join #tempVMclientInfo tmp on tmp.vmClientId = C.id AND tmp.deConfigureClient = 1
WHERE (status & 0x00002) = 0
SET @opMsgId = (674 | (CAST(POWER(2, 24) AS BIGINT) * 84))
END
ELSE
BEGIN
	--Mark for deconfigure instead of actual deconfigure, actual deconfigure will happen after default 30 days
	update #tempVMclientInfo set deconfigureVSAAppType = 1, deConfigureClient=1
	--Mark the VM subclients as deconfigured
	MERGE APP_SubClientProp AS T1
    USING #tempVMclientInfo T2
ON T1.componentNameId = T2.subclientId  AND T1.attrName='Marked For Deconfigure' AND T1.modified = 0
    WHEN NOT MATCHED THEN
        INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(T2.subclientId,'Marked For Deconfigure',2,@unixTime,@unixTime,0);
	--Mark the VM backupsets as deconfigured
	MERGE APP_BackupSetProp AS T1
    USING #tempVMclientInfo T2
ON T1.componentNameId = T2.backupSetId  AND T1.attrName='Marked For Deconfigure' AND T1.modified = 0
    WHEN NOT MATCHED THEN
        INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(T2.backupSetId,'Marked For Deconfigure',2,@unixTime,@unixTime,0);
	--Do not Mark the 'Virtual Server' Application and client  as deconfigured if there is VSA package installed on it
	update tmp set deconfigureVSAAppType = 0, deConfigureClient=0
	FROM #tempVMclientInfo tmp
INNER JOIN simInstalledPackages  SIM WITH(READUNCOMMITTED) ON SIM.ClientId = tmp.vmClientId	AND SIM.simPackageId in (1136 , 713)
	--Do not Mark the 'Virtual Server' Application and client as deconfigured if there are backupsets in configured and not marked for deconfigure
	update tmp set deConfigureClient=0,deconfigureVSAAppType=0
	FROM #tempVMclientInfo tmp
	WHERE deconfigureVSAAppType = 1 and EXISTS(
		select VMClientId from APP_VMBackupSet vmb  WITH(READUNCOMMITTED)
INNER JOIN APP_BackupSetName bs WITH(READUNCOMMITTED) ON  bs.id=vmb.ChildBackupSetId AND bs.status & 0x00002 = 0
		WHERE vmb.VMClientId = tmp.vmClientId AND
NOT EXISTS(select componentNameId from APP_BackupSetProp bsProp WITH(READUNCOMMITTED) WHERE bsProp.componentNameId = vmb.ChildBackupSetId AND bsProp.attrName='Marked For Deconfigure' AND bsProp.modified = 0)
		)
	--Do not Mark the client as deconfigured if there are packages installed on it
	update tmp set deConfigureClient=0
	FROM #tempVMclientInfo tmp
		INNER JOIN simInstalledPackages SIM WITH(READUNCOMMITTED) ON SIM.ClientId = tmp.vmClientId
	WHERE deConfigureClient = 1
	--Mark the VSA apptype as deconfigured
	MERGE APP_IDAProp AS T1
USING (select id from APP_IDAName INNER JOIN #tempVMclientInfo tmp ON APP_IDAName.clientId = tmp.vmClientId AND appTypeId=106
		where deconfigureVSAAppType = 1) T2
ON T1.componentNameId = T2.id  AND T1.attrName='Marked For Deconfigure' AND T1.modified = 0
    WHEN NOT MATCHED THEN
        INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(T2.id,'Marked For Deconfigure',2,@unixTime,@unixTime,0);
	--Mark the clients as deconfigured
	MERGE APP_ClientProp AS T1
    USING (select vmClientId from #tempVMclientInfo where deConfigureClient = 1) T2
ON T1.componentNameId = T2.vmClientId  AND T1.attrName='Marked For Deconfigure' AND T1.modified = 0
    WHEN NOT MATCHED THEN
        INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(T2.vmClientId,'Marked For Deconfigure',2,@unixTime,@unixTime,0);
SET @opMsgId = (675 | (CAST(POWER(2, 24) AS BIGINT) * 84))
END
IF object_id('tempdb.dbo.#tempVMclientInfo') IS NOT null DROP TABLE #tempVMclientInfo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ConfigureOrDeConfigureVMBackupsets')
	delete from GxQscripts where name = 'ConfigureOrDeConfigureVMBackupsets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ConfigureOrDeConfigureVMBackupsets')
	delete from GXDBVersions where aliasname = 'ConfigureOrDeConfigureVMBackupsets'
GO

insert into GXDBVersions values(2, 'ConfigureOrDeConfigureVMBackupsets',  '00000000000000000000', 'ConfigureOrDeConfigureVMBackupsets', '00000000000000000000')
GO

