

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CommonGUIProcedure.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	|			Stored Procedure: "CommonGuiProcedure"							|
--	|																		|
--	|
--  |																		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CommonGUIProcedure <<<'

IF EXISTS (select * from sysobjects where name='CommonGUIProcedure')
	drop procedure CommonGUIProcedure
IF EXISTS (select * from GxQscripts where name='CommonGUIProcedure')
	delete from GxQscripts where name = 'CommonGUIProcedure'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CommonGUIProcedure')
	delete from GXDBVersions where aliasname = 'CommonGUIProcedure'
GO
print '... Creating Procedure: CommonGUIProcedure'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CommonGUIProcedure
  @commCellId integer,
  @localeId integer,
  @userId integer,
  @messageType bigint,
  @sequenceNumber bigint,
  @procedureName varchar(128),
  @xmltext XML
AS
-------------------------------------------------------------------------------------------------------------
-- TO ADD A NEW STORED PROCEDURE ,
-- 1) ADD A NEW "IF" CASE FOR YOUR SP
-- 2) DO SECURITY CHECKS
-- EXAMPLE SECURITY CHECKS
-- SET @capability = EV_BROWSE
-- exec br_NTPermCheck @userId, @localeId, @capability, 2018, @commCellId , @errorCode OUTPUT, @errorString OUTPUT
--	IF @errorCode <> 0
--		goto ERROR_RETURN
-----------------------------------------------------------------------------------------------------------------
DECLARE @errorCode integer
DECLARE @errorString nvarchar(max)
DECLARE @capability integer
IF( @procedureName  = 'JMSapBrowse' )
BEGIN
	--do your security check here -- not enough security?? Goto ERROR_RETURN
	-- If processinginstructioninfo is present then we expect user and locale also to be populated.
	if (@xmltext.exist('JobManager_SapLogBrowseReq/processinginstructioninfo')=0)
	begin
		set @xmltext.modify('insert <processinginstructioninfo><user/><locale/></processinginstructioninfo>
			into (/JobManager_SapLogBrowseReq)[1]')
		set @xmltext.modify('insert attribute userId {sql:variable("@userId")}
			into (/JobManager_SapLogBrowseReq/processinginstructioninfo/user)[1]')
		set @xmltext.modify('insert attribute localeId {sql:variable("@localeId")}
			into (/JobManager_SapLogBrowseReq/processinginstructioninfo/locale)[1]')
	end
	EXEC JMSapBrowse @xmltext
END
--when you add a new SP add a when statement here
ELSE IF( @procedureName  = 'APPGetSubClientPolicies' )
BEGIN
	--do your security check here -- not enough security?? Goto ERROR_RETURN
	EXEC APPGetSubClientPolicies @xmltext, @userId, @localeId, @xmltext
END
ELSE IF(@procedureName ='sec_getAllCatPermissions')
	EXEC sec_getAllCatPermissions @xmltext OUTPUT,@localeId
ELSE IF( @procedureName  = 'AppGetConsoleSettingsList' )
	EXEC @procedureName @userId, 1, @xmltext OUTPUT
ELSE IF( @procedureName  = 'MergeVMClients' )
	EXEC @procedureName @xmltext ,@localeId
ELSE IF( @procedureName  = 'AppGetVSInstancesList' )
BEGIN
		set @xmltext.modify('insert <userEntity/>
			into (/App_GetVSInstancesListReq)[1]')
		set @xmltext.modify('insert attribute userId {sql:variable("@userId")}
			into (/App_GetVSInstancesListReq/userEntity)[1]')
	EXEC AppGetVSInstancesList @xmltext	OUTPUT
END
ELSE
	EXEC @procedureName @xmltext
GOTO EXIT_RETURN
ERROR_RETURN:
SET @xmltext = (SELECT '<?xml version="1.0" encoding="utf-16" ?>' +
	(SELECT
	@errorCode			     as errorCode,
	@errorString	         as errorMessage
FOR XML PATH('CVGui_GenericResp')
)
)
EXIT_RETURN:
SELECT @xmltext
GO

IF EXISTS (select * from GxQscripts where name = 'CommonGUIProcedure')
	delete from GxQscripts where name = 'CommonGUIProcedure'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CommonGUIProcedure')
	delete from GXDBVersions where aliasname = 'CommonGUIProcedure'
GO

insert into GXDBVersions values(2, 'CommonGUIProcedure',  '00000000000000000000', 'CommonGUIProcedure', '00000000000000000000')
GO

