

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CheckScheduleSecurity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CheckScheduleSecurity.sp,v $ $Id: CheckScheduleSecurity.sp,v 1.1.2.2 2019/10/23 13:29:12 jge Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CheckScheduleSecurity')
BEGIN
	print '>>> Drop Stored Procedure: CheckScheduleSecurity <<<'
	drop procedure CheckScheduleSecurity
END
IF EXISTS (select * from GxQscripts where name='CheckScheduleSecurity')
	delete from GxQscripts where name = 'CheckScheduleSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CheckScheduleSecurity')
	delete from GXDBVersions where aliasname = 'CheckScheduleSecurity'
GO
print '... Creating Procedure: CheckScheduleSecurity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CheckScheduleSecurity
  @i_taskId INTEGER,
  @i_userId INTEGER,
  @i_reportId INTEGER
AS
	DECLARE @refTime	integer = null
	DECLARE @subTaskId	integer = null
	SELECT TOP 1 @subTaskId=subTaskId, @refTime=created
	FROM TM_JobRequest WITH (READUNCOMMITTED)
	WHERE @i_taskId = taskId
	order by created desc
	if (@subTaskId is null or @refTime is null)
	begin
		select 0 as checkResult
		return
	end
	IF(@subTaskId <> 0)
	BEGIN
		DECLARE @options xml = (
			select top 1 xmlValue
			from TM_JobXMLOptions WITH (READUNCOMMITTED)
			WHERE (
				jobId=0 AND subTaskId=@subTaskId
				AND created <= @refTime
				AND (modified=0 OR modified > @refTime)
			)
		)
		DECLARE @reportId integer = (
			SELECT top 1 T.C.value('@reportId', 'int') as 'reportId'
			FROM @options.nodes('TMMsg_JobOption/adminOpts/reportOption/webReportOption') T(C)
		)
		if isnull(@reportId, -1) != isnull(@i_reportId, -1)
		begin
			select 0 as checkResult
			return
		end
		if exists (
			select distinct O.userId from (
				SELECT T.C.value('@userId', 'int') as 'userId'
				FROM @options.nodes('TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailUsers') T(C)
				union
				SELECT T.C.value('@userId', 'int') as 'userId'
				FROM @options.nodes('TMMsg_JobOption/adminOpts/reportOption/commonOpt/emailExternalUsers') T(C)
			) as O
			join UMUsers  WITH (READUNCOMMITTED)
			on UMUsers.enabled != 0 and UMUsers.id = O.userId and O.userId = @i_userId
		)
		begin
			select 1 as checkResult
			return
		end
		--check if @i_userId is hidder user for a group
if exists(select id from UMUsers where flags & 0x800 = 0x800 and id = @i_userId)
		begin
			select 1 as checkResult
			return
		end
	end
	select 0 as checkResult
	return
GO

IF EXISTS (select * from GxQscripts where name = 'CheckScheduleSecurity')
	delete from GxQscripts where name = 'CheckScheduleSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CheckScheduleSecurity')
	delete from GXDBVersions where aliasname = 'CheckScheduleSecurity'
GO

insert into GXDBVersions values(2, 'CheckScheduleSecurity',  '00010001000200020000', 'CheckScheduleSecurity', '00010001000200020000')
GO

