

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CheckQuotaLimit.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   11/14/2017
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CheckQuotaLimit.sp,v $ $Id: CheckQuotaLimit.sp,v 1.1.2.2 2018/03/27 09:01:08 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CheckQuotaLimit <<<'

IF EXISTS (select * from sysobjects where name='CheckQuotaLimit')
	drop procedure CheckQuotaLimit
IF EXISTS (select * from GxQscripts where name='CheckQuotaLimit')
	delete from GxQscripts where name = 'CheckQuotaLimit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CheckQuotaLimit')
	delete from GXDBVersions where aliasname = 'CheckQuotaLimit'
GO
print '... Creating Procedure: CheckQuotaLimit'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CheckQuotaLimit
  @inputXML XML
AS
DECLARE @outputXML XML
DECLARE @clientId INT
DECLARE @deltaUsage BIGINT = 0
DECLARE @updateType INT = 0
DECLARE @inAppId INT = 0
DECLARE @inSpaceConsumed BIGINT = 0
DECLARE @inBackupSetGUID UNIQUEIDENTIFIER = NULL
DECLARE @inBackupSetId INT = 0
DECLARE @inCheckQuotaLimit INT = 0
DECLARE @apptype INT = 0
DECLARE @isClientIndxVersion2 INT = 0
DECLARE @oldQuotaUsage BIGINT = 0
DECLARE @currentQuotaUsage BIGINT = 0
DECLARE @quotaUsageAttrName nvarchar(max) = N'File System Quota Usage'
DECLARE @quotaRemaining BIGINT = 0
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = ''
DECLARE @isFsBackuptSetUsage INT = 0
DECLARE @jobId INT = 0;
DECLARE @ccId INT = 0;
DECLARE @currentTime INT = dbo.GetUnixTime(GetUTCDate())
DECLARE @transStarted INT = 0
BEGIN TRY
SELECT @updateType = N.value(N'@updateType', N'INT'),
		@inAppId = N.value(N'@appId', N'INT'),
		@inSpaceConsumed = N.value(N'@spaceConsumed', N'BIGINT'),
		@inBackupSetId = N.value(N'@backupSetId', N'INT'),
		@deltaUsage = N.value(N'@deltaUsage', N'BIGINT'),
		@inCheckQuotaLimit = N.value(N'@checkQuotaLimit', N'INT')
FROM
@inputXML.nodes (N'App_FSQuotaUsage') AS T(N);
IF @inBackupSetId IS NULL OR @inBackupSetId = 0
BEGIN
	SELECT @errorString = N'No such backupset exists. ' + Convert(NVARCHAR(MAX), @inputXML)
    RAISERROR(@errorString, 16, 1);
END
SELECT TOP 1 @apptype = appTypeId, @clientId = A.clientId FROM APP_Application A WITH (NOLOCK) INNER JOIN APP_BackupSetName B WITH (NOLOCK) ON A.backupSet = B.id WHERE B.id = @inBackupSetId;
-- get list of users for this client
IF OBJECT_ID(N'tempdb..#userList', N'U') IS NOT NULL
	DROP TABLE #userList;
CREATE TABLE #userList (userId int PRIMARY KEY);
--
INSERT INTO #userList (userId)
SELECT CO.userId
FROM sec_getClientOwnersWithParam(@clientId, 0, 0) CO
WHERE CO.userId IN
(SELECT U.id
	FROM UMUsers U WITH (NOLOCK)
WHERE U.flags & 0x001 <> 0 AND U.flags & 0x004 = 0 AND U.enabled <> 0); -- only enabled, non-deleted, non-hidden users
BEGIN TRANSACTION
SET @transStarted = 1
IF @inCheckQuotaLimit = 1
BEGIN
	DECLARE @i_getIndexingVersion XML
	DECLARE @o_getIndexingVersion XML
	SET @i_getIndexingVersion = N'<Indexing_GetIndexingVersionReq backupsetId = "'+CONVERT(varchar(10), @inBackupSetId) + '" appTypeOverride= "' +CONVERT(varchar(10), @apptype) +'"/>'
	EXEC dbo.AppGetIndexingVersionForThisClient @i_getIndexingVersion , @o_getIndexingVersion OUTPUT
	IF ( @o_getIndexingVersion.value('(/Indexing_GetIndexingVersionResp/@indexingVersionId)[1]','int') = 2  )
		SELECT @isClientIndxVersion2 = 1
	IF OBJECT_ID(N'tempdb..#usageData', N'U') IS NOT NULL
	DROP TABLE #usageData;
	--
	CREATE TABLE #usageData(userId INT, quotaLimit bigint,	quotaUsed bigint);
	CREATE CLUSTERED INDEX usageData_quotaLimit_Idx ON #usageData (quotaLimit)
	INSERT INTO #usageData
	SELECT  userId, ISNULL([FSQuotaLimit], 0), ISNULL([FSQuotaUsage], 0)
	FROM
		(
			SELECT A.userId, attrName, CAST(attrVal AS BIGINT) AS attrVal
			FROM #userList A JOIN UMUsersProp UP WITH (NOLOCK) ON A.userId = UP.componentNameId
WHERE attrName = 'FSQuotaLimit' AND cs_attrName = CHECKSUM(N'FSQuotaLimit')
			UNION
			SELECT A.userId, attrName, CAST(attrVal AS BIGINT) AS attrVal
			FROM #userList A JOIN UMUsersProp UP WITH (NOLOCK) ON A.userId = UP.componentNameId
WHERE attrName = 'FSQuotaUsage' AND cs_attrName = CHECKSUM(N'FSQuotaUsage')
		) as T
	PIVOT ( MAX(attrVal) FOR attrName IN ( [FSQuotaLimit], [FSQuotaUsage]) ) AS P
	IF NOT EXISTS (SELECT * FROM #usageData U WHERE U.quotaLimit = 0)
		SELECT @quotaRemaining = MAX(quotaLimit - quotaUsed) FROM #usageData
	IF @isClientIndxVersion2 = 1
	BEGIN
		--This code will replace UpdateQuotaAndFailJobIfExceeds
		SELECT @oldQuotaUsage = CAST(attrVal AS BIGINT) FROM APP_BackupSetProp WITH (NOLOCK)
		WHERE componentNameId = @inBackupSetId AND attrName = @quotaUsageAttrName AND modified = 0
		IF @updateType = 0 --Absolute
		BEGIN
			SET @deltaUsage = @inSpaceConsumed - @oldQuotaUsage
		END
		ELSE        --Differential
		BEGIN
			SET @deltaUsage = @inSpaceConsumed
		END
		-- check if client will exceed its effective quota limit if we update backupset usage
		IF @quotaRemaining > 0 AND @deltaUsage > (@quotaRemaining * 110 / 100)
		BEGIN
			-- update the job option table for running job. job manager will query the job option to log event.
			SELECT @jobId=jobId, @ccId=commcellId FROM JMBkpJobInfo WITH (NOLOCK) WHERE applicationId = @inAppId;
			IF @jobId > 0
			BEGIN
INSERT INTO JMJobOptions VALUES (@jobId, @ccId, 51, N'Current Quota Space Consumed', @inSpaceConsumed, '')
			END
			--
			SET @errorCode = 2
			SELECT @errorCode AS N'@errorCode', N'Client is above quota limit.' AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE;
			GOTO SP_EXIT
		END
		UPDATE APP_BackupSetProp SET attrVal =
		CASE WHEN (CAST(attrVal AS bigint) + @deltaUsage) < 0 THEN 0
			ELSE CAST((CAST(attrVal AS bigint) + @deltaUsage) AS nvarchar(max))	END
		WHERE componentNameId = @inBackupSetId AND attrName = @quotaUsageAttrName AND modified = 0;
		IF @@rowcount = 0
		BEGIN
			INSERT INTO APP_BackupSetProp(attrName, attrType, attrVal, ccpId, componentNameId, created, modified)
			VALUES( @quotaUsageAttrName, 14 /* PROPERTY_64LONG */, CAST(@deltaUsage AS nvarchar(max)),
			0, @inBackupSetId, @currentTime, 0);
		END
	END
	ELSE
	BEGIN
	--This is for indexing V1 clients. Here we update only at subclient level
		SELECT @oldQuotaUsage = CAST(attrVal AS BIGINT) FROM APP_SubClientProp WITH (NOLOCK)
		WHERE componentNameId = @inAppId AND attrName = @quotaUsageAttrName AND modified = 0
		IF @updateType = 0 --Absolute
		BEGIN
			SET @deltaUsage = @inSpaceConsumed - @oldQuotaUsage
		END
		ELSE        --Differential
		BEGIN
			SET @deltaUsage = @inSpaceConsumed
		END
		-- check if client will exceed its effective quota limit if we update subclient space usage
		-- not sure if we need to add condition @updateType = 0 as in original SP
		IF @quotaRemaining > 0 AND @deltaUsage > (@quotaRemaining * 110 / 100)
		BEGIN
			--
			-- update the job option table for running job. job manager will query the job option to log event.
			SELECT @jobId=jobId, @ccId=commcellId FROM JMBkpJobInfo WITH (NOLOCK) WHERE applicationId = @inAppId;
			IF @jobId > 0
			BEGIN
INSERT INTO JMJobOptions VALUES (@jobId, @ccId, 51, N'Current Quota Space Consumed', @inSpaceConsumed, '')
			END
			--
			SET @errorCode = 2
			SELECT @outputXML = (SELECT @errorCode AS N'@errorCode', N'Client is above quota limit.' AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
			GOTO SP_EXIT
		END
		UPDATE APP_SubClientProp SET attrVal =
		CASE WHEN (CAST(attrVal AS bigint) + @deltaUsage) < 0 THEN 0
			ELSE CAST((CAST(attrVal AS bigint) + @deltaUsage) AS nvarchar(max))	END
		WHERE componentNameId = @inAppId AND attrName = @quotaUsageAttrName AND modified = 0;
		IF @@rowcount = 0
		BEGIN
			INSERT INTO APP_SubClientProp(attrName, attrType, attrVal, ccpId, componentNameId, created, modified)
			VALUES( @quotaUsageAttrName, 14 /* PROPERTY_64LONG */, CAST(@deltaUsage AS nvarchar(max)),
			0, @inAppId, @currentTime, 0);
		END
	END
END
--Update the Quota usage for each user
UPDATE UMUsersProp SET attrVal = CAST(attrVal AS bigint) + @deltaUsage
FROM #userList WHERE componentNameId = userId and attrName = 'FSQuotaUsage'
-- return success response
SELECT @outputXML = (SELECT 0 AS N'@errorCode', NULL AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
END TRY
BEGIN CATCH
    IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
	SELECT @outputXML = (SELECT @errorCode AS N'@errorCode', @errorString AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
END CATCH
SP_EXIT:
IF OBJECT_ID(N'tempdb..#userList', N'U') IS NOT NULL DROP TABLE #userList;
IF @errorCode = 0 AND @transStarted = 1
    BEGIN
        COMMIT TRANSACTION
    END
    ELSE IF @transStarted = 1
	BEGIN
        ROLLBACK TRANSACTION
	END
	IF OBJECT_ID(N'tempdb..#usageDataXML', N'U') IS NOT NULL
		INSERT INTO #usageDataXML (usage) VALUES (@outputXML);
	ELSE
		SELECT @outputXML;
IF OBJECT_ID(N'tempdb..#usageData', N'U') IS NOT NULL DROP TABLE #usageData;
IF OBJECT_ID(N'tempdb..#userList', N'U') IS NOT NULL DROP TABLE #userList;
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CheckQuotaLimit')
	delete from GxQscripts where name = 'CheckQuotaLimit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CheckQuotaLimit')
	delete from GXDBVersions where aliasname = 'CheckQuotaLimit'
GO

insert into GXDBVersions values(2, 'CheckQuotaLimit',  '00010001000200020000', 'CheckQuotaLimit', '00010001000200020000')
GO

