

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CheckAndUpdateQuotaLimit.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   11/14/2017
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CheckAndUpdateQuotaLimit.sp,v $ $Id: CheckAndUpdateQuotaLimit.sp,v 1.1.2.5 2020/12/17 22:43:14 sbhukar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CheckAndUpdateQuotaLimit')
BEGIN
	print '>>> Drop Stored Procedure: CheckAndUpdateQuotaLimit <<<'
	drop procedure CheckAndUpdateQuotaLimit
END
IF EXISTS (select * from GxQscripts where name='CheckAndUpdateQuotaLimit')
	delete from GxQscripts where name = 'CheckAndUpdateQuotaLimit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CheckAndUpdateQuotaLimit')
	delete from GXDBVersions where aliasname = 'CheckAndUpdateQuotaLimit'
GO
print '... Creating Procedure: CheckAndUpdateQuotaLimit'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CheckAndUpdateQuotaLimit
  @inputXML XML OUTPUT
AS
DECLARE @outputXML XML
DECLARE @clientId INT
DECLARE @deltaUsage BIGINT = 0
DECLARE @updateType INT = 0
DECLARE @inAppId INT = 0
DECLARE @inSpaceConsumed BIGINT = 0
DECLARE @inBackupSetGUID UNIQUEIDENTIFIER = NULL
DECLARE @inBackupSetId INT = 0
DECLARE @inCheckAndUpdateQuotaLimit INT = 0
DECLARE @apptype INT = 0
DECLARE @isClientIndxVersion2 INT = 0
DECLARE @oldQuotaUsage BIGINT = 0
DECLARE @currentQuotaUsage BIGINT = 0
DECLARE @quotaUsageAttrName nvarchar(64) = N'Application Size'
DECLARE @maxBigIntValue BIGINT = 9223372036854775807
DECLARE @quotaRemaining BIGINT = @maxBigIntValue
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = ''
DECLARE @isFsBackuptSetUsage INT = 0
DECLARE @jobId INT = 0;
DECLARE @ccId INT = 0;
DECLARE @currentTime INT = dbo.GetUnixTime(GetUTCDate())
DECLARE @transStarted INT = 0
BEGIN TRY
SELECT @updateType = N.value(N'@updateType', N'INT'),
		@inAppId = N.value(N'@appId', N'INT'),
		@inSpaceConsumed = N.value(N'@spaceConsumed', N'BIGINT'),
		@inBackupSetGUID = N.value(N'@backupSetGuid', N'UNIQUEIDENTIFIER'),
		@deltaUsage = N.value(N'@deltaUsage', N'BIGINT'),
		@inCheckAndUpdateQuotaLimit = N.value(N'@checkQuotaLimit', N'INT')
FROM
@inputXML.nodes (N'App_FSQuotaUsage') AS T(N);
IF @inBackupSetGUID IS NOT NULL
	SELECT @inBackupSetId = B.id FROM APP_BackupSetName B WITH (NOLOCK) WHERE B.GUID =  @inBackupSetGUID
ELSE IF @inAppId IS NOT NULL AND @inAppId > 0
	SELECT @inBackupSetId = backupSet FROM APP_Application WITH (NOLOCK) WHERE id = @inAppId
IF @inBackupSetId IS NULL OR @inBackupSetId = 0
BEGIN
	SELECT @errorString = N'No such backupset exists. ' + Convert(NVARCHAR(MAX), @inputXML)
    RAISERROR(@errorString, 16, 1);
END
SELECT TOP 1 @apptype = appTypeId, @clientId = A.clientId FROM APP_Application A WITH (NOLOCK) WHERE A.backupSet = @inBackupSetId;
-- get list of users for this client
IF OBJECT_ID(N'tempdb..#userList', N'U') IS NOT NULL
	DROP TABLE #userList;
CREATE TABLE #userList (userId int PRIMARY KEY);
--
INSERT INTO #userList (userId)
SELECT CO.userId
FROM sec_getClientOwnersWithParam(@clientId, 0, 0) CO
WHERE CO.userId IN
(SELECT U.id
	FROM UMUsers U WITH (NOLOCK)
WHERE U.flags & 0x001 <> 0 AND U.flags & 0x004 = 0 AND U.enabled <> 0); -- only enabled, non-deleted, non-hidden users
BEGIN TRANSACTION
SET @transStarted = 1
IF @inCheckAndUpdateQuotaLimit = 1
BEGIN
	DECLARE @i_getIndexingVersion XML
	DECLARE @o_getIndexingVersion XML
	SET @i_getIndexingVersion = N'<Indexing_GetIndexingVersionReq backupsetId = "'+CONVERT(varchar(10), @inBackupSetId) + '" appTypeOverride= "' +CONVERT(varchar(10), @apptype) +'"/>'
	EXEC dbo.AppGetIndexingVersionForThisClient @i_getIndexingVersion , @o_getIndexingVersion OUTPUT
	IF ( @o_getIndexingVersion.value('(/Indexing_GetIndexingVersionResp/@indexingVersionId)[1]','int') = 2  )
		SELECT @isClientIndxVersion2 = 1
	IF OBJECT_ID(N'tempdb..#usageData', N'U') IS NOT NULL
	DROP TABLE #usageData;
	--
	CREATE TABLE #usageData(userId INT, quotaLimit bigint,	quotaUsed bigint);
	CREATE CLUSTERED INDEX usageData_quotaLimit_Idx ON #usageData (quotaLimit)
	INSERT INTO #usageData
	SELECT  userId, ISNULL([FSQuotaLimit], 0), ISNULL([FSQuotaUsage], 0)
	FROM
		(
			SELECT A.userId, attrName, CAST(attrVal AS BIGINT) AS attrVal
			FROM #userList A JOIN UMUsersProp UP WITH (NOLOCK) ON A.userId = UP.componentNameId
WHERE attrName = 'FSQuotaLimit' AND cs_attrName = CHECKSUM(N'FSQuotaLimit')
			UNION
			SELECT A.userId, attrName, CAST(attrVal AS BIGINT) AS attrVal
			FROM #userList A JOIN UMUsersProp UP WITH (NOLOCK) ON A.userId = UP.componentNameId
WHERE attrName = 'FSQuotaUsage' AND cs_attrName = CHECKSUM(N'FSQuotaUsage')
		) as T
	PIVOT ( MAX(attrVal) FOR attrName IN ( [FSQuotaLimit], [FSQuotaUsage]) ) AS P
	IF NOT EXISTS (SELECT * FROM #usageData U WHERE U.quotaLimit = 0)
		SELECT @quotaRemaining = MAX(quotaLimit - quotaUsed) FROM #usageData
	IF @isClientIndxVersion2 = 1
	BEGIN
		--This code will replace UpdateQuotaAndFailJobIfExceeds
		--We need to take UPDLOCK or XLock on APP_BackupSetProp as no other thread should be able to read the value until we update the delta change in UMUsersProp.
		SELECT @oldQuotaUsage = CAST(attrVal AS BIGINT) FROM APP_BackupSetProp WITH (UPDLOCK)
		WHERE componentNameId = @inBackupSetId AND attrName = @quotaUsageAttrName AND modified = 0
		IF @updateType = 0 --Absolute
		BEGIN
			SET @deltaUsage = @inSpaceConsumed - @oldQuotaUsage
		END
		ELSE        --Differential
		BEGIN
			SET @deltaUsage = @inSpaceConsumed
		END
		-- check if client will exceed its effective quota limit if we update backupset usage
		IF @quotaRemaining <> @maxBigIntValue AND @deltaUsage > (@quotaRemaining * 110 / 100)
		BEGIN
			-- update the job option table for running job. job manager will query the job option to log event.
			SELECT @jobId=jobId, @ccId=commcellId FROM JMBkpJobInfo WITH (NOLOCK) WHERE applicationId = @inAppId;
			IF @jobId > 0
			BEGIN
INSERT INTO JMJobOptions VALUES (@jobId, @ccId, 51, N'Current Quota Space Consumed', @inSpaceConsumed, '')
			END
			--
			SET @errorCode = 2
			SELECT @outputXML = (SELECT @errorCode AS N'@errorCode', N'Client is above quota limit.' AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
			GOTO SP_EXIT
		END
		MERGE APP_BackupSetProp AS T
		USING (SELECT TOP 1 componentNameId FROM APP_BackupSetProp WHERE componentNameId = @inBackupSetId ) AS S
		ON T.componentNameId = S.componentNameId AND T.attrName = @quotaUsageAttrName AND T.modified = 0
		WHEN MATCHED AND @deltaUsage <> 0 -- Only update row if quota usage changed
			THEN UPDATE SET T.attrVal =
			CASE WHEN (CAST(T.attrVal AS bigint) + @deltaUsage) < 0 THEN N'0'
				ELSE ( CAST((CAST(T.attrVal AS bigint) + @deltaUsage) AS NVARCHAR(MAX)) ) END
		WHEN NOT MATCHED
			THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@inBackupSetId, @quotaUsageAttrName, 14, CAST(@deltaUsage AS nvarchar(max)), @currentTime, 0, 0)
		;
	END
	ELSE
	BEGIN
		--This is for indexing V1 clients. Here we update only at subclient level
		--We need to take UPDLOCK or XLock on APP_SubClientProp as no other thread should be able to read the value until we update the delta change in UMUsersProp.
		SELECT @oldQuotaUsage = CAST(attrVal AS BIGINT) FROM APP_SubClientProp WITH (UPDLOCK)
		WHERE componentNameId = @inAppId AND attrName = @quotaUsageAttrName AND modified = 0
		IF @updateType = 0 --Absolute
		BEGIN
			SET @deltaUsage = @inSpaceConsumed - @oldQuotaUsage
		END
		ELSE        --Differential
		BEGIN
			SET @deltaUsage = @inSpaceConsumed
		END
		-- check if client will exceed its effective quota limit if we update subclient space usage
		IF @quotaRemaining <> @maxBigIntValue AND @deltaUsage > (@quotaRemaining * 110 / 100)
		BEGIN
			--
			-- update the job option table for running job. job manager will query the job option to log event.
			SELECT @jobId=jobId, @ccId=commcellId FROM JMBkpJobInfo WITH (NOLOCK) WHERE applicationId = @inAppId;
			IF @jobId > 0
			BEGIN
INSERT INTO JMJobOptions VALUES (@jobId, @ccId, 51, N'Current Quota Space Consumed', @inSpaceConsumed, '')
			END
			--
			SET @errorCode = 2
			SELECT @outputXML = (SELECT @errorCode AS N'@errorCode', N'Client is above quota limit.' AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
			GOTO SP_EXIT
		END
		MERGE APP_SubClientProp AS T
		USING (SELECT TOP 1 componentNameId FROM APP_SubClientProp WHERE componentNameId = @inAppId ) AS S
		ON T.componentNameId = S.componentNameId AND T.attrName = @quotaUsageAttrName AND T.modified = 0
		WHEN MATCHED AND @deltaUsage <> 0 -- Only update row if quota usage changed
			THEN UPDATE SET T.attrVal =
			CASE WHEN (CAST(T.attrVal AS bigint) + @deltaUsage) < 0 THEN N'0'
				ELSE ( CAST((CAST(T.attrVal AS bigint) + @deltaUsage) AS NVARCHAR(MAX)) ) END
		WHEN NOT MATCHED
			THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES(@inAppId, @quotaUsageAttrName, 14, CAST(@deltaUsage AS nvarchar(max)), @currentTime, 0, 0)
		;
	END
END
--Update the Quota usage for each user
IF @deltaUsage <> 0 -- Only update row if quota usage changed
	UPDATE UMUsersProp SET attrVal =
					CASE WHEN (CAST(attrVal AS bigint) + @deltaUsage) < 0 THEN N'0'
					ELSE (CAST((CAST(attrVal AS bigint) + @deltaUsage) AS NVARCHAR(MAX))) END
FROM #userList WHERE componentNameId = userId and attrName = 'FSQuotaUsage'
-- return success response
SELECT @outputXML = (SELECT 0 AS N'@errorCode', NULL AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
END TRY
BEGIN CATCH
    IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
	SELECT @outputXML = (SELECT @errorCode AS N'@errorCode', @errorString AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
END CATCH
SP_EXIT:
IF OBJECT_ID(N'tempdb..#userList', N'U') IS NOT NULL DROP TABLE #userList;
IF @errorCode = 0 AND @transStarted = 1
    BEGIN
        COMMIT TRANSACTION
    END
    ELSE IF @transStarted = 1
	BEGIN
        ROLLBACK TRANSACTION
	END
	IF OBJECT_ID(N'tempdb..#usageDataXML', N'U') IS NOT NULL
		INSERT INTO #usageDataXML (usage) VALUES (@outputXML);
	ELSE
		SELECT @inputXML = @outputXML;
IF OBJECT_ID(N'tempdb..#usageData', N'U') IS NOT NULL DROP TABLE #usageData;
IF OBJECT_ID(N'tempdb..#userList', N'U') IS NOT NULL DROP TABLE #userList;
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CheckAndUpdateQuotaLimit')
	delete from GxQscripts where name = 'CheckAndUpdateQuotaLimit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CheckAndUpdateQuotaLimit')
	delete from GXDBVersions where aliasname = 'CheckAndUpdateQuotaLimit'
GO

insert into GXDBVersions values(2, 'CheckAndUpdateQuotaLimit',  '00010001000200050000', 'CheckAndUpdateQuotaLimit', '00010001000200050000')
GO

