

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ChangeClientGUIDforVirtualClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ChangeClientGUIDforVirtualClient.sp,v $ $Id: ChangeClientGUIDforVirtualClient.sp,v 1.7.58.5 2020/09/28 21:27:36 scheppuri Exp $";
--
--  +========================================================================+
--  |   Procedure:  ChangeClientGUIDforVirtualClient()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output: Change client GUID for virtual client to match the vm guid
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Bhushan Kharabe   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ChangeClientGUIDforVirtualClient')
BEGIN
	print '>>> Drop Stored Procedure: ChangeClientGUIDforVirtualClient <<<'
	drop procedure ChangeClientGUIDforVirtualClient
END
IF EXISTS (select * from GxQscripts where name='ChangeClientGUIDforVirtualClient')
	delete from GxQscripts where name = 'ChangeClientGUIDforVirtualClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ChangeClientGUIDforVirtualClient')
	delete from GXDBVersions where aliasname = 'ChangeClientGUIDforVirtualClient'
GO
print '... Creating Procedure: ChangeClientGUIDforVirtualClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ChangeClientGUIDforVirtualClient
  @input xml
AS
SET NOCOUNT ON
BEGIN
	IF object_id('tempdb.dbo.#tmpClientList') IS NOT null DROP TABLE #tmpClientList
	create table #tmpClientList(
					id					int IDENTITY(1,1) NOT NULL,
					vmguid				nvarchar(255),
					instanceUUID		nvarchar(255),
					clientguid			nvarchar(64),
					clientid			int,
					spflags				int,
					guidconflict		int
					)
	INSERT INTO #tmpClientList
	SELECT T.cc.value('clientProps[1]/@vmguid', 'nvarchar(255)') as vmguid,
		null,
		null, 0, 0,0
	FROM @input.nodes('/CVInstallManager_ClientSetup/clientComposition/clientInfo') T(cc)
	UPDATE #tmpClientList
	set instanceUUID = (CASE CHARINDEX(',',vmguid) WHEN
                                   0 THEN null
			ELSE SUBSTRING(vmguid, CHARINDEX(',',vmguid) + 1, len(vmguid))
			END	)
	UPDATE #tmpClientList
	set vmguid = CASE WHEN CHARINDEX(',',vmguid) >0
                                 THEN SUBSTRING(vmguid,1, CHARINDEX(',',vmguid) - 1)
								 ELSE vmguid END
	update #tmpClientList
	set clientguid = C.GUID,
		clientid = C.id,
		spflags = specialClientFlags
	FROM #tmpClientList tmp,
	APP_Client as C, APP_ClientProp as CP
		where C.id = CP.componentNameId and CP.attrName = 'Virtual Machine Instance UUID' and CP.attrVal = tmp.instanceUUID and CP.modified=0
	update #tmpClientList
	set clientguid = C.GUID,
		clientid = C.id,
		spflags = specialClientFlags
	FROM #tmpClientList tmp,
	APP_Client as C, APP_ClientProp as CP
		where C.id = CP.componentNameId and CP.attrName = 'Virtual Machine GUID' and CP.attrVal = tmp.vmguid
		and tmp.clientid = 0
	update #tmpClientList
	set instanceUUID = vmguid
	where instanceUUID is null
	update tmp set guidconflict=1 from #tmpClientList tmp where exists(select 1 from app_client cl where CAST(cl.GUID AS nvarchar(256))=tmp.instanceUUID  and cl.id <> tmp.clientid)
	update	APP_Client
	set		GUID = tt.instanceUUID
	FROM	#tmpClientList tt, APP_Client C
	where	C.id = tt.clientid and ((tt.spflags & 2) = 2) and tt.clientguid <> ISNULL( tt.instanceUUID, tt.vmguid )
			and dbo.IsGUID(tt.instanceUUID) = 1
and (tt.spflags & 0x20 = 0) and tt.guidconflict <> 1
	update	APP_ClientProp
	set		attrVal = tt.clientguid
	from	#tmpClientList tt
				join APP_ClientProp prop
					on tt.clientid = prop.componentNameId and prop.attrName = 'Virtual Machine GUID'
	where ((tt.spflags & 2) = 2) and tt.clientguid <> tt.instanceUUID
			and dbo.IsGUID(tt.instanceUUID) <> 1
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ChangeClientGUIDforVirtualClient')
	delete from GxQscripts where name = 'ChangeClientGUIDforVirtualClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ChangeClientGUIDforVirtualClient')
	delete from GXDBVersions where aliasname = 'ChangeClientGUIDforVirtualClient'
GO

insert into GXDBVersions values(2, 'ChangeClientGUIDforVirtualClient',  '00010007005800050000', 'ChangeClientGUIDforVirtualClient', '00010007005800050000')
GO

