

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CaptureTempdbDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CaptureTempdbDetails.sp,v $ $Id: CaptureTempdbDetails.sp,v 1.1.2.5 2020/07/06 22:15:14 mnatarajan Exp $";
--
--  +========================================================================+
--  | Stored Precedure: CaptureTempdbDetails
--  |
--  | Description:
--  |  Capture DB info for TempDb Growth
--  |
--  |   Revisions  Author				Description
--  |   ---------  --------------		---------------------------------------------
--  |   1.0        rsivadas				Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CaptureTempdbDetails')
BEGIN
	print '>>> Drop Stored Procedure: CaptureTempdbDetails <<<'
	drop procedure CaptureTempdbDetails
END
IF EXISTS (select * from GxQscripts where name='CaptureTempdbDetails')
	delete from GxQscripts where name = 'CaptureTempdbDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CaptureTempdbDetails')
	delete from GXDBVersions where aliasname = 'CaptureTempdbDetails'
GO
print '... Creating Procedure: CaptureTempdbDetails'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CaptureTempdbDetails
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @update_interval INTEGER = 15
DECLARE @date_update_last_x_mins BIT = 0
DECLARE @current_date DATETIME = getDate()
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isOsWindows BIT = dbo.IsOSOnCSWindows()
DECLARE @errorMessage NVARCHAR(MAX) = ''
IF DB_ID('Troubleshooting') IS NOT NULL
BEGIN
	--If the Table does not exist, create it
	IF OBJECT_ID('TroubleShooting..TempDb_Monitor') IS NULL
	BEGIN
		DECLARE @SqlQuery VARCHAR(MAX) = 'CREATE TABLE TroubleShooting..Tempdb_Monitor (
			[Id] [int] IDENTITY(1, 1) NOT NULL
			,[XMLInfo] [xml] NULL
			,[DateInserted] [datetime] NULL DEFAULT(@current_date)
			) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]'
		EXEC (@SqlQuery)
	END
	-- If the table exist and has rows Prune table to maintain no more than 100 rows.
	IF EXISTS (
			SELECT abs(datediff(mi, @current_date, DateInserted))
				,DateInserted
			FROM TroubleShooting..Tempdb_Monitor(NOLOCK)
			WHERE abs(datediff(mi, @current_date, DateInserted)) < @update_interval
			)
	BEGIN
		;WITH CTE
		AS (
			SELECT TOP 100 PERCENT RANK() OVER (
					ORDER BY ID DESC
					) Ordr
				,ID
			FROM TroubleShooting..Tempdb_Monitor
			ORDER BY ID ASC
			)
		DELETE
		FROM CTE
		WHERE Ordr > 100
		SET @date_update_last_x_mins = 1
	END
END
IF @date_update_last_x_mins = 0
BEGIN
	DECLARE @tempDb_Monitor XML = (
			SELECT (
					SELECT (
							SELECT SUM(unallocated_extent_page_count) '@freepages'
								,(SUM(unallocated_extent_page_count) * 1.0 / 128) '@freespaceinMB'
								,(SUM(isnull(versiON_store_reserved_page_count, 0)) * 1.0 / 128) '@VersionstoreinMB'
								,(SUM(isnull(internal_object_reserved_page_count, 0)) * 1.0 / 128) '@InternaluseinMB'
								,(
									SELECT file_id '@fileId'
										,NAME '@deviceName'
										,((size * 8) / 1024) '@usedSpaceMB'
										,physical_name '@filename'
									FROM tempdb.sys.database_files(NOLOCK)
									FOR XML PATH('File')
										,TYPE
									)
							FROM tempdb.sys.dm_db_file_space_usage(NOLOCK)
							FOR XML PATH('TempDb')
								,type
							)
						,(
							SELECT TOP 10 t.NAME '@TableName'
								,s.row_count '@Rowcount'
								,SUM(used_page_count) '@Used_pages'
								,SUM(used_page_count) * 8 '@Used_space_KB'
							FROM tempdb.sys.dm_db_partition_stats AS s(NOLOCK)
							INNER JOIN tempdb.sys.tables AS t(NOLOCK) ON s.object_id = t.object_id
							WHERE s.index_id < 2
							GROUP BY t.NAME
								,s.row_count
							ORDER BY '@Used_space_KB' DESC
							FOR XML PATH('LargeUDTintempdb')
								,ROOT('LargeUDTList')
								,type
							)
						,(
							SELECT dtsu.session_id '@sessionid'
								,round(convert(FLOAT, (dtsu.user_objects_alloc_page_count + dtsu.internal_objects_alloc_page_count)), 2) '@TaskGrossPageallocated'
								,round(convert(FLOAT, (dtsu.user_objects_alloc_page_count - dtsu.user_objects_dealloc_page_count) * 8) / 1024.0, 2) '@NET_TaskUsrSpaceallocinMB'
								,round(convert(FLOAT, (dsuu.user_objects_alloc_page_count - dsuu.user_objects_dealloc_page_count) * 8) / 1024.0, 2) '@NET_sessionUsrSpaceallocinMB'
								,dtsu.request_id '@requestid'
								,es.host_name '@hostname'
								,es.program_name '@program'
								,dtsu.user_objects_alloc_page_count '@TaskuserPageallocate'
								,dtsu.user_objects_dealloc_page_count '@TaskuserPagedealloc'
								,dsuu.user_objects_alloc_page_count '@sessionuserPagealloc'
								,dsuu.user_objects_dealloc_page_count '@sessionuserPagedealloc'
								,trandetails.database_transaction_begin_time '@transaction_Begintime'
								,(
									SELECT dest.TEXT
									FOR XML PATH('SQLText')
										,TYPE
									)
							FROM sys.dm_db_task_space_usage dtsu(NOLOCK)
							INNER JOIN sys.dm_db_session_space_usage dsuu(NOLOCK) ON dtsu.session_id = dsuu.session_id
							INNER JOIN sys.dm_exec_requests der(NOLOCK) ON dtsu.session_id = der.session_id
								AND dtsu.request_id = der.request_id
							INNER JOIN sys.dm_exec_sessions es(NOLOCK) ON der.session_id = es.session_id
								AND es.program_name NOT LIKE 'SQLAgent%'
							LEFT JOIN (
								SELECT des.spid
									,database_transaction_begin_time
									,CASE database_transaction_type
										WHEN 1
											THEN 'Read/Write'
										WHEN 2
											THEN 'Read-ONly'
										WHEN 3
											THEN 'System'
										ELSE 'Unknown - ' + convert(VARCHAR(20), database_transaction_type)
										END AS 'Tran Type'
									,CASE database_transaction_state
										WHEN 1
											THEN 'Uninitialized'
										WHEN 3
											THEN 'No Log Records'
										WHEN 4
											THEN 'Log Records'
										WHEN 5
											THEN 'Prepared'
										WHEN 10
											THEN 'Committed'
										WHEN 11
											THEN 'Rolled Back'
										WHEN 12
											THEN 'Committing'
										ELSE 'Unknown - ' + convert(VARCHAR(20), database_transaction_state)
										END AS 'Tran State'
									,open_transaction_count
									,blocked
									,[program_name] Program
									,sum(database_transaction_log_record_count) LogRecordCount
									,round(sum(database_transaction_log_bytes_used) * 1024, 2) sesiON_LogBytes_KB
									,sql_handle
								FROM sys.dm_tran_active_transactions(NOLOCK) dtac
								INNER JOIN sys.dm_tran_database_transactions(NOLOCK) dtdt ON dtac.transaction_id = dtdt.transaction_id
								INNER JOIN sys.dm_tran_session_transactions dtst(NOLOCK) ON dtac.transaction_id = dtst.transaction_id
								LEFT JOIN sys.sysprocesses des(NOLOCK) ON dtst.session_id = des.spid
								GROUP BY des.spid
									,dtac.NAME
									,database_transaction_begin_time
									,database_transaction_type
									,database_transaction_state
									,open_transaction_count
									,blocked
									,[program_name]
									,des.sql_handle
								) AS trandetails ON es.session_id = trandetails.spid
							CROSS APPLY sys.dm_exec_sql_text(coalesce(der.sql_handle, trandetails.sql_handle)) dest
							WHERE dtsu.user_objects_alloc_page_count > 0
								OR dtsu.internal_objects_alloc_page_count > 0
							ORDER BY '@TaskGrossPageallocated' DESC
								,'@NET_TaskUsrSpaceallocinMB' DESC
							FOR XML PATH('Top10TaskSpaceUsage')
								,ROOT('Top10List')
								,type
							)
						,(
							SELECT TOP 10 der.session_id '@session_id'
								,des.host_name '@hostname'
								,des.login_name '@login_name'
								,Db_name(der.database_id) '@dbname'
								,der.STATUS '@Status'
								,der.command '@Command'
								,RIGHT('0' + CAST(((DATEDIFF(s, start_time, @current_date)) / 3600) AS VARCHAR), 2) + ':' + RIGHT('0' + CAST((DATEDIFF(s, start_time, @current_date) % 3600) / 60 AS VARCHAR), 2) + ':' + RIGHT('0' + CAST((DATEDIFF(s, start_time, @current_date) % 60) AS VARCHAR), 2) '@Total_RunTime'
								,start_time '@StartTime'
								,dateadd(second, estimated_completiON_time / 1000, @current_date) '@est_completiON_time'
								,percent_complete '@percent_complete'
								,der.cpu_time '@CPUCONsumed'
								,der.blocking_session_id '@Blocker'
								,der.wait_time '@WaitTime'
								,der.open_transaction_count '@OpenTrans'
								,CAST(ROUND((der.granted_query_memory / 128.0) / 1024, 2) AS NUMERIC(10, 2)) '@Query_Memory_Grant_MB'
								,(
									SELECT SUBSTRING(s.TEXT, der.statement_start_offset / 2, (
												CASE
													WHEN der.statement_end_offset = - 1
														THEN LEN(convert(NVARCHAR(MAX), s.TEXT)) * 2
													ELSE der.statement_end_offset
													END - der.statement_start_offset
												) / 2)
									FOR XML PATH('SQLText')
										,TYPE
									)
							FROM sys.dm_exec_requests der(NOLOCK)
							INNER JOIN sys.dm_exec_sessions des WITH (NOLOCK) ON der.session_id = des.session_id
							CROSS APPLY sys.dm_exec_sql_text(der.sql_handle) s
							WHERE der.session_id <> @@SPID
								AND des.is_user_process = 1
								AND program_name NOT LIKE 'SQLAgent%'
								AND Des.STATUS NOT IN (
									'BACKGROUND'
									,'SLEEPING'
									)
							ORDER BY der.CPU_Time DESC
								,DATEDIFF(s, start_time, @current_date) DESC
							FOR XML PATH('Top10ActiveQueries')
								,type
							)
					FOR XML PATH('TempdbAllocation')
						,TYPE
					)
			)
	IF DB_ID('Troubleshooting') IS NOT NULL
	BEGIN
		IF EXISTS (
				SELECT *
				FROM TroubleShooting..sysobjects
				WHERE NAME LIKE '%TempDb_Monitor%'
				)
		BEGIN
			INSERT TroubleShooting..Tempdb_Monitor (XmlInfo)
			SELECT @tempDb_Monitor
		END
	END
	ELSE
	BEGIN
		DECLARE @filePath AS VARCHAR(1024)
		SELECT TOP 1 @filePath = install_dir
		FROM APP_Platform
		WHERE platformType = 1
		SET @filePath = @filePath + '\Base\Temp\TempDb_Monitor_' + convert(VARCHAR(30), @current_date, 112) + '_' + replace(convert(VARCHAR(30), @current_date, 108), ':', '') + '.xml';
		DECLARE @RetCode INT = 0
			,@FileSystem INT = 0
			,@FileHandle INT = 0;
		IF @isOsWindows = 1
		BEGIN
			EXECUTE @RetCode = sp_OACreate 'Scripting.FileSystemObject'
				,@FileSystem OUTPUT
			IF NOT (
					@@ERROR != 0
					OR @RetCode != 0
					OR @FileSystem < 0
					)
			BEGIN
				EXECUTE @RetCode = sp_OAMethod @FileSystem
					,'OpenTextFile'
					,@FileHandle OUTPUT
					,@filePath
					,2
					,1
				EXECUTE @RetCode = sp_OAMethod @FileHandle
					,'WriteLine'
					,NULL
					,@tempDb_Monitor
				EXECUTE @RetCode = sp_OAMethod @FileHandle
					,'Close'
					,NULL
			END
		END
		ELSE
		BEGIN
			DECLARE @tempDb_MonitorString NVARCHAR(MAX)
			SET @tempDb_MonitorString = CAST(@tempDb_Monitor AS NVARCHAR(MAX) )
			EXECUTE cv_spWriteToFile @filePath , @tempDb_MonitorString, @errorMessage OUTPUT, 1
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'CaptureTempdbDetails')
	delete from GxQscripts where name = 'CaptureTempdbDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CaptureTempdbDetails')
	delete from GXDBVersions where aliasname = 'CaptureTempdbDetails'
GO

insert into GXDBVersions values(2, 'CaptureTempdbDetails',  '00010001000200050000', 'CaptureTempdbDetails', '00010001000200050000')
GO

