

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CV_LogTempDBSizeAndQueries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CV_LogTempDBSizeAndQueries.sp,v $ $Id: CV_LogTempDBSizeAndQueries.sp,v 1.4.80.2 2018/03/20 00:29:38 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_LogTempDBSizeAndQueries <<<'

IF EXISTS (select * from sysobjects where name='CV_LogTempDBSizeAndQueries')
	drop procedure CV_LogTempDBSizeAndQueries
IF EXISTS (select * from GxQscripts where name='CV_LogTempDBSizeAndQueries')
	delete from GxQscripts where name = 'CV_LogTempDBSizeAndQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_LogTempDBSizeAndQueries')
	delete from GXDBVersions where aliasname = 'CV_LogTempDBSizeAndQueries'
GO
print '... Creating Procedure: CV_LogTempDBSizeAndQueries'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_LogTempDBSizeAndQueries
AS
	-- Don't create the tables here:
	-- 1) It's duplication of code.
	-- 2) Latest table creation scripts queries troubleshooting db catalog (sys.columns).
	--		But current context is CSDB. So, difficult to query troubleshooting db catalog here.
	DECLARE @l_temp_sizes TABLE
	(
		name                    sysname,
		db_size                       varchar(13),
		owner                   sysname,
		dbid                    smallint,
		created                       nvarchar(11),
		status                        nvarchar(600),
		compatibility_level tinyint
	)
	IF OBJECT_ID('tempdb.dbo.#InputBuffer') IS NOT null DROP TABLE #InputBuffer
	CREATE TABLE #InputBuffer (
		EventType NVARCHAR(1024),
			Parameters INTEGER,
			EventInfo NVARCHAR(max)
	)
	DECLARE           @l_Growtime datetime
	DECLARE           @l_Cur_DBSize           FLOAT = 0.0
	DECLARE           @l_Prev_DBSize          FLOAT
	INSERT INTO @l_temp_sizes
	execute sp_helpdb
	--Get current DB Size
	select @l_Cur_DBSize =CONVERT(FLOAT ,LTRIM(RTRIM(substring(db_size,0, LEN(db_size)-2))))
	from @l_temp_sizes      where name = 'tempdb'
	SELECT TOP 1 @l_Prev_DBSize = DBSize, @l_Growtime  = growtime FROM troubleshooting..tempDBSize order by growtime desc
	IF (@l_Cur_DBSize > @l_Prev_DBSize)
	BEGIN
		SET @l_Growtime = GETDATE()
		-- get the one with the highest and second highest i/o and log it.
		DECLARE @l_SPID int, @l_SPID2 int, @l_physicalIO int, @l_tempdbusage2 int, @l_maxphysicalIO int
		declare @cpu int, @physical_io bigint, @memusage int
		declare @last_batch datetime, @status varchar(30)
		declare @program_name varchar(128), @hostprocess varchar(10)
		declare @stmt_start int, @stmt_end int
		declare @user_page_alloc_count int, @internal_page_alloc_count int
		declare @sql_handle binary(20)
		select * into #tempdbusage from sys.dm_db_task_space_usage
		select * into #spid from sys.sysprocesses
		SELECT top 1 @l_SPID = spid, @l_physicalIO = physical_io,
				@cpu = cpu, @memusage = memusage, @status = status,
				@program_name = program_name, @hostprocess = hostprocess,
				@user_page_alloc_count = tempdbusage.user_objects_alloc_page_count, @internal_page_alloc_count = tempdbusage.internal_objects_alloc_page_count,
				@stmt_start = stmt_start, @stmt_end = stmt_end,
				@sql_handle = sql_handle, @last_batch  = last_batch
		from
			[#spid] spid
				inner join
			(SELECT TOP 1 session_id, user_objects_alloc_page_count, internal_objects_alloc_page_count FROM #tempdbusage
			ORDER BY (user_objects_alloc_page_count+internal_objects_alloc_page_count) DESC) tempdbusage
				on spid.spid = tempdbusage.session_id
		select top 1 @l_tempdbusage2 = (user_objects_alloc_page_count + internal_objects_alloc_page_count)
		from #tempdbusage tempdbusage
		where tempdbusage.session_id <> @l_SPID
		order by (user_objects_alloc_page_count + internal_objects_alloc_page_count) desc
		-- A little "I told you so" from older logic.
		select @l_maxphysicalIO = max(physical_io) from #spid
		-- get query statement that ran
		DECLARE @cmdString VARCHAR(1024),   @lastInputForSPID nvarchar(max)
		SET @cmdString = 'DBCC INPUTBUFFER(' + CAST(@l_SPID AS CHAR(100)) + ')'
		INSERT #InputBuffer
		EXEC(@cmdString)
		SELECT @lastInputForSPID = EventInfo from #InputBuffer
		-- if last request was a fetch cursor, resolve that into the actual query
		IF EXISTS (SELECT 1 from #InputBuffer WHERE EventInfo like '%FETCH API_CURSOR%')
		BEGIN
				DECLARE @queryForLastCursor NVARCHAR(MAX)
				SET @queryForLastCursor = NULL
				SELECT @queryForLastCursor  = t.text
				FROM sys.dm_exec_cursors (@l_SPID) c
					CROSS APPLY sys.dm_exec_sql_text (c.sql_handle) t
				IF @queryForLastCursor IS NOT NULL
				BEGIN
				SET @lastInputForSPID = @lastInputForSPID  + char(10) + char(13) + 'This corresponds to:'+ char(10)+ char (13)
				SET @lastInputForSPID = @lastInputForSPID  + @queryForLastCursor
				END
		END -- cursor handler
		DECLARE @l_statementtext nvarchar(max), @l_jobid bigint,
		@l_threadid int
		SELECT @l_statementtext  = text
		from sys.dm_exec_sql_text(@sql_handle)
		select @l_jobid = jobId, @l_threadid = threadid
		from commserv..DBLog
		where connectionId = @l_SPID
		DECLARE @l_queryId int
		insert into troubleshooting..tempdbgrowth_queries values (@l_statementtext)
		SET @l_queryId = @@IDENTITY
		IF (@l_queryId is not null)
		BEGIN
				insert into troubleshooting..tempdbgrowth_query_details
				select
				@l_queryId  as queryid,
				QS.[sql_handle] ,
				QS.[statement_start_offset] ,
				QS.[statement_end_offset] ,
				QS.[plan_generation_num] ,
				QS.[plan_handle] ,
				QS.[creation_time] ,
				QS.[last_execution_time] ,
				QS.[execution_count] ,
				QS.[total_worker_time] ,
				QS.[last_worker_time] ,
				QS.[min_worker_time] ,
				QS.[max_worker_time] ,
				QS.[total_physical_reads] ,
				QS.[last_physical_reads] ,
				QS.[min_physical_reads] ,
				QS.[max_physical_reads] ,
				QS.[total_logical_writes] ,
				QS.[last_logical_writes] ,
				QS.[min_logical_writes] ,
				QS.[max_logical_writes] ,
				QS.[total_logical_reads] ,
				QS.[last_logical_reads] ,
				QS.[min_logical_reads] ,
				QS.[max_logical_reads] ,
				QS.[total_clr_time] ,
				QS.[last_clr_time] ,
				QS.[min_clr_time] ,
				QS.[max_clr_time] ,
				QS.[total_elapsed_time] ,
				QS.[last_elapsed_time] ,
				QS.[min_elapsed_time] ,
				QS.[max_elapsed_time] ,
				QS.[query_hash] ,
				QS.[query_plan_hash] ,
				QP.query_plan
				from sys.dm_exec_query_stats QS
					cross apply sys.dm_exec_text_query_plan(QS.plan_handle, QS.statement_start_offset, QS.statement_end_offset) QP
				where sql_handle = @sql_handle
				insert into troubleshooting..tempdbgrowth
				SELECT
					@l_Growtime as Growtime,
					@l_queryId as queryId,
					@l_Cur_DBSize as curDBSize,
					@program_name as programName,
					@hostprocess  as hostprocess,
					@l_threadid  as threadid,
					@last_batch  as last_batch,
                    @user_page_alloc_count as user_page_alloc_count,
					@internal_page_alloc_count as internal_page_alloc_count,
					@l_physicalIO as physical_io,
					@cpu as cpu,
					@lastInputForSPID as dbccinputbuffer,
					@stmt_start as stmt_start,
					@stmt_end as stmt_end,
					@l_tempdbusage2 as second_highest_tempdb_usage,
					@l_maxphysicalIO as max_physical_io
		END -- non null queryId
	END
	IF (@l_Prev_DBSize is null) OR (@l_Cur_DBSize <> @l_Prev_DBSize)
	BEGIN
		INSERT INTO troubleshooting..tempDBSize VALUES(getdate(), @l_Cur_DBSize)
	END ELSE
	BEGIN
		IF (@l_Prev_DBSize > 10000000)  AND
			( DATEDIFF(m, @l_Growtime  , GETDATE())> 10 )
		BEGIN
				--  we should be shrinking the tempdblog
				-- if it hasn't grown for 10 mins and is larger than 10 GB
				DECLARE @shrink_cmdString varchar(128) = 'USE tempdb DBCC SHRINKFILE(''templog'')'
				EXEC(@shrink_cmdString)
		END
	END
 SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CV_LogTempDBSizeAndQueries')
	delete from GxQscripts where name = 'CV_LogTempDBSizeAndQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_LogTempDBSizeAndQueries')
	delete from GXDBVersions where aliasname = 'CV_LogTempDBSizeAndQueries'
GO

insert into GXDBVersions values(2, 'CV_LogTempDBSizeAndQueries',  '00010004008000020000', 'CV_LogTempDBSizeAndQueries', '00010004008000020000')
GO

