

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CV_LogLogFileSizeAndQueries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CV_LogLogFileSizeAndQueries.sp,v $ $Id: CV_LogLogFileSizeAndQueries.sp,v 1.2.180.1 2018/03/20 00:39:03 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_LogLogFileSizeAndQueries <<<'

IF EXISTS (select * from sysobjects where name='CV_LogLogFileSizeAndQueries')
	drop procedure CV_LogLogFileSizeAndQueries
IF EXISTS (select * from GxQscripts where name='CV_LogLogFileSizeAndQueries')
	delete from GxQscripts where name = 'CV_LogLogFileSizeAndQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_LogLogFileSizeAndQueries')
	delete from GXDBVersions where aliasname = 'CV_LogLogFileSizeAndQueries'
GO
print '... Creating Procedure: CV_LogLogFileSizeAndQueries'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_LogLogFileSizeAndQueries
AS
      SET NOCOUNT ON
	DECLARE		@l_Cur_LogSize		INT
	DECLARE		@l_Prev_LogSize		INT
	SET @l_Cur_LogSize = 0.0
	SET @l_Prev_LogSize = 0.0
	IF(OBJECT_ID('tempLogSize') is null)
		CREATE TABLE tempLogSize(LogSize FLOAT)
	--Get current and previous log size
	SELECT @l_Cur_LogSize = SUM(size)*8/1024 FROM sys.master_files
	WHERE type = 1 and database_id = DB_ID('Commserv')
	SELECT TOP 1 @l_Prev_LogSize = LogSize FROM tempLogSize
	IF(@l_Cur_LogSize > @l_Prev_LogSize)
	BEGIN
		--log sql statements running for more than 1 minute
		INSERT GxSQLLockDetection(	groupid, isFromODBC,
									timedetected, spid,
									blockedBy, waittime,
									waittype, objectid,
									objectname, lastwaittype,
									waitresource, cpu,
									physical_io, memusage,
									open_tran, status,
									hostprocess, cmd,
									LastCommand, last_batch,
									login_time, sql_handle,
									stmt_start, stmt_end
									)
			SELECT
				SPRC.dbid, -1,
				GETDATE(), SPRC.spid,
				0, SPRC.waittime,
				SPRC.waittype, 	DATEDIFF(MI, SPRC.login_time, GETDATE()), --object id as diff time
				'','',
				'', SPRC.cpu,
				SPRC.physical_io, @l_Cur_LogSize, --Memusage is used for DBsize
				SPRC.open_tran, SPRC.status,
				SPRC.hostprocess,
				SUBSTRING (sqlLstCmd.text, er.statement_start_offset/2,
								((CASE WHEN er.statement_end_offset = -1
									THEN LEN(CONVERT(NVARCHAR(MAX), sqlLstCmd.text)) * 2
									ELSE er.statement_end_offset END) - er.statement_start_offset)/2),
				ISNULL(REPLACE(REPLACE(sqlLstCmd.text,CHAR(13),''),CHAR(10),' '),''), SPRC.last_batch,
				SPRC.login_time, SPRC.sql_handle,
				SPRC.stmt_start, SPRC.stmt_end
			FROM sys.dm_exec_requests er
			    INNER JOIN master..sysprocesses  SPRC ON er.session_id = sprc.spid
			OUTER APPLY sys.dm_exec_sql_text(SPRC.sql_handle) AS sqlLstCmd
			WHERE sqlLstCmd.text is not null
			AND DATEDIFF(SS, SPRC.login_time, GETDATE()) > 30
			AND SPRC.spid <> @@SPID
	END
	DELETE tempLogSize
	INSERT INTO tempLogSize VALUES(@l_Cur_LogSize)
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CV_LogLogFileSizeAndQueries')
	delete from GxQscripts where name = 'CV_LogLogFileSizeAndQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_LogLogFileSizeAndQueries')
	delete from GXDBVersions where aliasname = 'CV_LogLogFileSizeAndQueries'
GO

insert into GXDBVersions values(2, 'CV_LogLogFileSizeAndQueries',  '00010002018000010000', 'CV_LogLogFileSizeAndQueries', '00010002018000010000')
GO

