

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CV_LogLockingQueries2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_LogLockingQueries2 <<<'

IF EXISTS (select * from sysobjects where name='CV_LogLockingQueries2')
	drop procedure CV_LogLockingQueries2
IF EXISTS (select * from GxQscripts where name='CV_LogLockingQueries2')
	delete from GxQscripts where name = 'CV_LogLockingQueries2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_LogLockingQueries2')
	delete from GXDBVersions where aliasname = 'CV_LogLockingQueries2'
GO
print '... Creating Procedure: CV_LogLockingQueries2'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_LogLockingQueries2
  @LogLevel INT
AS
-- Step 0. Find out what to log.
Declare @LogAllSpids int = 0
Declare @LogLockedObjects int = 0
Declare @LogAllDbs int = 0
If (@LogLevel & 0x1) = 0x1
	Set @LogAllSpids = 1
If (@LogLevel & 0x2) = 0x2
	Set @LogLockedObjects = 1
If (@LogLevel & 0x4) = 0x4
	Set @LogAllDbs = 1
-- Step 1. Insert into group table.
Insert into GroupTable (log_time, blocked_count)
	Select CURRENT_TIMESTAMP, 0
Declare @CurGrpId INT = SCOPE_IDENTITY ()
-- Step 2. Create snapshots of spid, locks tables.
-- Impose the database id check here whereever possible. This reduces the amount of data to work with.
-- Suggestion from Mike - Create the temp tables first and then populate them. These reduces the amount of time tempdb is schema-locked.
Select * into #Spid from sys.sysprocesses where 1 = 0
Select * into #Requests from sys.dm_exec_requests where 1 = 0
Select * into #Trans from sys.dm_tran_session_transactions where 1 = 0
Select * into #Locks2 from sys.syslockinfo where 1 = 0
Select * into #Cursors from sys.dm_exec_cursors (0) where 1 = 0
Insert into #Spid
	Select *
	from sys.sysprocesses
	where
		@LogAllDbs = 1 or
		dbid = DB_ID('Commserv')
Insert into #Requests
	Select *
	from sys.dm_exec_requests
	where
		@LogAllDbs = 1 or
		database_id = DB_ID('Commserv')
Insert into #Trans
	Select *
	from sys.dm_tran_session_transactions
-- To go into LockedObjects table
If @LogLockedObjects = 1
Begin
	Create table #Locks
		(Spid INT, Dbid INT, Objid INT, Indid INT, Type NCHAR(4),
		Resource NCHAR(32), Mode NVARCHAR(8), Status NVARCHAR(5))
	Insert into #Locks
		Exec sp_lock
End
-- For waiting/granted status
Insert into #Locks2
	Select *
	from sys.syslockinfo
	where
		@LogAllDbs = 1 or
		rsc_dbid = DB_ID('Commserv')
Insert into #Cursors
	Select *
	from sys.dm_exec_cursors (0)
-- Will be populated later on demand.
Create table #Inputbuffer
	(EventType nvarchar(30), Parameters smallint, EventInfo nvarchar(4000))
-- Step 3.1 Prep SPID info to be inserted into SpidTable
Select distinct
	-- Query grouping info.
	[Group_id] = @CurGrpId,
		[Spid] = #Spid.spid,
		[Tran_id] = #Trans.transaction_id,
		[Req_id] = #Requests.request_id,
		[Db_id] = #Spid.dbid,
	-- Locked resource info.
	[Wait_resource] = CONVERT (VARCHAR(64), #Spid.waitresource),
		[Wait_obj] = CONVERT (VARCHAR(64), OBJECT_NAME(Owner.rsc_objid)),
		[Wait_type] = CONVERT (VARCHAR(32), #Spid.lastwaittype),
		[Wait_time] = #Spid.waittime,
	-- Blocked by info.
	[Blocked_by] = #Spid.blocked,
		[Res_owner_spid] = CONVERT (SMALLINT, Owner.req_spid),
	-- Process info.
	[Process_id] = CONVERT (INT, #Spid.hostprocess),
		[Process_name] = CONVERT (VARCHAR(64), #Spid.program_name),
		[Last_batch] = #Spid.last_batch,
	-- Last query info.
	[Current_cmd] = CONVERT (VARCHAR(32), #Spid.cmd),
		[Current_query] = CONVERT (VARCHAR(MAX), Query.text),
		-- Set this to NULL for now. We populate it below.
		[Current_stmt] = CONVERT (VARCHAR(MAX), NULL),
		[stmt_start] = #Spid.stmt_start,
		[stmt_end] = #Spid.stmt_end
into
	[#Candidates]
from
	[#Spid]
		Left outer join
	[#Requests] on #Spid.spid = #Requests.session_id
		Left outer join
	[#Trans] on #Spid.spid = #Trans.session_id
		Left outer join
	[#Locks2] Victim on #Spid.spid = Victim.req_spid and
						Victim.req_status = 3 /*3 - Waiting*/
		Left outer join
	[#Locks2] Owner on Owner.rsc_objid = Victim.rsc_objid and
					   Owner.req_status = 1 /*1 - Granted*/ and
						-- In case of lock escalations, Victim can also have a granted lock on the same locked object.
					   Owner.req_spid <> Victim.req_spid
		Outer apply
	sys.dm_exec_sql_text (#Spid.sql_handle) as Query
where
	-- Always log blocked and blocking spids.
	[#Spid].blocked <> 0 or
	[#Spid].spid in (Select Spid2.blocked from #Spid Spid2 where Spid2.blocked <> 0) or
	-- If asked to log all processes, log all user processes only. Blocking server processes are covered above.
	(@LogAllSpids = 1 and #Spid.spid > 50)
-- Step 3.2 Sanitize last query. There is a lot of special handling here. Please bear with me.
--
-- Case 1: Stmt's SQL handle gave a "FETCH API_CURSOR" -> Replace it with the text from the cursor's SQL handle.
-- (If the cursor was closed, we are stuck with "FETCH API_CURSOR").
Update #Candidates
set
	[Current_query] = Query.text,
	[stmt_start] = #Cursors.statement_start_offset,
	[stmt_end] = #Cursors.statement_end_offset
from
	[#Candidates]
		Inner join
	[#Cursors] on [#Candidates].Current_query like 'FETCH API_CURSOR%' and
				  [#Candidates].Spid = #Cursors.session_id and
				  [#Cursors].sql_handle is not null
		Outer apply
	sys.dm_exec_sql_text (#Cursors.sql_handle) as Query
-- Case 2: Current stmt info (within the query) is known -> Substring current statement from current query.
Update #Candidates
set
	[Current_stmt] = SUBSTRING (
								Current_query,
								-- Upon testing, we found that "stmt_start/2" was always one char too many.
								stmt_start/2 + 1,
								CASE
									-- 999999 - SUBSTRING-s till end of Current_query. Better than (LEN(Current_query)-stmt_start)/2
									WHEN stmt_end = -1 THEN 999999
									ELSE (stmt_end-stmt_start)/2
								END
								)
from
	[#Candidates]
where
	stmt_start <> 0 and
	stmt_end <> 0
-- Case 3: INPUTBUFFER info is available -> Replace query from SQL handle with INPUTBUFFER.
-- INPUTBUFFER is better because it gives out the exact arguments used.
Declare @CurSpid int
Declare @InbufCmd varchar(256)
Declare InbufCur cursor for
	Select distinct
		Spid
	from
		[#Candidates]
Open InbufCur
Fetch next from InbufCur into @CurSpid
While @@FETCH_STATUS = 0
Begin
	Set @InbufCmd = 'DBCC INPUTBUFFER(' + CAST(@CurSpid AS CHAR(8)) + ')'
	Insert into #Inputbuffer
		Exec (@InbufCmd)
	-- Avoid a join.
	Declare @Inbuf nvarchar(4000)
	Select @Inbuf = EventInfo from #Inputbuffer
	If @Inbuf not like 'FETCH API_CURSOR%' and
	   @Inbuf not like 'SET NOCOUNT%'
	Begin
		Update #Candidates
		set
			[Current_query] = @Inbuf
		where
			[#Candidates].Spid = @CurSpid
	End
	Fetch next from InbufCur into @CurSpid
	Delete #Inputbuffer
End
Close InbufCur
Deallocate InbufCur
-- Case 4: Query is a procedure or a cursor -> Truncate full definition and save memory.
Update #Candidates
set
	-- 96 - should be good enough to show proc name. Better than any logic to single out just the proc name.
	[Current_query] = SUBSTRING (Current_query, 0, 96)
from
	[#Candidates]
where
	-- No LTRIM because sometimes we got '<line feed>Create procedure...'.
	REPLACE(SUBSTRING(Current_query, 0, 96), CHAR(10), '') like 'Create procedure%' or
	Current_query like '-- Create Cursor%'
-- Step 4. All is good. Insert into SpidTable.
Declare @SpidInsCount int = 0
Insert into SpidTable
	Select distinct
		@CurGrpId, Spid, Tran_id, Req_id, Db_id,
		Wait_resource, Wait_obj, Wait_type, Wait_time,
		Blocked_by, Res_owner_spid,
		Process_id, Process_name, Last_batch,
		Current_cmd, Current_query, Current_stmt
	from
		[#Candidates]
	order by
		[#Candidates].spid
Set @SpidInsCount = @@ROWCOUNT
-- Update blocked spid count in group table.
Update GroupTable
set
	blocked_count = (Select COUNT(*) from #Candidates where Blocked_by <> 0)
where
	group_id = @CurGrpId
-- Step 5. Insert into lockedobjects table.
Declare @LockedInsCount int = 0
If @LogLockedObjects = 1
Begin
	Insert into LockedObjTable
		Select
			@CurGrpId, Spid, Dbid, Objid, Indid, Type,
			Resource, Mode, Status
		from
			[#Locks]
		where
			(@LogAllDbs = 1 or Dbid = DB_ID('Commserv')) and
			(@LogAllSpids = 1 or Spid in (Select Spid from #Candidates))
	Set @LockedInsCount = @@ROWCOUNT
End
-- If no useful information was inserted for this group, get rid of the group entry.
If @SpidInsCount = 0 and @LockedInsCount = 0
	Delete
	from
		Grouptable
	where
		group_id = @CurGrpId
GO

IF EXISTS (select * from GxQscripts where name = 'CV_LogLockingQueries2')
	delete from GxQscripts where name = 'CV_LogLockingQueries2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_LogLockingQueries2')
	delete from GXDBVersions where aliasname = 'CV_LogLockingQueries2'
GO

insert into GXDBVersions values(2, 'CV_LogLockingQueries2',  '00000000000000000000', 'CV_LogLockingQueries2', '00000000000000000000')
GO

