

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CV_LogLockingQueries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_LogLockingQueries <<<'

IF EXISTS (select * from sysobjects where name='CV_LogLockingQueries')
	drop procedure CV_LogLockingQueries
IF EXISTS (select * from GxQscripts where name='CV_LogLockingQueries')
	delete from GxQscripts where name = 'CV_LogLockingQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_LogLockingQueries')
	delete from GXDBVersions where aliasname = 'CV_LogLockingQueries'
GO
print '... Creating Procedure: CV_LogLockingQueries'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_LogLockingQueries
  @timeout Integer,
  @showdetails Integer,
  @outputToTable Integer,
  @showAllRunningQueries Integer,
  @isForODBC Integer,
  @spId Integer
AS
  DECLARE @r_GroupId INTEGER
  DECLARE @r_spid INTEGER
  DECLARE @r_blockedBy INTEGER
  DECLARE @r_waittime INTEGER
  DECLARE @r_waittype INTEGER
  DECLARE @r_objectid INTEGER
  DECLARE @r_objectname VARCHAR(256)
  DECLARE @r_lastwaittype NVARCHAR(32)
  DECLARE @r_waitresource NVARCHAR(128)
  DECLARE @r_cpu INTEGER
  DECLARE @r_physical_io INTEGER
  DECLARE @r_memusage INTEGER
  DECLARE @r_open_tran INTEGER
  DECLARE @r_status NVARCHAR(64)
  DECLARE @r_hostprocess NVARCHAR(8)
  DECLARE @r_cmd NVARCHAR(128)
  DECLARE @r_LastCommand VARCHAR(2048)
  DECLARE @r_last_batch DATETIME
  DECLARE @r_login_time DATETIME
  DECLARE @r_stmt_start INTEGER
  DECLARE @r_stmt_end INTEGER
/*locale Variables*/
      DECLARE @dbid INTEGER
      DECLARE @cmdString VARCHAR(1024)
      DECLARE @timeoccured DATETIME
      DECLARE @l_groupID INTEGER
      DECLARE @l_last_batch DATETIME
      DECLARE		@l_EventInfo		VARCHAR(MAX)
      DECLARE		@l_HostProcess		VARCHAR(MAX)
      DECLARE		@l_ProgramName		VARCHAR(MAX)
      SET @timeoccured = GETDATE()
      SET	@l_EventInfo	=	''
      SET	@l_HostProcess	=	''
      SET	@l_ProgramName	=	''
      --SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
      --BEGIN TRANSACTION
      SET @timeout = @timeout * 1000
      -- IF object_id('tempdb.dbo.#sqlStmt') IS NOT null DROP TABLE #sqlStmt
      --IF OBJECT_ID('tempdb.dbo.#spIdLastBatchTime') IS NOT null DROP TABLE #spIdLastBatchTime
      --IF OBJECT_ID('tempdb.dbo.#spidLocks') IS NOT null DROP TABLE #spidLocks
      --IF OBJECT_ID('tempdb.dbo.#l_sysprocess') IS NOT null DROP TABLE #l_sysprocess
      --IF OBJECT_ID('tempdb.dbo.#l_syslockinfo') IS NOT null DROP TABLE #l_syslockinfo
      SELECT @dbid = dbid FROM master..sysdatabases where name = 'commserv'
      SET @cmdString = 'DBCC INPUTBUFFER(' + CAST(@spid AS CHAR(100)) + ')'
      CREATE TABLE #sqlStmt (
								EventType NVARCHAR(1024),
								Parameters INTEGER,
								EventInfo NVARCHAR(max)
							)
      CREATE TABLE #spIdLastBatchTime(  SPID INTEGER,
										SPInfoID INTEGER,
										last_batch DATETIME,
										waittime BIGINT
									)
      CREATE TABLE #spidLocks(	spid INTEGER,
								dbid INTEGER,
								objectid INTEGER,
								InId INTEGER,
								Type NVARCHAR(5),
								Resource NCHAR(33),
								Mode NVARCHAR(9),
								status NVARCHAR(32),
								ObjectName VARCHAR(256)
							)
 	  --Just create temp table
      SELECT *
      INTO	#l_sysprocess
      FROM master..sysprocesses with(nolock) where 1=0
      SELECT *
      INTO	#l_syslockinfo
       from master..syslockinfo with(nolock) where 1=0
--insert all rows
      INSERT  INTO	#l_sysprocess
		SELECT * FROM master..sysprocesses with(nolock)
	  INSERT INTO	#l_syslockinfo
		select * from master..syslockinfo with(nolock)
	  IF(@spId > 0)
      BEGIN
		INSERT #sqlStmt
		EXEC (@cmdString)
	  END
      BEGIN TRAN
      DECLARE @l_maxGroupId int
	  select @l_maxGroupId  = MAX(groupid) from gxsqlgroupinfo WITH (TABLOCKX)
	  /* Lock all tables that will be written into in CV_LogLockingQueries in the beginning of the transaction itself
	  so that it doesn't deadlock with any other operation (ShrinkDB while CommservDR) that needs exclusive access to these tables in a different order  */
	  DECLARE @dummyLockHelper INTEGER
	  SELECT @dummyLockHelper = 0 FROM GxSQLSPID_Info WITH (TABLOCKX)
	  SELECT @dummyLockHelper = 0 FROM GxSQLGroupToSPID WITH (TABLOCKX)
	  SELECT @dummyLockHelper = 0 FROM GxSQLLockedObjectsForSPID WITH (TABLOCKX)
      SELECT
			@l_EventInfo = REPLACE(REPLACE(stm.EventInfo, CHAR(13), ''),CHAR(10),' '),
			@l_HostProcess = hostprocess,
			@l_ProgramName = program_name
      FROM #l_sysprocess,#sqlStmt stm where spid = @spId AND dbid = @dbid
	  DECLARE @groupIdTbl TABLE (groupId INTEGER)
      INSERT INTO GxSQLGroupInfo(
                                          FailureSPId,
                                          Detectiontime,
                                          isFromODBC,
                                          sqlStatement,
                                          processId,
                                          processName
                              )
	  OUTPUT    INSERTED.groupid
		INTO @groupIdTbl
      VALUES (@spId,@timeoccured,@isForODBC,@l_EventInfo,@l_HostProcess,@l_ProgramName)
      SELECT
		@l_groupID = groupId
      FROM @groupIdTbl
      IF(@@ERROR <> 0)
      BEGIN
            print 'Failed to insert a row into GxSQLGroupInfo'
            GOTO EXIT_PROC
      END
	SELECT @l_last_batch = last_batch FROM #l_sysprocess WHERE spid = @spId
	INSERT #spIdLastBatchTime(
                                    SPID,
                                    SPInfoID,
                                    last_batch,
                                    waittime
                              )
     SELECT DISTINCT spid,
				  NULL,
				  last_batch,
				  waittime
     FROM #l_sysprocess WHERE dbid = @dbid
  UPDATE #spIdLastBatchTime
         SET #spIdLastBatchTime.SPInfoID = GSI.SPInfoID
 FROM GxSQLSPID_Info GSI WHERE GSI.spid = #spIdLastBatchTime.SPID
                             AND GSI.last_batch = #spIdLastBatchTime.last_batch
                             AND (
									(	GSI.waittime < @timeout
										AND     #spIdLastBatchTime.waittime < @timeout
									) OR
									(
											GSI.waittime > @timeout
											AND     #spIdLastBatchTime.waittime > @timeout
									)
								)
                            AND  GSI.atime >  DATEADD(dd, -1, GETDATE())
 INSERT GxSQLSPID_Info (
                                        atime,
                                        SPID,
                                        originalGroupId,
                                        blockedBy,
                                        waittime,
                                        waittype,
                                        objectid,
                                        objectname,
                                        lastwaittype,
                                        waitresource,
                                        cpu,
                                        physical_io,
                                        memusage,
                                        open_tran,
                                        status,
                                        hostprocess,
                                        cmd,
                                        LastCommand,
                                        last_batch,
                                        login_time,
                                        sql_handle,
                                        stmt_start,
                                        stmt_end
                                    )
      SELECT	GETDATE(), SPRC.spid, @l_groupID,
				SPRC.blocked, SPRC.waittime, SPRC.waittype,
				0, '', SPRC.lastwaittype, RTRIM(SPRC.waitresource),
				SPRC.cpu,SPRC.physical_io, SPRC.memusage,SPRC.open_tran,
				RTRIM(SPRC.status),RTRIM(SPRC.hostprocess),RTRIM(SPRC.cmd),
				ISNULL(REPLACE(REPLACE(sqlLstCmd.text,CHAR(13),''),CHAR(10),' '),''),
				SLB.last_batch,SPRC.login_time,SPRC.sql_handle,SPRC.stmt_start,SPRC.stmt_end
      FROM #l_sysprocess SPRC
           INNER JOIN #spIdLastBatchTime SLB ON SPRC.spid = SLB.SPID
										AND SLB.SPInfoID IS null
										OUTER APPLY sys.dm_exec_sql_text(SPRC.sql_handle) AS sqlLstCmd
	IF(@@ERROR <> 0)
	BEGIN
		print 'Failed to insert a row into GxSQLSPID_Info'
		GOTO EXIT_PROC
	END
	UPDATE #spIdLastBatchTime
      SET #spIdLastBatchTime.SPInfoID = GSI.SPInfoId
	FROM GxSQLSPID_Info GSI WHERE GSI.spid = #spIdLastBatchTime.SPID
                        AND GSI.last_batch = #spIdLastBatchTime.last_batch
                        AND GSI.originalGroupId = @l_groupID
                        AND #spIdLastBatchTime.SPInfoID IS null
	UPDATE GxSQLSPID_Info /* IF syslockinfo.req_status is  1 -> Granted.
                                                              2 -> Converting.
                                                              3 -> Waiting.   so find all tables if it is waiting */
                  SET objectid = ISNULL(rsc_objid,0)
	FROM #l_syslockinfo
	WHERE GxSQLSPID_Info.originalGroupId = @l_groupID
		 AND req_spid = GxSQLSPID_Info.spid
		 AND req_status = 3
	UPDATE GxSQLSPID_Info
            SET objectname = OBJECT_NAME(objectid)
	WHERE GxSQLSPID_Info.originalGroupId = @l_groupID AND objectid <> 0
-- if no rows found with waittime more than the input time @timeout then exit (if the @showAllRunningQueries option is not selected)
	IF (
			@showAllRunningQueries = 0 AND
			NOT EXISTS (
						 SELECT 1 FROM GxSQLSPID_Info
							WHERE waittime >= @timeout
								 AND originalGroupId = @l_groupID
						)
		)
	BEGIN
	   GOTO EXIT_PROC
	END
INSERT  GxSQLGroupToSPID
                              (
                                    GroupId,
                                    SPID,
                                    SPInfoId,
                                    blockedBy
                              )
SELECT @l_groupID,
	 GSI.spId,
	 GSI.SPInfoId,
	 GSI.blockedBy
FROM GxSQLSPID_Info GSI
	INNER JOIN #spIdLastBatchTime SPLB ON SPLB.SPID = GSI.SPID
									AND SPLB.SPInfoID = GSI.SPInfoId
/* spid's that are either blocking others or are being blocked (if the @showAllRunningQueries option is not selected)*/
IF (
	@showAllRunningQueries = 0 AND
	NOT EXISTS (SELECT 1 FROM GxSQLGroupToSPID GSIOUT
				WHERE (GSIOUT.GroupId = @l_groupID
						AND GSIOUT.spid <> GSIOUT.blockedBy
						AND GSIOUT.blockedBy <> 0
                        AND EXISTS(SELECT 1 FROM GxSQLGroupToSPID GSIIN
                                           WHERE GSIOUT.blockedBy = GSIIN.SPID
                                           AND GSIIN.GroupId = @l_groupID)
                        )
                )
    )
BEGIN
      GOTO EXIT_PROC
END
IF(@@ERROR <> 0)
BEGIN
      print 'Failed to insert a row into GxSQLGroupToSPID'
      GOTO EXIT_PROC
END
--find all currently locked objects
INSERT #spidLocks(spid, dbid, objectid, InId, Type, Resource, Mode, status)
EXEC sp_lock
DELETE #spidLocks where dbid <> @dbid
MERGE #spidLocks AS TARGET
USING (
			SELECT DISTINCT SPID
			FROM GxSQLGroupToSPID
			WHERE GroupId = @l_groupID
			AND blockedBy <> 0
			UNION
			SELECT DISTINCT blockedBy
			FROM GxSQLGroupToSPID
			WHERE GroupId = @l_groupID
			AND blockedBy <> 0
	 ) AS SOURCE
ON TARGET.SPID = SOURCE.SPID
WHEN NOT MATCHED BY SOURCE
THEN DELETE;
UPDATE #spidLocks
	SET ObjectName = ISNULL(OBJECT_NAME(objectid),'')
WHERE #spidLocks.ObjectName is null
IF(@outputToTable = 1)
BEGIN
            INSERT GxSQLLockedObjectsForSPID
                                          (
                                                groupid,
                                                timedetected,
                                                SPInfoId,
                                                dbid,
                                                objectid,
                                                InId,
                                                Type,
                                                Resource,
                                                Mode,
                                                status,
                                                ObjectName
                                          )
            SELECT GSI.originalGroupId,@timeoccured,GSI.SPInfoId,spLck.dbid,
                        spLck.objectid,spLck.InId,spLck.Type,spLck.Resource,
                        spLck.Mode,spLck.status,spLck.ObjectName
            FROM #spidLocks spLck
					INNER JOIN GxSQLSPID_Info GSI ON spLck.spid = GSI.spid
												AND GSI.originalGroupId = @l_groupID
END
ELSE
BEGIN
  SELECT GSI.originalGroupId,GSI.SPID,GSI.blockedBy,
		GSI.waittime,GSI.waittype,GSI.objectid,
		GSI.objectname,GSI.lastwaittype,GSI.waitresource,
		GSI.cpu,GSI.physical_io,GSI.memusage,
		GSI.open_tran,GSI.status,GSI.hostprocess,
		GSI.cmd,GSI.LastCommand,GSI.last_batch,
		GSI.login_time,GSI.stmt_start,GSI.stmt_end
  FROM GxSQLSPID_Info GSI
  WHERE GSI.originalGroupId = @l_groupID
END
IF(@isForODBC = 1)
BEGIN
      SELECT @l_groupID
END
EXIT_PROC:
      IF(@@ERROR <> 0)
      BEGIN
            ROLLBACK TRANSACTION
            print 'Error: Failed to execute CV_DetectLockingQueries proc'
      END
      ELSE
      BEGIN
            COMMIT TRANSACTION
      END
GO

IF EXISTS (select * from GxQscripts where name = 'CV_LogLockingQueries')
	delete from GxQscripts where name = 'CV_LogLockingQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_LogLockingQueries')
	delete from GXDBVersions where aliasname = 'CV_LogLockingQueries'
GO

insert into GXDBVersions values(2, 'CV_LogLockingQueries',  '00000000000000000000', 'CV_LogLockingQueries', '00000000000000000000')
GO

