

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CV_GetSpParams.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CV_GetSpParams.sp,v $ $Id: CV_GetSpParams.sp,v 1.2.276.1 2018/03/22 01:17:49 jiechen Exp $";
--  +========================================================================+
--  | Stored Precedure: CV_GetSpParams()
--  | Description:  Return list of parameters and their data type for sp
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_GetSpParams <<<'

IF EXISTS (select * from sysobjects where name='CV_GetSpParams')
	drop procedure CV_GetSpParams
IF EXISTS (select * from GxQscripts where name='CV_GetSpParams')
	delete from GxQscripts where name = 'CV_GetSpParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetSpParams')
	delete from GXDBVersions where aliasname = 'CV_GetSpParams'
GO
print '... Creating Procedure: CV_GetSpParams'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_GetSpParams
  @i_sp_name VARCHAR(1024)
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ParamTbl TABLE (Parameter VARCHAR(64), Type VARCHAR(128))
	INSERT INTO @ParamTbl
    SELECT
        [Param] = COALESCE(PARAMETER_NAME, '<no params>'),
        [DataType] = COALESCE(UPPER(DATA_TYPE) + CASE
            WHEN DATA_TYPE IN ('NUMERIC', 'DECIMAL') THEN
                '(' + CAST(NUMERIC_PRECISION AS VARCHAR)
                + ', ' + CAST(NUMERIC_SCALE AS VARCHAR) + ')'
            WHEN RIGHT(DATA_TYPE, 4) = 'CHAR' THEN (CASE WHEN CHARACTER_MAXIMUM_LENGTH = -1 THEN '(MAX)' ELSE
                '(' + CAST(CHARACTER_MAXIMUM_LENGTH AS VARCHAR) + ')' END)
            ELSE '' END + CASE PARAMETER_MODE
            WHEN 'INOUT' THEN ' OUTPUT' ELSE ' ' END, '-')
    FROM INFORMATION_SCHEMA.PARAMETERS
    WHERE SPECIFIC_NAME = @i_sp_name
    ORDER BY ORDINAL_POSITION
    SELECT * FROM @ParamTbl
GO

IF EXISTS (select * from GxQscripts where name = 'CV_GetSpParams')
	delete from GxQscripts where name = 'CV_GetSpParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetSpParams')
	delete from GXDBVersions where aliasname = 'CV_GetSpParams'
GO

insert into GXDBVersions values(2, 'CV_GetSpParams',  '00010002027600010000', 'CV_GetSpParams', '00010002027600010000')
GO

