

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CV_DetectLockingQueries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Prakash Varadharajan
--	Date:   06/16/2005
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CV_DetectLockingQueries.sp,v $ $Id: CV_DetectLockingQueries.sp,v 1.8.34.1 2018/03/20 00:50:52 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_DetectLockingQueries <<<'

IF EXISTS (select * from sysobjects where name='CV_DetectLockingQueries')
	drop procedure CV_DetectLockingQueries
IF EXISTS (select * from GxQscripts where name='CV_DetectLockingQueries')
	delete from GxQscripts where name = 'CV_DetectLockingQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_DetectLockingQueries')
	delete from GXDBVersions where aliasname = 'CV_DetectLockingQueries'
GO
print '... Creating Procedure: CV_DetectLockingQueries'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_DetectLockingQueries
  @timeout Integer,
  @showdetails Integer,
  @outputToTable Integer,
  @showAllRunningQueries Integer,
  @isForODBC Integer
AS
  DECLARE @r_spid INTEGER
  DECLARE @r_blockedBy INTEGER
  DECLARE @r_waittime INTEGER
  DECLARE @r_waittype INTEGER
  DECLARE @r_objectid INTEGER
  DECLARE @r_objectname VARCHAR(256)
  DECLARE @r_lastwaittype NVARCHAR(32)
  DECLARE @r_waitresource NVARCHAR(128)
  DECLARE @r_cpu INTEGER
  DECLARE @r_physical_io INTEGER
  DECLARE @r_memusage INTEGER
  DECLARE @r_open_tran INTEGER
  DECLARE @r_status NVARCHAR(64)
  DECLARE @r_hostprocess NVARCHAR(8)
  DECLARE @r_cmd NVARCHAR(128)
  DECLARE @r_LastCommand VARCHAR(2048)
  DECLARE @r_last_batch DATETIME
  DECLARE @r_login_time DATETIME
  DECLARE @r_stmt_start INTEGER
  DECLARE @r_stmt_end INTEGER
	SET NOCOUNT ON
	DECLARE @dbid INTEGER
	DECLARE @spid INTEGER
	DECLARE @cmdString VARCHAR(1024)
	DECLARE @timeoccured DATETIME
	DECLARE @nextGroupId INTEGER
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SELECT @dbid = dbid FROM master..sysdatabases WHERE name LIKE 'CommServ'
	SET @timeout = @timeout * 1000
	-- drop old tables
	IF object_id('tempdb.dbo.#waitforgraph') IS NOT null DROP TABLE #waitforgraph
	IF object_id('tempdb.dbo.#lastcmd') IS NOT null DROP TABLE #lastcmd
	IF object_id('tempdb.dbo.#locks') IS NOT null DROP TABLE #locks
	-- create table that will hold showAllRunningQueries the required lock information
	CREATE TABLE #waitforgraph (spid INTEGER, blockedBy INTEGER, waittime INTEGER, waittype INTEGER,
		objectid INTEGER, objectname VARCHAR(256), lastwaittype NVARCHAR(32), waitresource NVARCHAR(128), cpu INTEGER, physical_io INTEGER,
		memusage INTEGER, open_tran INTEGER, status NVARCHAR(64), hostprocess NVARCHAR(8), cmd NVARCHAR(128), LastCommand VARCHAR(max),
		last_batch DATETIME, login_time DATETIME, sql_handle BINARY(20), stmt_start INTEGER, stmt_end INTEGER)
	-- first insert showAllRunningQueries the current rows for the CommServ database. then we will filter out unwanted rows
	INSERT INTO #waitforgraph
	SELECT spid, blocked, waittime, waittype, 0, '', lastwaittype, RTRIM(waitresource), cpu, physical_io,memusage,
	open_tran, RTRIM(status), RTRIM(hostprocess), RTRIM(cmd), '', last_batch, login_time, sql_handle, stmt_start, stmt_end
	FROM master..sysprocesses WHERE dbid = @dbid
	-- if no rows found with waittime more than the input time @timeout then exit (if the @showAllRunningQueries option is not selected)
	IF @showAllRunningQueries = 0 AND NOT EXISTS (SELECT * FROM #waitforgraph WHERE waittime >= @timeout)
		RETURN
	-- only keep spid's that are either blocking others or are being blocked (if the @showAllRunningQueries option is not selected)
	-- also filter out spid's that are blocking itself (happens!)
	IF @showAllRunningQueries = 0
		DELETE FROM #waitforgraph WHERE (spid = blockedBy OR blockedBy = 0) AND NOT EXISTS (SELECT * FROM #waitforgraph AS B WHERE B.blockedBy = #waitforgraph.spid and B.spid <> #waitforgraph.spid)
	-- if there are no remaining rows then just exit
	IF NOT EXISTS (SELECT * FROM #waitforgraph)
		RETURN
	UPDATE #waitforgraph SET objectid = ISNULL((SELECT TOP 1 rsc_objid FROM master..syslockinfo WHERE req_spid = #waitforgraph.spid AND req_status = 3),0)
	-- for each of the remaining spid's get the input buffer
	CREATE TABLE #lastcmd (EventType NVARCHAR(1024), Parameters INTEGER, EventInfo NVARCHAR(max))
	DECLARE process_cursor CURSOR for SELECT spid FROM #waitforgraph
	OPEN process_cursor
	FETCH NEXT FROM process_cursor INTO @spid
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @cmdString = 'DBCC INPUTBUFFER(' + CAST(@spid AS CHAR(100)) + ')'
		INSERT INTO #lastcmd EXEC (@cmdString)
		-- replace new line characters for easier reading of the output
		UPDATE #waitforgraph SET LastCommand = REPLACE(REPLACE((SELECT EventInfo FROM #lastcmd), CHAR(13), ''),CHAR(10),' ')
			WHERE spid = @spid
		TRUNCATE TABLE #lastcmd
		FETCH NEXT FROM process_cursor INTO @spid
	END
	CLOSE process_cursor
	DEALLOCATE process_cursor
	-- get the object name
	UPDATE #waitforgraph SET objectname = OBJECT_NAME(objectid) WHERE objectid <> 0
	-- replace new line characters for easier reading of the output
	--UPDATE #waitforgraph SET LastCommand = REPLACE(REPLACE(LastCommand, CHAR(13), ''),CHAR(10),' ')
	IF @outputToTable = 1
	BEGIN
		IF object_id('GxSQLLockDetection') IS null
		BEGIN
			-- if the table does not exist then create it
			CREATE TABLE GxSQLLockDetection (groupid INTEGER, isFromODBC INTEGER, timedetected DATETIME, spid INTEGER, blockedBy INTEGER, waittime INTEGER, waittype INTEGER,
				objectid INTEGER, objectname VARCHAR(256), lastwaittype NVARCHAR(32), waitresource NVARCHAR(128), cpu INTEGER, physical_io INTEGER,
				memusage INTEGER, open_tran INTEGER, status NVARCHAR(64), hostprocess NVARCHAR(8), cmd NVARCHAR(128), LastCommand VARCHAR(max),
				last_batch DATETIME, login_time DATETIME, sql_handle BINARY(20), stmt_start INTEGER, stmt_end INTEGER, serialid INTEGER IDENTITY(1,1))
			-- create the index on the most frequently used column
			CREATE INDEX GxSQLLockDetection_groupid ON GxSQLLockDetection(groupid)
			CREATE INDEX GxSQLLockDetection_timedetected ON GxSQLLockDetection(timedetected)
		END
		IF object_id('GxSQLLockedObjects') IS null AND @showdetails = 1
		BEGIN
			CREATE TABLE GxSQLLockedObjects (groupid INTEGER, timedetected datetime, spid INTEGER, dbid INTEGER, objectid INTEGER, InId INTEGER, Type NVARCHAR(5), Resource NCHAR(33), Mode NVARCHAR(9), status NVARCHAR(32), ObjectName VARCHAR(256))
			-- create the index on the most frequently used column
			CREATE INDEX GxSQLLockedObjects_groupid on GxSQLLockedObjects(groupid)
			CREATE INDEX GxSQLLockedObjects_timedetected ON GxSQLLockedObjects(timedetected)
		END
	END
	IF @showdetails = 1
	BEGIN
		CREATE TABLE #locks (spid INTEGER, dbid INTEGER, objectid INTEGER, InId INTEGER, Type NVARCHAR(5), Resource NCHAR(33), Mode NVARCHAR(9), status NVARCHAR(32), ObjectName VARCHAR(256))
		INSERT INTO #locks (spid, dbid, objectid, InId, Type, Resource, Mode, status)
		EXEC sp_lock
		DELETE FROM #locks WHERE NOT EXISTS (SELECT * FROM #waitforgraph WHERE #waitforgraph.spid = #locks.spid)
		-- delete showAllRunningQueries rows that are not part of commserv database
		DELETE FROM #locks WHERE dbid <> @dbid
		UPDATE #locks SET objectname = ISNULL(OBJECT_NAME(objectid),'')
		SET @timeoccured = GETDATE()
		IF @outputToTable = 1
		BEGIN
			-- the group id is used to identify the set of rows that identify one problem
			SELECT @nextGroupId = IDENT_CURRENT('GxSQLLockDetection')
			INSERT INTO GxSQLLockDetection SELECT @nextGroupId, @isForODBC, @timeoccured, * FROM #waitforgraph
			INSERT INTO GxSQLLockedObjects SELECT @nextGroupId, @timeoccured, * FROM #locks
		END
		ELSE
		BEGIN
			-- print the output with the locks
			PRINT 'wait-for graph as of ' + CONVERT(VARCHAR(100),@timeoccured)
			SELECT * FROM #waitforgraph
			SELECT * FROM #locks ORDER BY spid
		END
		-- drop the temporary table
		DROP TABLE #locks
	END
	ELSE
	BEGIN
		SET @timeoccured = GETDATE()
		IF @outputToTable = 1
		BEGIN
			-- the group id is used to identify the set of rows that identify one problem
			SELECT @nextGroupId = IDENT_CURRENT('GxSQLLockDetection')
			INSERT INTO GxSQLLockDetection SELECT @nextGroupId, @isForODBC, @timeoccured, * FROM #waitforgraph
		END
		ELSE
		BEGIN
			-- print the output without the locks
			PRINT 'wait-for graph as of ' + CONVERT(VARCHAR(100),@timeoccured)
			-- following select ommits sql_handle as binary is not a supported datatype in the dblayer.
			SELECT 		spid, blockedBy, waittime, waittype,	objectid , objectname, lastwaittype, waitresource, cpu , physical_io ,
								memusage, open_tran, status, hostprocess, cmd, LastCommand,	last_batch, login_time,
								stmt_start, stmt_end
			FROM #waitforgraph
		END
	END
	IF (@isForODBC = 1)
	BEGIN
		SELECT @nextGroupId
	END
GO

IF EXISTS (select * from GxQscripts where name = 'CV_DetectLockingQueries')
	delete from GxQscripts where name = 'CV_DetectLockingQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_DetectLockingQueries')
	delete from GXDBVersions where aliasname = 'CV_DetectLockingQueries'
GO

insert into GXDBVersions values(2, 'CV_DetectLockingQueries',  '00010008003400010000', 'CV_DetectLockingQueries', '00010008003400010000')
GO

