

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CVDRBackup_Verify_License.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Nikhil Ramakrishnan
--	Date:   2020/09/19
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CVDRBackup_Verify_License.sp,v $ $Id: CVDRBackup_Verify_License.sp,v 1.1.2.1 2020/09/30 02:32:30 abhinawkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CVDRBackup_Verify_License')
BEGIN
	print '>>> Drop Stored Procedure: CVDRBackup_Verify_License <<<'
	drop procedure CVDRBackup_Verify_License
END
IF EXISTS (select * from GxQscripts where name='CVDRBackup_Verify_License')
	delete from GxQscripts where name = 'CVDRBackup_Verify_License'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Verify_License')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Verify_License'
GO
print '... Creating Procedure: CVDRBackup_Verify_License'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CVDRBackup_Verify_License
  @commcellGUID NVARCHAR(64),
  @returnCode INT OUTPUT
,
  @errorMsg NVARCHAR(255) = NULL OUTPUT
AS
BEGIN
	DECLARE @LGAccName NVARCHAR(255), @commcellIdHex NVARCHAR(16), @LGServiceType NVARCHAR(128)
	DECLARE @AzureAccount NVARCHAR(100) = NULL, @AzureSecretKey NVARCHAR(512) = NULL, @CopiesToRetain INT
	DECLARE @LGCommcellTable NVARCHAR(128) = NULL, @LGAccountTable NVARCHAR(128) = NULL
	DECLARE @LGQuery NVARCHAR(MAX) = NULL, @ParamDef NVARCHAR(512)
	-- Get registration and serial code
	SET @commcellGUID = replace(@commcellGUID,'-','')
	DECLARE @CCSerial NVARCHAR(30)
	SET @CCSerial = (select substring(@commcellGUID,1,4) + '-')
	SET @CCSerial = @CCSerial + (select substring(@commcellGUID,5,4) + '-')
	SET @CCSerial = @CCSerial + (select substring(@commcellGUID,9,4) + '-')
	SET @CCSerial = @CCSerial + (select substring(@commcellGUID,13,4) + '-')
	SET @CCSerial = @CCSerial + (select substring(@commcellGUID,17,6))
	DECLARE @CCRegCode NVARCHAR(15)
	SET @CCRegCode = (select substring(@commcellGUID,23,3) + '-')
	SET @CCRegCode = @CCRegCode + (select substring(@commcellGUID,26,3) + '-')
	SET @CCRegCode = @CCRegCode + (select substring(@commcellGUID,29,4))
	-- Get licensing table names
	SELECT @LGCommcellTable = value FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CVDRBackupLGCommcellTable'
	SELECT @LGAccountTable = value FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CVDRBackupLGAccountTable'
	IF @LGCommcellTable IS NULL OR @LGAccountTable IS NULL
	BEGIN
		SET @returnCode = 7
		SET @errorMsg = 'Unable to retrieve license information for CommCell due to a server error.'
		RETURN
	END
	SET @LGQuery = 'SELECT @LGAccNameOUT = LACCMA.name, @commcellIdHexOUT = LACCM.CommcellId, @LGServiceTypeOUT = LACCM.ServiceType
					FROM ' + @LGCommcellTable + ' LACCM WITH(NOLOCK)
					JOIN ' + @LGAccountTable + ' LACCMA WITH(NOLOCK)
					ON LACCMA.AccountGlobalId = LACCM.AccountGlobalId
					WHERE LACCM.serverID IS NOT NULL AND SerialCode = @CCSerialIN AND RegistrationCode = @CCRegCodeIN'
	SET @ParamDef = '@CCSerialIN NVARCHAR(30), @CCRegCodeIN NVARCHAR(15),
					@LGAccNameOUT NVARCHAR(255) OUTPUT, @commcellIdHexOUT NVARCHAR(16) OUTPUT,
					@LGServiceTypeOUT NVARCHAR(128) OUTPUT'
	-- Query LG
	BEGIN TRY
		EXEC sp_executesql
			@LGQuery,
			@ParamDef,
			@CCSerialIN = @CCSerial, @CCRegCodeIN = @CCRegCode,
			@LGAccNameOUT = @LGAccName OUTPUT, @commcellIdHexOUT = @commcellIdHex OUTPUT,
			@LGServiceTypeOUT = @LGServiceType OUTPUT
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @returnCode = 7
		SET @errorMsg = 'Unable to retrieve license information for CommCell.'
		RETURN
	END CATCH
	-- Get Azure account
	EXEC CVDRBackup_Storage_Rules @LGServiceType, @AzureAccount OUTPUT, @CopiesToRetain OUTPUT, @AzureSecretKey OUTPUT
	-- Select required info
	SELECT @LGAccName AS companyName, LOWER(@commcellIdHex) AS commcellIdHex, dbo.ConvertHexToInt(@commcellIdHex) AS commcellIdInt,
	@AzureAccount AS azureAccount, @AzureSecretKey AS azureSecretKey, @CopiesToRetain AS copiesToRetain
	SET @returnCode = 0
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CVDRBackup_Verify_License')
	delete from GxQscripts where name = 'CVDRBackup_Verify_License'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Verify_License')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Verify_License'
GO

insert into GXDBVersions values(2, 'CVDRBackup_Verify_License',  '00010001000200010000', 'CVDRBackup_Verify_License', '00010001000200010000')
GO

