

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CVDRBackup_Submit_Request.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Nikhil Ramakrishnan
--	Date:   2020/06/19
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CVDRBackup_Submit_Request.sp,v $ $Id: CVDRBackup_Submit_Request.sp,v 1.1.2.2 2020/09/17 18:27:07 abhinawkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CVDRBackup_Submit_Request')
BEGIN
	print '>>> Drop Stored Procedure: CVDRBackup_Submit_Request <<<'
	drop procedure CVDRBackup_Submit_Request
END
IF EXISTS (select * from GxQscripts where name='CVDRBackup_Submit_Request')
	delete from GxQscripts where name = 'CVDRBackup_Submit_Request'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Submit_Request')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Submit_Request'
GO
print '... Creating Procedure: CVDRBackup_Submit_Request'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CVDRBackup_Submit_Request
  @userId INTEGER,
  @commcellId VARCHAR(20),
  @setId INTEGER,
  @requestFlags INTEGER,
  @comments NVARCHAR(MAX),
  @rowId INT OUTPUT
,
  @returnCode INT OUTPUT
,
  @errorMsg NVARCHAR(255) = NULL OUTPUT
AS
BEGIN
	DECLARE @isCVEmployee BIT = 'false'
	DECLARE @ccid INTEGER = NULL
	DECLARE @hasCommcellAccess BIT = 'false'
	DECLARE @CVApproverAlias NVARCHAR(255)
	DECLARE @isSetValid BIT = 'false'
	DECLARE @setName NVARCHAR(512)
	DECLARE @InsertId TABLE (ID INT)
	DECLARE @companyId INT
	DECLARE @webconsoleUrl NVARCHAR(MAX)
	DECLARE @requestorEmail NVARCHAR(255)
	DECLARE @requestorName NVARCHAR(255)
	DECLARE @requestorLogin NVARCHAR(255)
	-- Check whether Set ID is valid
	IF EXISTS(SELECT 1 FROM DRBackup_Info WITH(NOLOCK) WHERE id = @setId AND isDeleted = 0)
	BEGIN
		SET @isSetValid = 'true'
	END
	IF @isSetValid = 'false'
	BEGIN
		SET @returnCode = 4
		SET @errorMsg = CONCAT('Invalid Set ID ', @setId, '.')
		RETURN
	END
	-- Check if a request already exists OR if user already has access to set
	IF EXISTS(SELECT 1 FROM DRBackup_Requests WITH(NOLOCK)
		WHERE requestor = @userId AND backupId = @setId AND approvalStatus IN (1,2) AND (validUpto IS NULL OR GETUTCDATE() < validUpto))
	BEGIN
		SET @returnCode = 3
		SET @errorMsg = 'A request has been previously submitted or access to this set has already been granted.'
		RETURN
	END
	SET @ccid = dbo.ConvertHexToInt(@commcellId)
	EXEC CVDRBackup_Check_CV_Employee @userId, @isCVEmployee OUTPUT
	IF @isCVEmployee = 'false'
	BEGIN
		-- Check whether user has access to CommCell
		IF EXISTS(SELECT 1
		FROM UMSecurityAssociations UA WITH(NOLOCK)
		JOIN APP_CommCell CC WITH(NOLOCK)
			ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0 AND cc.number = @ccid
		JOIN UMUserGroup UUG WITH(NOLOCK)
			ON UUG.groupId = UA.userOrGroupId AND UUG.userId = @userId
		JOIN UMGroupsProp UGP WITH(NOLOCK)
			ON UGP.componentNameId = UA.userOrGroupId AND UGP.attrName = 'Customer User Group')
		BEGIN
			SET @hasCommcellAccess = 'true'
		END
		-- Exit if no access
		IF @hasCommcellAccess = 'false'
		BEGIN
			SET @returnCode = 6
			SET @errorMsg = CONCAT('You are not authorized to submit an access request for CommCell ', @commcellId, '.')
			RETURN
		END
	END
	-- In case @isCVEmployee is 'true', requests can be submitted for any CommCell
	SELECT @CVApproverAlias = value from GXGlobalParam WITH(NOLOCK) WHERE name = 'CVDRBackupInternalApprovalAlias'
	-- Get Set name
	SELECT @setName = parentFolderName
	FROM DRBackup_Info WITH(NOLOCK) WHERE id = @setId
	-- Get Company ID
	SELECT @companyId = UG.id
	FROM UMSecurityAssociations UA WITH(NOLOCK)
	JOIN APP_CommCell CC WITH(NOLOCK)
		ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0
	JOIN UMGroups UG WITH(NOLOCK)
		ON UA.userOrGroupId = UG.id
	JOIN UMGroupsProp UGP WITH(NOLOCK)
		ON UGP.componentNameId = UA.userOrGroupId AND UGP.attrName = 'Customer User Group'
	WHERE cc.number = @ccid
	-- Get WebConsole URL
	SELECT @webconsoleUrl = value from GXGlobalParam WITH(NOLOCK) where name like 'WebConsoleURL'
	-- Get requestor details
	SELECT @requestorEmail = email, @requestorName = name, @requestorLogin = login FROM UMUsers WITH(NOLOCK) WHERE id = @userId
	-- All checks complete. Create a request record
	INSERT INTO DRBackup_Requests (backupId, requestor, requestorEmail, requestorComments, requestFlags, requestedTime, approvalStatus)
	OUTPUT inserted.id INTO @InsertId(ID)
	VALUES (@setId, @userId, @requestorEmail, @comments, @requestFlags, GETUTCDATE(), 1)
	IF EXISTS(SELECT 1 FROM @InsertId)
	BEGIN
		SET @rowId = (SELECT DISTINCT(ID) FROM @InsertId)
		SELECT requestorName, requestorEmail, isRequestorCVEmployee, CVApproverAlias, webconsoleUrl, companyId, commcellId, setId, setName FROM
		(SELECT COALESCE(NULLIF(@requestorName,''), NULLIF(@requestorLogin,'')) AS requestorName, @requestorEmail AS requestorEmail, @isCVEmployee AS isRequestorCVEmployee,
		@CVApproverAlias AS CVApproverAlias, @webconsoleUrl AS webconsoleUrl, @companyId AS companyId,
		@ccid AS commcellId, @setId AS setId, @setName AS setName) U
		SET @returnCode = 0
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CVDRBackup_Submit_Request')
	delete from GxQscripts where name = 'CVDRBackup_Submit_Request'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Submit_Request')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Submit_Request'
GO

insert into GXDBVersions values(2, 'CVDRBackup_Submit_Request',  '00010001000200020000', 'CVDRBackup_Submit_Request', '00010001000200020000')
GO

