

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CVDRBackup_Storage_Rules.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Nikhil Ramakrishnan
--	Date:   2020/09/19
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CVDRBackup_Storage_Rules.sp,v $ $Id: CVDRBackup_Storage_Rules.sp,v 1.1.2.1 2020/09/30 02:32:12 abhinawkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CVDRBackup_Storage_Rules')
BEGIN
	print '>>> Drop Stored Procedure: CVDRBackup_Storage_Rules <<<'
	drop procedure CVDRBackup_Storage_Rules
END
IF EXISTS (select * from GxQscripts where name='CVDRBackup_Storage_Rules')
	delete from GxQscripts where name = 'CVDRBackup_Storage_Rules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Storage_Rules')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Storage_Rules'
GO
print '... Creating Procedure: CVDRBackup_Storage_Rules'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CVDRBackup_Storage_Rules
  @LGServiceType NVARCHAR(128),
  @AzureAccount NVARCHAR(100) OUTPUT
,
  @CopiesToRetain INT OUTPUT
,
  @azureSecretKey NVARCHAR(512) OUTPUT
AS
BEGIN
	DECLARE @RulesTbl TABLE (ServiceType NVARCHAR(128), isDefault BIT, AzureAccount NVARCHAR(32), CopiesToRetain INT)
	DECLARE @CVDRBackupRules XML = NULL
	DECLARE @azureSecret TABLE (storageAcName VARCHAR(100), secretKey VARCHAR(512))
	-- Defaults
	DECLARE @AzureAccountDefault NVARCHAR(64) = 'cvdrbackup1'
	DECLARE @CopiesToKeepDefault INT = 1
	-- Parse rules
	BEGIN TRY
		SELECT @CVDRBackupRules = CAST(value AS XML) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CVDRBackupRules'
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @CVDRBackupRules = NULL
	END CATCH
	IF @CVDRBackupRules IS NOT NULL
	BEGIN
		INSERT INTO @RulesTbl (ServiceType, isDefault, AzureAccount, CopiesToRetain)
		(SELECT
		Tbl.Col.value('@serviceType', 'NVARCHAR(MAX)') AS ServiceType,
		CASE
			WHEN Tbl.Col.value('@default', 'BIT') = 'true' THEN 1
			ELSE 0
		END AS isDefault,
		Tbl.Col.value('AzureAccount[1]', 'NVARCHAR(32)') AS AzureAccount,
		Tbl.Col.value('CopiesToRetain[1]', 'INT') AS CopiesToRetain
		FROM @CVDRBackupRules.nodes('//Rule') Tbl(Col))
		-- Update defaults if any
		IF EXISTS(SELECT 1 FROM @RulesTbl WHERE isDefault = 1)
		BEGIN
			SELECT
			@AzureAccountDefault = COALESCE(NULLIF(LTRIM(RTRIM(AzureAccount)), ''), @AzureAccountDefault),
			@CopiesToKeepDefault = COALESCE(NULLIF(CopiesToRetain, 0), @CopiesToKeepDefault)
			FROM @RulesTbl WHERE isDefault = 1
		END
		-- Select values for input ServiceType
		SELECT @AzureAccount = AzureAccount, @CopiesToRetain = CopiesToRetain FROM @RulesTbl WHERE ServiceType = @LGServiceType
	END
	IF NULLIF(LTRIM(RTRIM(@AzureAccount)), '') IS NULL
	BEGIN
		SET @AzureAccount = @AzureAccountDefault
	END
	IF NULLIF(@CopiesToRetain, 0) IS NULL
	BEGIN
		SET @CopiesToRetain = @CopiesToKeepDefault
	END
	-- Set Azure key
	INSERT INTO @azureSecret (storageAcName, secretKey)
	(SELECT SUBSTRING(name, PATINDEX('%[_]%', name) + 1, 1024) , value
	FROM GXGlobalParam WITH(NOLOCK) WHERE name LIKE 'CVDRBackupAzureSecret[_]%')
	SELECT @azureSecretKey = secretKey FROM @azureSecret WHERE storageAcName = @AzureAccount
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CVDRBackup_Storage_Rules')
	delete from GxQscripts where name = 'CVDRBackup_Storage_Rules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Storage_Rules')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Storage_Rules'
GO

insert into GXDBVersions values(2, 'CVDRBackup_Storage_Rules',  '00010001000200010000', 'CVDRBackup_Storage_Rules', '00010001000200010000')
GO

