

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CVDRBackup_Get_Status.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CVDRBackup_Get_Status.sp,v $ $Id: CVDRBackup_Get_Status.sp,v 1.1.2.3 2020/08/18 05:45:20 abhinawkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CVDRBackup_Get_Status')
BEGIN
	print '>>> Drop Stored Procedure: CVDRBackup_Get_Status <<<'
	drop procedure CVDRBackup_Get_Status
END
IF EXISTS (select * from GxQscripts where name='CVDRBackup_Get_Status')
	delete from GxQscripts where name = 'CVDRBackup_Get_Status'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Get_Status')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Get_Status'
GO
print '... Creating Procedure: CVDRBackup_Get_Status'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CVDRBackup_Get_Status
  @userId INTEGER,	 
  @companyId INTEGER,
  @csGUID NVARCHAR(40)
AS
BEGIN
	DECLARE @isCVEmployee BIT = 'false'
	DECLARE @baseURL NVARCHAR(256) = 'cvdrbackup/#!/home/'
	DECLARE @URL NVARCHAR(256) = NULL
	DECLARE @lastUploadTime DATETIME = NULL
	DECLARE @uploadStatus INT = 0 -- 0 -> Uploading, 1 -> Uploaded Successfully, 2 -> Upload Failed, 3 -> Upload Disabled, 4 -> Completed with errors
	DECLARE @commcellID INT = 0
	DECLARE @CSDBFileName VARCHAR(30) = 'commserv' -- CS DB name
	DECLARE @uploadTimeoutWindow INT = 12 -- Number of hours to return 'Uploading' status for since upload started
	IF @companyId IS NULL OR @companyId = 0
		SET @companyId = NULL
	EXEC CVDRBackup_Check_CV_Employee @userId, @isCVEmployee OUTPUT
	IF NOT EXISTS(SELECT 1
	FROM DRBackup_Info D WITH(NOLOCK)
	JOIN App_CommCell CC WITH(NOLOCK)
		ON D.commcellID = CC.number WHERE cc.csGUID = @csGUID)
	BEGIN
		SET @uploadStatus = 3
	END
	IF @uploadStatus != 3
	BEGIN
		IF @isCVEmployee = 'false'
		BEGIN
			SELECT @URL = URL, @commcellID = commcellID, @lastUploadTime = DRLastUploadTime, @uploadStatus = uploadStatus FROM (
			SELECT TOP 1 @isCVEmployee as IsCVEmployee,  @baseURL + CONVERT(VARCHAR(20), UG.id) + '/' AS URL, cc.number AS commcellID
			, CASE WHEN DR.uploadCompleteTime IS NULL THEN DR.uploadInitTime ELSE DR.uploadCompleteTime END AS DRLastUploadTime
			, CASE
				-- Upload started but finalize not called for 'uploadTimeoutWindow' hours
				WHEN DR.uploadStatus = 0 AND (DR.uploadCompleteTime IS NULL OR DATEDIFF(HOUR, DR.uploadCompleteTime, GETUTCDATE()) > @uploadTimeoutWindow) THEN 4
				-- Finalize executed but nothing uploaded
				WHEN DR.uploadStatus = 1 AND (DR.fullFileInfo IS NULL OR DR.fullFileInfo.value('count(/Files/File)', 'INT') = 0) THEN 2
				-- Finalize executed but CSDB not uploaded
				WHEN DR.uploadStatus = 1 AND COALESCE((SELECT 'true' WHERE  DR.fullFileInfo.exist('(/Files/File[contains(lower-case(@name),sql:variable("@CSDBFileName"))])') = 1), 'false') = 'false' THEN 4
				-- Being processed by workflow
				WHEN DR.uploadStatus = 2 THEN 0
				ELSE DR.uploadStatus
			END AS uploadStatus
			FROM UMSecurityAssociations UA WITH(NOLOCK)
			JOIN APP_CommCell CC WITH(NOLOCK)
				ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0 AND cc.csGUID = @csGUID
			JOIN UMGroups UG WITH(NOLOCK)
				ON UA.userOrGroupId = UG.id AND (@companyId IS NULL OR UG.id = @companyId)
			JOIN UMUserGroup UUG WITH(NOLOCK)
				ON UUG.groupId = UG.id
			JOIN UMUsers U WITH(NOLOCK)
				ON U.id = UUG.userId
			JOIN UMGroupsProp UGP WITH(NOLOCK)
				ON UGP.componentNameId = UG.id AND UGP.attrName = 'Customer User Group'
			JOIN DRBackup_Info DR WITH(NOLOCK)
				ON DR.commcellID = CC.number AND DR.isDeleted = 0
			WHERE U.id = @userId
			ORDER BY DRLastUploadTime DESC) T
			IF @lastUploadTime IS NULL
				SET @uploadStatus = 0
		END
		ELSE
		BEGIN
			SELECT @URL = URL, @commcellID = commcellID, @lastUploadTime = DRLastUploadTime, @uploadStatus = uploadStatus FROM (
			SELECT TOP 1 @isCVEmployee as IsCVEmployee, @baseURL + CONVERT(VARCHAR(20), UG.id) + '/' AS URL, cc.number AS commcellID
			, CASE WHEN DR.uploadCompleteTime IS NULL THEN DR.uploadInitTime ELSE DR.uploadCompleteTime END AS DRLastUploadTime
			, CASE
				-- Upload started but finalize not called for 'uploadTimeoutWindow' hours
				WHEN DR.uploadStatus = 0 AND (DR.uploadCompleteTime IS NULL OR DATEDIFF(HOUR, DR.uploadCompleteTime, GETUTCDATE()) > @uploadTimeoutWindow) THEN 4
				-- Finalize executed but nothing uploaded
				WHEN DR.uploadStatus = 1 AND (DR.fullFileInfo IS NULL OR DR.fullFileInfo.value('count(/Files/File)', 'INT') = 0) THEN 2
				-- Finalize executed but CSDB not uploaded
				WHEN DR.uploadStatus = 1 AND COALESCE((SELECT 'true' WHERE  DR.fullFileInfo.exist('(/Files/File[contains(lower-case(@name),sql:variable("@CSDBFileName"))])') = 1), 'false') = 'false' THEN 4
				-- Being processed by workflow
				WHEN DR.uploadStatus = 2 THEN 0
				ELSE DR.uploadStatus
			END AS uploadStatus
			FROM UMSecurityAssociations UA WITH(NOLOCK)
			JOIN APP_CommCell CC WITH(NOLOCK)
				ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0 AND cc.csGUID = @csGUID
			JOIN UMGroups UG WITH(NOLOCK)
				ON UA.userOrGroupId = UG.id AND (@companyId IS NULL OR UG.id = @companyId)
			JOIN UMGroupsProp UGP WITH(NOLOCK)
				ON UGP.componentNameId = UG.id AND UGP.attrName = 'Customer User Group'
			JOIN DRBackup_Info DR WITH(NOLOCK)
				ON DR.commcellID = CC.number AND DR.isDeleted = 0
			ORDER BY uploadCompleteTime DESC) T
		END
	END
	SELECT @URL AS URL, @commcellID AS commcellID, @uploadStatus AS UploadStatus, @lastUploadTime AS DRLastUploadedTime
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CVDRBackup_Get_Status')
	delete from GxQscripts where name = 'CVDRBackup_Get_Status'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Get_Status')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Get_Status'
GO

insert into GXDBVersions values(2, 'CVDRBackup_Get_Status',  '00010001000200030000', 'CVDRBackup_Get_Status', '00010001000200030000')
GO

