

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CVDRBackup_Get_Requests.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Nikhil Ramakrishnan
--	Date:   2020/06/19
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CVDRBackup_Get_Requests.sp,v $ $Id: CVDRBackup_Get_Requests.sp,v 1.1.2.1 2020/07/05 02:42:03 abhinawkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CVDRBackup_Get_Requests')
BEGIN
	print '>>> Drop Stored Procedure: CVDRBackup_Get_Requests <<<'
	drop procedure CVDRBackup_Get_Requests
END
IF EXISTS (select * from GxQscripts where name='CVDRBackup_Get_Requests')
	delete from GxQscripts where name = 'CVDRBackup_Get_Requests'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Get_Requests')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Get_Requests'
GO
print '... Creating Procedure: CVDRBackup_Get_Requests'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CVDRBackup_Get_Requests
  @userId INTEGER,
  @companyId INTEGER,
  @commcellId VARCHAR(20),
  @setId INTEGER,
  @status INTEGER,
  @pageNo INTEGER,
  @pageSize INTEGER,
  @isCloudAdmin BIT,
  @approver BIT = 'false' OUTPUT
AS
BEGIN
	DECLARE @isCVEmployee BIT = 'false'
	DECLARE @ccid INTEGER = NULL
	IF @companyId IS NULL OR @companyId = 0
		SET @companyId = NULL
	IF @setId IS NULL OR @setId = 0
		SET @setId = NULL
	IF @status IS NULL OR @status = 0
		SET @status = NULL
	IF @pageNo IS NULL OR @pageNo = 0
		SET @pageNo = 1
	IF @pageSize IS NULL OR @pageSize = 0
		SET @pageSize = -1
	IF @commcellId IS NOT NULL AND @commcellId != ''
		SET @ccid = dbo.ConvertHexToInt(@commcellId)
	EXEC CVDRBackup_Check_CV_Employee @userId, @isCVEmployee OUTPUT
	SET @approver = @isCloudAdmin
	IF @isCVEmployee = 'false'
	BEGIN
		SELECT requestId, requestFlags, requestorName, requestorEmail, requestorComments,
		requestedTime, approvalStatus, approvalFlags, approverName, approverEmail,
		approverComments, approvalTime, validUpto, firstAccessTime, companyName, companyId, commcellId, setName, totalRows FROM
		(SELECT REQ.id AS requestId, REQ.requestFlags AS requestFlags, COALESCE(NULLIF(REQU.name,''), NULLIF(REQU.login,'')) AS requestorName, REQU.email AS requestorEmail,
		REQ.requestorComments AS requestorComments, REQ.requestedTime AS requestedTime, REQ.approvalStatus AS approvalStatus,
		REQ.approvalFlags as approvalFlags, COALESCE(NULLIF(REQAU.name,''), NULLIF(REQAU.login,'')) AS approverName, REQAU.email AS approverEmail, REQ.approverComments AS approverComments,
		REQ.approvalTime AS approvalTime, REQ.validUpto AS validUpto, REQ.firstAccessTime AS firstAccessTime, UG.id AS companyId,
		UG.name AS companyName, CC.number AS commcellId, DR.parentFolderName AS setName,
		ROW_NUMBER() OVER (ORDER BY REQ.id) AS RowNum, COUNT(REQ.id) OVER() totalRows
		FROM UMSecurityAssociations UA WITH(NOLOCK)
		JOIN APP_CommCell CC WITH(NOLOCK)
			ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0 AND (@ccid IS NULL OR cc.number = @ccid)
		JOIN UMGroups UG WITH(NOLOCK)
			ON UA.userOrGroupId = UG.id AND (@companyId IS NULL OR UG.id = @companyId)
		JOIN UMUserGroup UUG WITH(NOLOCK)
			ON UUG.groupId = UG.id
		JOIN UMUsers U WITH(NOLOCK)
			ON U.id = UUG.userId AND U.id = @userId
		JOIN UMGroupsProp UGP WITH(NOLOCK)
			ON UGP.componentNameId = UG.id AND UGP.attrName = 'Customer User Group'
		JOIN DRBackup_Info DR WITH(NOLOCK)
			ON DR.commcellID = CC.number AND DR.isDeleted = 0 AND DR.backupLevel =  1 AND (@setId IS NULL OR DR.id = @setId)
		JOIN DRBackup_Requests REQ WITH(NOLOCK)
			ON REQ.backupId = DR.id  AND (@approver = 'true' OR REQ.requestor = @userId) AND (@status IS NULL OR REQ.approvalStatus = @status)
		JOIN UMUsers REQU WITH(NOLOCK)
			ON REQU.id = REQ.requestor
		LEFT JOIN UMUsers REQAU WITH(NOLOCK)
			ON REQAU.id = REQ.approvedBy
		) V WHERE (@pageSize = -1) OR (RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize))
		ORDER BY companyName, commcellId, setName, requestedTime
	END
	ELSE
	BEGIN
		-- Check if user is internal approver
		EXEC CVDRBackup_Check_Approval_Rights @userId, NULL, NULL, @isCVEmployee, @approver OUTPUT, NULL
		SELECT requestId, requestFlags, requestorName, requestorEmail, requestorComments,
		requestedTime, approvalStatus, approvalFlags, approverName, approverEmail,
		approverComments, approvalTime, validUpto, firstAccessTime, companyName, companyId, commcellId, setName, totalRows FROM
		(SELECT REQ.id AS requestId, REQ.requestFlags AS requestFlags, COALESCE(NULLIF(REQU.name,''), NULLIF(REQU.login,'')) AS requestorName, REQU.email AS requestorEmail,
		REQ.requestorComments AS requestorComments, REQ.requestedTime AS requestedTime, REQ.approvalStatus AS approvalStatus,
		REQ.approvalFlags as approvalFlags, COALESCE(NULLIF(REQAU.name,''), NULLIF(REQAU.login,'')) AS approverName, REQAU.email AS approverEmail, REQ.approverComments AS approverComments,
		REQ.approvalTime AS approvalTime, REQ.validUpto AS validUpto, REQ.firstAccessTime AS firstAccessTime, UG.id AS companyId,
		UG.name AS companyName, CC.number AS commcellId, DR.parentFolderName AS setName,
		ROW_NUMBER() OVER (ORDER BY REQ.id) AS RowNum, COUNT(REQ.id) OVER() totalRows
		FROM UMSecurityAssociations UA WITH(NOLOCK)
		JOIN APP_CommCell CC WITH(NOLOCK)
			ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0 AND (@ccid IS NULL OR cc.number = @ccid)
		JOIN UMGroups UG WITH(NOLOCK)
			ON UA.userOrGroupId = UG.id AND (@companyId IS NULL OR UG.id = @companyId)
		JOIN UMGroupsProp UGP WITH(NOLOCK)
			ON UGP.componentNameId = UG.id AND UGP.attrName = 'Customer User Group'
		JOIN DRBackup_Info DR WITH(NOLOCK)
			ON DR.commcellID = CC.number AND DR.isDeleted = 0 AND DR.backupLevel =  1 AND (@setId IS NULL OR DR.id = @setId)
		JOIN DRBackup_Requests REQ WITH(NOLOCK)
			ON REQ.backupId = DR.id  AND (@approver = 'true' OR REQ.requestor = @userId) AND (@status IS NULL OR REQ.approvalStatus = @status)
		JOIN UMUsers REQU WITH(NOLOCK)
			ON REQU.id = REQ.requestor
		LEFT JOIN UMUsers REQAU WITH(NOLOCK)
			ON REQAU.id = REQ.approvedBy
		) V WHERE (@pageSize = -1) OR (RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize))
		ORDER BY companyName, commcellId, setName, requestedTime
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CVDRBackup_Get_Requests')
	delete from GxQscripts where name = 'CVDRBackup_Get_Requests'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Get_Requests')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Get_Requests'
GO

insert into GXDBVersions values(2, 'CVDRBackup_Get_Requests',  '00010001000200010000', 'CVDRBackup_Get_Requests', '00010001000200010000')
GO

