

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CVDRBackup_Create_Update_Job_Info.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Nikhil Ramakrishnan
--	Date:   2020/09/21
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CVDRBackup_Create_Update_Job_Info.sp,v $ $Id: CVDRBackup_Create_Update_Job_Info.sp,v 1.1.2.1 2020/09/30 02:32:09 abhinawkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CVDRBackup_Create_Update_Job_Info')
BEGIN
	print '>>> Drop Stored Procedure: CVDRBackup_Create_Update_Job_Info <<<'
	drop procedure CVDRBackup_Create_Update_Job_Info
END
IF EXISTS (select * from GxQscripts where name='CVDRBackup_Create_Update_Job_Info')
	delete from GxQscripts where name = 'CVDRBackup_Create_Update_Job_Info'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Create_Update_Job_Info')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Create_Update_Job_Info'
GO
print '... Creating Procedure: CVDRBackup_Create_Update_Job_Info'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CVDRBackup_Create_Update_Job_Info
  @commcellId INTEGER,
  @parentFolderName NVARCHAR(512) = NULL,
  @azureContainerName NVARCHAR(100) = NULL,
  @commcellJobId INT,
  @fullJobId INT = NULL,
  @backupLevel INT = NULL,
  @fullFileInfo XML = NULL,
  @insertOperation BIT,
  @returnCode INT OUTPUT
,
  @errorMsg NVARCHAR(255) = NULL OUTPUT
AS
BEGIN
	DECLARE @updatedRow TABLE (ID INT)
	IF(@insertOperation = 'true')
	BEGIN
		IF NOT EXISTS(SELECT 1 FROM DRBackup_Info WITH(NOLOCK) WHERE commcellID = @commcellId AND commcellJobID = @commcellJobId)
		BEGIN
			INSERT INTO DRBackup_Info
			(commcellID, parentFolderName, azureContainerName, commcellJobID, fullJobID, backupLevel, uploadStatus, isDeleted, modifiedTime)
			OUTPUT inserted.id INTO @updatedRow(ID)
			VALUES
			(@commcellId, @parentFolderName, @azureContainerName, @commcellJobId, @fullJobId, @backupLevel, 0, 0, GETUTCDATE())
			SET @returnCode = 0
		END
		ELSE
		BEGIN
			-- This is a duplicate request
			SET @returnCode = 3
		END
	END
	ELSE
	BEGIN
		IF EXISTS(SELECT 1 FROM DRBackup_Info WITH(NOLOCK) WHERE commcellID = @commcellId AND commcellJobID = @commcellJobId)
		BEGIN
			UPDATE DRBackup_info SET fullFileInfo = @fullFileInfo, uploadStatus = 1, uploadCompleteTime = GETUTCDATE()
			OUTPUT inserted.id INTO @updatedRow(ID)
			WHERE commcellId = @commcellId AND commcellJobID = @commcellJobId AND uploadStatus = 0
			SET @returnCode = CASE WHEN EXISTS(SELECT 1 FROM @updatedRow) THEN 0 ELSE 3 END
		END
		ELSE
		BEGIN
			SET @returnCode = 4
			SET @errorMsg = CONCAT('Could not find details for job [', @commcellJobId,'] on Cloud.')
		END
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CVDRBackup_Create_Update_Job_Info')
	delete from GxQscripts where name = 'CVDRBackup_Create_Update_Job_Info'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Create_Update_Job_Info')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Create_Update_Job_Info'
GO

insert into GXDBVersions values(2, 'CVDRBackup_Create_Update_Job_Info',  '00010001000200010000', 'CVDRBackup_Create_Update_Job_Info', '00010001000200010000')
GO

