

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CVDRBackup_Check_Download_Permission.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CVDRBackup_Check_Download_Permission.sp,v $ $Id: CVDRBackup_Check_Download_Permission.sp,v 1.1.2.4 2020/07/05 02:42:09 abhinawkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CVDRBackup_Check_Download_Permission')
BEGIN
	print '>>> Drop Stored Procedure: CVDRBackup_Check_Download_Permission <<<'
	drop procedure CVDRBackup_Check_Download_Permission
END
IF EXISTS (select * from GxQscripts where name='CVDRBackup_Check_Download_Permission')
	delete from GxQscripts where name = 'CVDRBackup_Check_Download_Permission'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Check_Download_Permission')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Check_Download_Permission'
GO
print '... Creating Procedure: CVDRBackup_Check_Download_Permission'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CVDRBackup_Check_Download_Permission
  @userId INTEGER,	 
  @setId INTEGER,
  @fileName NVARCHAR(512),
  @isCloudAdmin BIT,
  @returnCode INT OUTPUT
,
  @errorMsg NVARCHAR(255) = NULL OUTPUT
AS
BEGIN
	DECLARE @isCVEmployee BIT = 'false'
	DECLARE @numOfMinutesForTokenExpiry INTEGER = 0
	DECLARE @fileInfo XML = NULL
	DECLARE @hasDownloadPermissions BIT = 'false'
	DECLARE @accessValidity DATETIME = NULL
	DECLARE @requestId INT = NULL
	DECLARE @isInternalApprover BIT = 'false'
	DECLARE @azureStorageAcName VARCHAR(100) = NULL
	DECLARE @fileURL VARCHAR(MAX) = NULL
	DECLARE @azureSecretKey VARCHAR(MAX) = NULL
	DECLARE @azureSecret TABLE (storageAcName VARCHAR(100), secretKey VARCHAR(512))
	INSERT INTO @azureSecret SELECT SUBSTRING(name, PATINDEX('%[_]%', name) + 1, 1024) , value
								FROM GXGlobalParam WITH(NOLOCK) WHERE name LIKE 'CVDRBackupAzureSecret[_]%'
	SELECT @numOfMinutesForTokenExpiry = value FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CVDRBackupAzureSecretExpiryInMinutes'
	IF @numOfMinutesForTokenExpiry IS NULL OR @numOfMinutesForTokenExpiry = 0
		SET @numOfMinutesForTokenExpiry = 300
	IF @fileName IS NULL OR @fileName = ''
		SET @fileName = ''
	IF @setId IS NULL OR @setId = 0
		SET @setId = 0
	-- Check if user has permission to requested set
	IF @isCloudAdmin = 'false'
	BEGIN
		SELECT @hasDownloadPermissions = CASE WHEN approvalStatus = 2 THEN 'true' ELSE 'false' END,
		@accessValidity = DRREQ.validUpto, @requestId = DRREQ.id
		FROM DRBackup_Requests DRREQ WITH(NOLOCK)
		WHERE DRREQ.requestor = @userId AND DRREQ.backupId = @setId AND DRREQ.approvalStatus = 2 AND (validUpto IS NULL OR GETUTCDATE() < validUpto)
		ORDER BY validUpto DESC
	END
	ELSE
	BEGIN
		SELECT @hasDownloadPermissions = 'true'
	END
	-- Adjust token expiry in case access expires before default token validity
	IF @requestId IS NOT NULL AND @accessValidity IS NOT NULL
	BEGIN
		SET @numOfMinutesForTokenExpiry = CASE WHEN DATEDIFF(MINUTE, GETUTCDATE(), @accessValidity) < @numOfMinutesForTokenExpiry
		THEN DATEDIFF(MINUTE, GETUTCDATE(), @accessValidity) - 1 ELSE @numOfMinutesForTokenExpiry END
	END
	EXEC CVDRBackup_Check_CV_Employee @userId, @isCVEmployee OUTPUT
	IF @isCVEmployee = 'false'
	BEGIN
		IF @hasDownloadPermissions = 'false'
		BEGIN
			SET @returnCode = 6
			SET @errorMsg = 'You are not authorized to download files in this set.'
			RETURN
		END
		SELECT @fileInfo = CAST(fullFileInfo AS XML) FROM
		(SELECT  CAST((SELECT DR.fullFileInfo.query('(/Files/*)'), DR1.fullFileInfo.query('(/Files/*)') FOR XML PATH ('Files')) AS NVARCHAR(MAX)) fullFileInfo
		FROM UMSecurityAssociations UA  WITH(NOLOCK)
		JOIN APP_CommCell CC WITH(NOLOCK)
			ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0
		JOIN UMGroups UG WITH(NOLOCK)
			ON UA.userOrGroupId = UG.id
		JOIN UMUserGroup UUG WITH(NOLOCK)
			ON UUG.groupId = UG.id
		JOIN UMUsers U WITH(NOLOCK)
			ON U.id = UUG.userId
		JOIN UMGroupsProp UGP WITH(NOLOCK)
			ON UGP.componentNameId = UG.id AND UGP.attrName = 'Customer User Group'
		JOIN DRBackup_Info DR WITH(NOLOCK)
			ON DR.commcellID = CC.number AND DR.isDeleted = 0 AND DR.id = @setId
		LEFT JOIN DRBackup_Info DR1 WITH(NOLOCK)
			ON DR.commcellJobID = DR1.fullJobID AND DR1.isDeleted = 0
		WHERE U.id = @userId) T
	END
	ELSE
	BEGIN
		EXEC CVDRBackup_Check_Approval_Rights @userId, NULL, NULL, @isCVEmployee, @isInternalApprover OUTPUT, NULL
		SET @hasDownloadPermissions = @hasDownloadPermissions | @isInternalApprover
		IF @hasDownloadPermissions = 'false'
		BEGIN
			SET @returnCode = 6
			SET @errorMsg = 'You are not authorized to download files in this set.'
			RETURN
		END
		SELECT @fileInfo = CAST(fullFileInfo AS XML) FROM
		(SELECT  CAST((SELECT DR.fullFileInfo.query('(/Files/*)'), DR1.fullFileInfo.query('(/Files/*)') FOR XML PATH ('Files')) AS NVARCHAR(MAX)) fullFileInfo
		FROM UMSecurityAssociations UA  WITH(NOLOCK)
		JOIN APP_CommCell CC WITH(NOLOCK)
			ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0
		JOIN UMGroups UG WITH(NOLOCK)
			ON UA.userOrGroupId = UG.id
		JOIN UMGroupsProp UGP WITH(NOLOCK)
			ON UGP.componentNameId = UG.id AND UGP.attrName = 'Customer User Group'
		JOIN DRBackup_Info DR WITH(NOLOCK)
			ON DR.commcellID = CC.number AND DR.isDeleted = 0 AND DR.id = @setId
		LEFT JOIN DRBackup_Info DR1 WITH(NOLOCK)
			ON DR.commcellJobID = DR1.fullJobID AND DR1.isDeleted = 0) T
	END
	SELECT @fileURL = @fileInfo.value('(/Files/File[@name=sql:variable("@fileName")]/@url)[1]', 'nvarchar(max)')
	SET @azureStorageAcName = SUBSTRING(@fileURL, CHARINDEX('//', @fileURL) + 2,  CHARINDEX('.', @fileURL) - CHARINDEX('//', @fileURL) - 2)
	SELECT @azureSecretKey = secretKey FROM @azureSecret WHERE storageAcName = @azureStorageAcName
	-- Update first access time
	IF @requestId IS NOT NULL
	BEGIN
		UPDATE DRBackup_Requests SET firstAccessTime = GETUTCDATE(), modifiedTime = GETUTCDATE() WHERE id = @requestId AND firstAccessTime IS NULL
	END
	SET @returnCode = 0
	SELECT @fileURL AS fileURL, @azureSecretKey AS azureSecretKey, @numOfMinutesForTokenExpiry AS numOfMinutesForTokenExpiry
			, @azureStorageAcName AS azureStorageAcName
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CVDRBackup_Check_Download_Permission')
	delete from GxQscripts where name = 'CVDRBackup_Check_Download_Permission'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Check_Download_Permission')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Check_Download_Permission'
GO

insert into GXDBVersions values(2, 'CVDRBackup_Check_Download_Permission',  '00010001000200040000', 'CVDRBackup_Check_Download_Permission', '00010001000200040000')
GO

