

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CVDRBackup_Check_Approval_Rights.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Nikhil Ramakrishnan
--	Date:   2020/06/19
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CVDRBackup_Check_Approval_Rights.sp,v $ $Id: CVDRBackup_Check_Approval_Rights.sp,v 1.1.2.1 2020/07/05 02:41:54 abhinawkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CVDRBackup_Check_Approval_Rights')
BEGIN
	print '>>> Drop Stored Procedure: CVDRBackup_Check_Approval_Rights <<<'
	drop procedure CVDRBackup_Check_Approval_Rights
END
IF EXISTS (select * from GxQscripts where name='CVDRBackup_Check_Approval_Rights')
	delete from GxQscripts where name = 'CVDRBackup_Check_Approval_Rights'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Check_Approval_Rights')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Check_Approval_Rights'
GO
print '... Creating Procedure: CVDRBackup_Check_Approval_Rights'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CVDRBackup_Check_Approval_Rights
  @userId INTEGER,	 
  @ccid INTEGER,
  @isCloudAdmin BIT,
  @isCVEmployee BIT,
  @hasCommcellApprovalRights BIT = 'false' OUTPUT
,
  @CVApproverAlias NVARCHAR(255) = NULL OUTPUT
AS
BEGIN
	DECLARE @hasCommcellAccess BIT = 'false'
	DECLARE @commvaultDomainName NVARCHAR(255)
	SELECT @CVApproverAlias = value from GXGlobalParam WITH(NOLOCK) WHERE name = 'CVDRBackupInternalApprovalAlias'
	IF @isCVEmployee = 'false'
	BEGIN
		IF EXISTS(SELECT 1
		FROM UMSecurityAssociations UA WITH(NOLOCK)
		JOIN APP_CommCell CC WITH(NOLOCK)
			ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0 AND cc.number = @ccid
		JOIN UMUserGroup UUG WITH(NOLOCK)
			ON UUG.groupId = UA.userOrGroupId AND UUG.userId = @userId
		JOIN UMGroupsProp UGP WITH(NOLOCK)
			ON UGP.componentNameId = UA.userOrGroupId AND UGP.attrName = 'Customer User Group')
		BEGIN
			SET @hasCommcellAccess = 'true'
		END
		-- Approver if has access to CommCell and is cloud admin
		SELECT @hasCommcellApprovalRights = @hasCommcellAccess & @isCloudAdmin
	END
	ELSE
	BEGIN
		SELECT @commvaultDomainName = value from GXGlobalParam WITH(NOLOCK) WHERE name = 'CommvaultDomainName'
		IF EXISTS(SELECT 1
		FROM UMUserGroup UG WITH(NOLOCK)
		JOIN UMGroups U WITH(NOLOCK)
			ON UG.groupId = U.id
		JOIN UMDSProviders UP WITH(NOLOCK)
			ON UP.id = U.umdsProviderId AND UP.domainName = @commvaultDomainName
		JOIN UMUsers UM  WITH(NOLOCK)
			ON UM.id = UG.userId
		WHERE U.email = @CVApproverAlias AND UM.id = @userId)
		BEGIN
			SET @hasCommcellApprovalRights = 'true'
		END
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CVDRBackup_Check_Approval_Rights')
	delete from GxQscripts where name = 'CVDRBackup_Check_Approval_Rights'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Check_Approval_Rights')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Check_Approval_Rights'
GO

insert into GXDBVersions values(2, 'CVDRBackup_Check_Approval_Rights',  '00010001000200010000', 'CVDRBackup_Check_Approval_Rights', '00010001000200010000')
GO

