

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CVDRBackup_Approve_Deny_Request.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Nikhil Ramakrishnan
--	Date:   2020/06/19
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CVDRBackup_Approve_Deny_Request.sp,v $ $Id: CVDRBackup_Approve_Deny_Request.sp,v 1.1.2.2 2020/09/17 18:27:04 abhinawkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CVDRBackup_Approve_Deny_Request')
BEGIN
	print '>>> Drop Stored Procedure: CVDRBackup_Approve_Deny_Request <<<'
	drop procedure CVDRBackup_Approve_Deny_Request
END
IF EXISTS (select * from GxQscripts where name='CVDRBackup_Approve_Deny_Request')
	delete from GxQscripts where name = 'CVDRBackup_Approve_Deny_Request'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Approve_Deny_Request')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Approve_Deny_Request'
GO
print '... Creating Procedure: CVDRBackup_Approve_Deny_Request'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CVDRBackup_Approve_Deny_Request
  @userId INTEGER,	 
  @requestId INTEGER,
  @approvalType INTEGER,
  @validUpto DATETIME,
  @comments NVARCHAR(MAX),
  @isCloudAdmin BIT,
  @returnCode INT OUTPUT
,
  @errorMsg NVARCHAR(255) = NULL OUTPUT
AS
BEGIN
	DECLARE @isValidRequest BIT = 'false'
	DECLARE @isCVEmployee BIT = 'false'
	DECLARE @isRequestorCVEmployee BIT = 'false'
	DECLARE @ccid INTEGER = NULL
	DECLARE @hasCommcellApprovalRights BIT = 'false'
	DECLARE @CVApproverAlias NVARCHAR(255)
	DECLARE @requestor INT
	DECLARE @companyId INT
	DECLARE @setId INTEGER = NULL
	DECLARE @setName NVARCHAR(512)
	DECLARE @webconsoleUrl NVARCHAR(MAX)
	DECLARE @UpdateId TABLE (ID INT)
	IF EXISTS(SELECT 1 FROM DRBackup_Requests WITH(NOLOCK) WHERE id = @requestId)
	BEGIN
		SET @isValidRequest = 'true'
	END
	-- Exit if invalid
	IF @isValidRequest = 'false'
	BEGIN
		SET @returnCode = 4
		SET @errorMsg = CONCAT('Request ID ', @requestId, ' does not exist.')
		RETURN
	END
	EXEC CVDRBackup_Check_CV_Employee @userId, @isCVEmployee OUTPUT
	SELECT @ccid = DR.commcellID, @setId = DR.id, @setName = DR.parentFolderName, @requestor = DRREQ.requestor
	FROM DRBackup_Requests DRREQ WITH(NOLOCK)
	JOIN DRBackup_Info DR WITH(NOLOCK)
		ON DRREQ.backupId = DR.id
	WHERE DRREQ.id = @requestId
	EXEC CVDRBackup_Check_CV_Employee @requestor, @isRequestorCVEmployee OUTPUT
	EXEC CVDRBackup_Check_Approval_Rights @userId, @ccid, @isCloudAdmin, @isCVEmployee, @hasCommcellApprovalRights OUTPUT, @CVApproverAlias OUTPUT
	-- Exit if no access
	IF @hasCommcellApprovalRights = 'false'
	BEGIN
		SET @returnCode = 6
		SET @errorMsg = 'You are not authorized to approve/deny this request.'
		RETURN
	END
	-- All checks complete. Update request record.
	UPDATE DRBackup_Requests
	SET approvalStatus = @approvalType, approvalFlags = requestFlags, approvedBy = @userId, approverComments = @comments,
	approvalTime = GETUTCDATE(), validUpto = @validUpto, modifiedTime = GETUTCDATE()
	OUTPUT inserted.id INTO @UpdateId(ID)
	WHERE id = @requestId
	-- Get Company ID
	SELECT @companyId = UG.id
	FROM UMSecurityAssociations UA WITH(NOLOCK)
	JOIN APP_CommCell CC WITH(NOLOCK)
		ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0
	JOIN UMGroups UG WITH(NOLOCK)
		ON UA.userOrGroupId = UG.id
	JOIN UMGroupsProp UGP WITH(NOLOCK)
		ON UGP.componentNameId = UA.userOrGroupId AND UGP.attrName = 'Customer User Group'
	WHERE cc.number = @ccid
	-- Get WebConsole URL
	SELECT @webconsoleUrl = value from GXGlobalParam WITH(NOLOCK) where name like 'WebConsoleURL'
	IF EXISTS(SELECT 1 FROM @UpdateId)
	BEGIN
		SELECT requestorName, requestorEmail, isRequestorCVEmployee, approverName, approverEmail, isApproverCVEmployee, CVApproverAlias, webconsoleUrl, companyId, commcellId, setId, setName FROM
		(SELECT COALESCE(NULLIF(REQU.name,''), NULLIF(REQU.login,'')) AS requestorName, REQU.email AS requestorEmail, @isRequestorCVEmployee AS isRequestorCVEmployee,
		COALESCE(NULLIF(APRU.name,''), NULLIF(APRU.login,'')) AS approverName, APRU.email AS approverEmail, @isCVEmployee AS isApproverCVEmployee, @CVApproverAlias AS CVApproverAlias,
		@webconsoleUrl AS webconsoleUrl, @companyId AS companyId, @ccid AS commcellId, @setId AS setId, @setName AS setName
		FROM UMUsers REQU WITH(NOLOCK) JOIN UMUsers APRU WITH(NOLOCK)
			ON REQU.id = @requestor AND APRU.id = @userId) S
		SET @returnCode = 0
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CVDRBackup_Approve_Deny_Request')
	delete from GxQscripts where name = 'CVDRBackup_Approve_Deny_Request'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackup_Approve_Deny_Request')
	delete from GXDBVersions where aliasname = 'CVDRBackup_Approve_Deny_Request'
GO

insert into GXDBVersions values(2, 'CVDRBackup_Approve_Deny_Request',  '00010001000200020000', 'CVDRBackup_Approve_Deny_Request', '00010001000200020000')
GO

