

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CVDRBackupInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CVDRBackupInfo.sp,v $ $Id: CVDRBackupInfo.sp,v 1.1.2.5 2020/09/02 14:27:09 abhinawkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CVDRBackupInfo')
BEGIN
	print '>>> Drop Stored Procedure: CVDRBackupInfo <<<'
	drop procedure CVDRBackupInfo
END
IF EXISTS (select * from GxQscripts where name='CVDRBackupInfo')
	delete from GxQscripts where name = 'CVDRBackupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackupInfo')
	delete from GXDBVersions where aliasname = 'CVDRBackupInfo'
GO
print '... Creating Procedure: CVDRBackupInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CVDRBackupInfo
  @userId INTEGER,	 
  @companyId INTEGER,
  @commcellId VARCHAR(20),
  @pageNo INTEGER,
  @pageSize INTEGER,
  @isCloudAdmin BIT
AS
BEGIN
	DECLARE @isCVEmployee BIT = 'false'
	DECLARE @ccid INTEGER = NULL
	DECLARE @isApprover BIT = @isCloudAdmin
	IF @companyId IS NULL OR @companyId = 0
		SET @companyId = NULL
	IF @pageNo IS NULL OR @pageNo = 0
		SET @pageNo = 1
	IF @pageSize IS NULL OR @pageSize = 0
		SET @pageSize = -1
	IF @commcellId IS NOT NULL AND @commcellId != ''
		SET @ccid = dbo.ConvertHexToInt(@commcellId)
	EXEC CVDRBackup_Check_CV_Employee @userId, @isCVEmployee OUTPUT
	IF @isCVEmployee = 'false'
	BEGIN
		SELECT  IsCVEmployee, isApprover, SetId, company, companyId, commcellId, parentFolderName, CAST(fullFileInfo AS XML) fullFileInfo,
		uploadCompleteTime, setModifiedTime, commcellJobID, accessStatus, RowNum FROM
		(SELECT DISTINCT @isCVEmployee as IsCVEmployee, @isApprover AS isApprover,DR.id AS SetId, UG.name AS company, UG.id AS companyId, cc.number as commcellId, DR.parentFolderName,
		CAST((SELECT DR.fullFileInfo.query('(/Files/*)'), T.fullFileInfo.query('(/Files/*)') FOR XML PATH ('Files')) AS NVARCHAR(MAX)) fullFileInfo,
		DR.uploadCompleteTime,
		CASE WHEN COALESCE(T.uploadCompleteTime, '1970-01-01') > DR.uploadCompleteTime THEN T.uploadCompleteTime ELSE DR.uploadCompleteTime END AS setModifiedTime,
		DR.commcellJobID,
		CASE WHEN @isApprover = 'true' THEN 2 ELSE COALESCE(REQ.approvalStatus, 0) END AS accessStatus,
		ROW_NUMBER() OVER (ORDER BY DR.id) AS RowNum
		FROM UMSecurityAssociations UA WITH(NOLOCK)
		JOIN APP_CommCell CC WITH(NOLOCK)
			ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0 AND (@ccid IS NULL OR cc.number = @ccid)
		JOIN UMGroups UG WITH(NOLOCK)
			ON UA.userOrGroupId = UG.id AND (@companyId IS NULL OR UG.id = @companyId)
		JOIN UMUserGroup UUG WITH(NOLOCK)
			ON UUG.groupId = UG.id
		JOIN UMUsers U WITH(NOLOCK)
			ON U.id = UUG.userId
		JOIN UMGroupsProp UGP WITH(NOLOCK)
			ON UGP.componentNameId = UG.id AND UGP.attrName = 'Customer User Group'
		JOIN DRBackup_Info DR WITH(NOLOCK)
			ON DR.commcellID = CC.number AND DR.isDeleted = 0 AND DR.backupLevel =  1
		OUTER APPLY (SELECT TOP 1 D1.* FROM DRBackup_Info D1  WITH(NOLOCK) WHERE
					D1.commcellID = CC.number AND D1.fullJobID = DR.commcellJobID AND
					D1.fullJobID != 0 AND D1.backupLevel = 4 AND D1.isDeleted = 0 ORDER BY D1.commcellJobID DESC) T
		OUTER APPLY (SELECT TOP 1 DRREQ.approvalStatus FROM DRBackup_Requests DRREQ WITH(NOLOCK) WHERE
					DRREQ.requestor = @userId AND DRREQ.backupId = DR.id AND DRREQ.approvalStatus IN (1,2) AND (validUpto IS NULL OR GETUTCDATE() < validUpto)
					ORDER BY approvalStatus DESC, validUpto DESC) REQ
		WHERE U.id = @userId ) T  WHERE (@pageSize = -1) OR (RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize))
		ORDER BY company, commcellId, parentFolderName, commcellJobID, uploadCompleteTime
	END
	ELSE
	BEGIN
		EXEC CVDRBackup_Check_Approval_Rights @userId, NULL, NULL, @isCVEmployee, @isApprover OUTPUT, NULL
		SELECT  IsCVEmployee, isApprover, SetId, company, companyId, commcellId, parentFolderName, CAST(fullFileInfo AS XML) fullFileInfo,
		uploadCompleteTime, setModifiedTime, commcellJobID, accessStatus, RowNum FROM
		(SELECT DISTINCT @isCVEmployee as IsCVEmployee, @isApprover AS isApprover, DR.id AS SetId, UG.name AS company, UG.id AS companyId, cc.number as commcellId, DR.parentFolderName,
		CAST((SELECT DR.fullFileInfo.query('(/Files/*)'), T.fullFileInfo.query('(/Files/*)') FOR XML PATH ('Files')) AS NVARCHAR(MAX)) fullFileInfo,
		DR.uploadCompleteTime,
		CASE WHEN COALESCE(T.uploadCompleteTime, '1970-01-01') > DR.uploadCompleteTime THEN T.uploadCompleteTime ELSE DR.uploadCompleteTime END AS setModifiedTime,
		DR.commcellJobID,
		CASE WHEN @isApprover = 'true' THEN 2 ELSE COALESCE(REQ.approvalStatus, 0) END AS accessStatus,
		ROW_NUMBER() OVER (ORDER BY DR.id) AS RowNum
		FROM UMSecurityAssociations UA WITH(NOLOCK)
		JOIN APP_CommCell CC WITH(NOLOCK)
			ON UA.entityId1 = CC.clientId AND UA.entityType1 = 3 AND UA.isUser = 0 AND (@ccid IS NULL OR cc.number = @ccid)
		JOIN UMGroups UG WITH(NOLOCK)
			ON UA.userOrGroupId = UG.id AND (@companyId IS NULL OR UG.id = @companyId)
		JOIN UMGroupsProp UGP WITH(NOLOCK)
			ON UGP.componentNameId = UG.id AND UGP.attrName = 'Customer User Group'
		JOIN DRBackup_Info DR WITH(NOLOCK)
			ON DR.commcellID = CC.number AND DR.isDeleted = 0 AND DR.backupLevel = 1
		OUTER APPLY (SELECT TOP 1 D1.* FROM DRBackup_Info D1  WITH(NOLOCK) WHERE
						D1.commcellID = CC.number AND D1.fullJobID = DR.commcellJobID AND
						D1.fullJobID != 0 AND D1.backupLevel = 4 AND D1.isDeleted = 0 ORDER BY D1.commcellJobID DESC) T
		OUTER APPLY (SELECT TOP 1 DRREQ.approvalStatus FROM DRBackup_Requests DRREQ WITH(NOLOCK) WHERE
					DRREQ.requestor = @userId AND DRREQ.backupId = DR.id AND DRREQ.approvalStatus IN (1,2) AND (validUpto IS NULL OR GETUTCDATE() < validUpto)
					ORDER BY approvalStatus DESC, validUpto DESC) REQ
		) T WHERE (@pageSize = -1) OR (RowNum BETWEEN ((@pageNo-1) * @pageSize) + 1 AND (@pageNo * @pageSize))
		ORDER BY company, commcellId, commcellJobID, parentFolderName, uploadCompleteTime
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CVDRBackupInfo')
	delete from GxQscripts where name = 'CVDRBackupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVDRBackupInfo')
	delete from GXDBVersions where aliasname = 'CVDRBackupInfo'
GO

insert into GXDBVersions values(2, 'CVDRBackupInfo',  '00010001000200050000', 'CVDRBackupInfo', '00010001000200050000')
GO

