

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CVAccounts_ssoUrlforClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		  Returns preferred SSO Login URL for a given client
--
-- ------------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CVAccounts_ssoUrlforClient <<<'

IF EXISTS (select * from sysobjects where name='CVAccounts_ssoUrlforClient')
	drop procedure CVAccounts_ssoUrlforClient
IF EXISTS (select * from GxQscripts where name='CVAccounts_ssoUrlforClient')
	delete from GxQscripts where name = 'CVAccounts_ssoUrlforClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVAccounts_ssoUrlforClient')
	delete from GXDBVersions where aliasname = 'CVAccounts_ssoUrlforClient'
GO
print '... Creating Procedure: CVAccounts_ssoUrlforClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CVAccounts_ssoUrlforClient
  @client varchar(max)
AS
  DECLARE @xmlText XML
declare @WebAppUrlInfoTbl table
(
appURL     nvarchar(MAX),
appType    integer,
enabled		integer
)
DECLARE @webAppTypes   integer = 1
DECLARE @processinginstructioninfo XML = ''
DECLARE @errorCode  integer = 0
DECLARE @errorString varchar(max) = ''
DECLARE @GXGlobalParamUrl varchar(max) =''
DECLARE @error XML = ''
DECLARE @webAppUrlList XML = ''
DECLARE @clients int = (select id from app_client where name = @client)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
Insert into @WebAppUrlInfoTbl
select TOP 1 stringVal, @webAppTypes,longVal from APP_ComponentProp ACPT join APP_ClientGroupAssoc CGA on CGA.clientGroupId = ACPT.componentId
					where CGA.clientId = @clients AND
					ACPT.modified = 0 AND
ACPT.propertyTypeId = 1035 AND
ACPT.componentType = 8
					order by ACPT.created asc
--Enabled
if exists(select 1 from @WebAppUrlInfoTbl where enabled=1 )
begin
	SET @webAppUrlList = (select appURL as "@url" ,
					(select @webAppTypes as '@val' for xml path('webAppType'),type)
					from @WebAppUrlInfoTbl
					FOR XML PATH ('webAppUrlInfo'))
end
else if exists(select 1 from GXGlobalParam where name = 'Enable CVAccountsSsoUrl' and value = 1)
begin
	--No Entry in App_componentProp with feature enabled, Fetch from GXGlobalParam
	SET @GXGlobalParamUrl = (select value as "@url" from GXGlobalParam where name = 'CVAccountsSsoUrl')
	SET @webAppUrlList = (select @GXGlobalParamUrl as '@url' ,
						(select @webAppTypes as '@val' for xml path('webAppType'),type)
						FOR XML PATH ('webAppUrlInfo'))
end
else
begin
	--URL is not set neither at Commserve level nor at client group level
	SET @webAppUrlList = (select '' as "@url" ,
						(select @webAppTypes as '@val' for xml path('webAppType'),type)
						from @WebAppUrlInfoTbl
						FOR XML PATH ('webAppUrlInfo'))
end
SET @error = (SELECT @errorCode   AS '@errorCode', @errorString AS '@errorString' FOR xml PATH('error'))
SET @xmlText = ( SELECT ISNULL(@error,''),
						ISNULL(@webAppUrlList,'')
				 FOR XML PATH(''), ROOT('App_GetWebconsoleUrlListResponse')
			   )
ret:
	select @xmlText as 'out_xml'
GO

IF EXISTS (select * from GxQscripts where name = 'CVAccounts_ssoUrlforClient')
	delete from GxQscripts where name = 'CVAccounts_ssoUrlforClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CVAccounts_ssoUrlforClient')
	delete from GXDBVersions where aliasname = 'CVAccounts_ssoUrlforClient'
GO

insert into GXDBVersions values(2, 'CVAccounts_ssoUrlforClient',  '00000000000000000000', 'CVAccounts_ssoUrlforClient', '00000000000000000000')
GO

